/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.client;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.io.Serializable;
import java.security.GeneralSecurityException;
import java.util.Comparator;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.PriorityBlockingQueue;
import java.util.concurrent.RejectedExecutionException;
import org.apache.bookkeeper.client.AsyncCallback;
import org.apache.bookkeeper.client.BKException;
import org.apache.bookkeeper.client.BookKeeper;
import org.apache.bookkeeper.client.LedgerHandle;
import org.apache.bookkeeper.client.LedgerMetadata;
import org.apache.bookkeeper.client.PendingAddOp;
import org.apache.bookkeeper.util.SafeRunnable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LedgerHandleAdv
extends LedgerHandle {
    static final Logger LOG = LoggerFactory.getLogger(LedgerHandleAdv.class);

    LedgerHandleAdv(BookKeeper bk, long ledgerId, LedgerMetadata metadata, BookKeeper.DigestType digestType, byte[] password) throws GeneralSecurityException, NumberFormatException {
        super(bk, ledgerId, metadata, digestType, password);
        this.pendingAddOps = new PriorityBlockingQueue<PendingAddOp>(10, new PendingOpsComparator());
    }

    @Override
    public long addEntry(long entryId, byte[] data) throws InterruptedException, BKException {
        return this.addEntry(entryId, data, 0, data.length);
    }

    @Override
    public long addEntry(long entryId, byte[] data, int offset, int length) throws InterruptedException, BKException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Adding entry {}", (Object)data);
        }
        CompletableFuture counter = new CompletableFuture();
        LedgerHandle.SyncAddCallback callback = new LedgerHandle.SyncAddCallback();
        this.asyncAddEntry(entryId, data, offset, length, callback, counter);
        try {
            return (Long)counter.get();
        }
        catch (ExecutionException err) {
            throw (BKException)err.getCause();
        }
    }

    @Override
    public void asyncAddEntry(long entryId, byte[] data, AsyncCallback.AddCallback cb, Object ctx) {
        this.asyncAddEntry(entryId, data, 0, data.length, cb, ctx);
    }

    @Override
    public void asyncAddEntry(long entryId, byte[] data, int offset, int length, AsyncCallback.AddCallback cb, Object ctx) {
        PendingAddOp op = new PendingAddOp(this, cb, ctx);
        op.setEntryId(entryId);
        if (entryId <= this.lastAddConfirmed || this.pendingAddOps.contains(op)) {
            LOG.error("Trying to re-add duplicate entryid:{}", (Object)entryId);
            cb.addComplete(-22, this, entryId, ctx);
            return;
        }
        this.doAsyncAddEntry(op, Unpooled.wrappedBuffer((byte[])data, (int)offset, (int)length), cb, ctx);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void doAsyncAddEntry(final PendingAddOp op, final ByteBuf data, final AsyncCallback.AddCallback cb, final Object ctx) {
        long currentLength;
        if (this.throttler != null) {
            this.throttler.acquire();
        }
        boolean wasClosed = false;
        LedgerHandleAdv ledgerHandleAdv = this;
        synchronized (ledgerHandleAdv) {
            if (this.metadata.isClosed()) {
                wasClosed = true;
                currentLength = 0L;
            } else {
                currentLength = this.addToLength(this.length);
                this.pendingAddOps.add(op);
            }
        }
        if (wasClosed) {
            try {
                this.bk.mainWorkerPool.submit(new SafeRunnable(){

                    @Override
                    public void safeRun() {
                        LOG.warn("Attempt to add to closed ledger: {}", (Object)LedgerHandleAdv.this.ledgerId);
                        cb.addComplete(-11, LedgerHandleAdv.this, op.getEntryId(), ctx);
                    }

                    public String toString() {
                        return String.format("AsyncAddEntryToClosedLedger(lid=%d)", LedgerHandleAdv.this.ledgerId);
                    }
                });
            }
            catch (RejectedExecutionException e) {
                cb.addComplete(this.bk.getReturnRc(-15), this, op.getEntryId(), ctx);
            }
            return;
        }
        try {
            this.bk.mainWorkerPool.submit(new SafeRunnable(){

                @Override
                public void safeRun() {
                    ByteBuf toSend = LedgerHandleAdv.this.macManager.computeDigestAndPackageForSending(op.getEntryId(), LedgerHandleAdv.this.lastAddConfirmed, currentLength, data);
                    try {
                        op.initiate(toSend, toSend.readableBytes());
                    }
                    finally {
                        toSend.release();
                    }
                }
            });
        }
        catch (RejectedExecutionException e) {
            cb.addComplete(this.bk.getReturnRc(-15), this, op.getEntryId(), ctx);
        }
    }

    @Override
    public void asyncAddEntry(ByteBuf data, AsyncCallback.AddCallback cb, Object ctx) {
        cb.addComplete(-100, this, -1L, ctx);
    }

    @Override
    public void asyncAddEntry(byte[] data, int offset, int length, AsyncCallback.AddCallback cb, Object ctx) {
        cb.addComplete(-100, this, -1L, ctx);
    }

    static class PendingOpsComparator
    implements Comparator<PendingAddOp>,
    Serializable {
        PendingOpsComparator() {
        }

        @Override
        public int compare(PendingAddOp o1, PendingAddOp o2) {
            return Long.compare(o1.entryId, o2.entryId);
        }
    }
}

