/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.stream.storage.impl.kv;

import com.google.common.collect.Lists;
import com.google.protobuf.ByteString;
import com.google.protobuf.UnsafeByteOperations;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufUtil;
import io.netty.buffer.Unpooled;
import java.util.List;
import java.util.concurrent.ExecutionException;
import org.apache.bookkeeper.api.kv.op.CompareOp;
import org.apache.bookkeeper.api.kv.op.CompareResult;
import org.apache.bookkeeper.api.kv.op.OpFactory;
import org.apache.bookkeeper.api.kv.result.Code;
import org.apache.bookkeeper.api.kv.result.DeleteResult;
import org.apache.bookkeeper.api.kv.result.IncrementResult;
import org.apache.bookkeeper.api.kv.result.PutResult;
import org.apache.bookkeeper.api.kv.result.RangeResult;
import org.apache.bookkeeper.api.kv.result.Result;
import org.apache.bookkeeper.api.kv.result.TxnResult;
import org.apache.bookkeeper.statelib.api.exceptions.MVCCStoreException;
import org.apache.bookkeeper.stream.proto.kv.KeyValue;
import org.apache.bookkeeper.stream.proto.kv.rpc.Compare;
import org.apache.bookkeeper.stream.proto.kv.rpc.DeleteRangeResponse;
import org.apache.bookkeeper.stream.proto.kv.rpc.IncrementResponse;
import org.apache.bookkeeper.stream.proto.kv.rpc.PutResponse;
import org.apache.bookkeeper.stream.proto.kv.rpc.RangeResponse;
import org.apache.bookkeeper.stream.proto.kv.rpc.ResponseHeader;
import org.apache.bookkeeper.stream.proto.kv.rpc.ResponseOp;
import org.apache.bookkeeper.stream.proto.kv.rpc.RoutingHeader;
import org.apache.bookkeeper.stream.proto.kv.rpc.TxnResponse;
import org.apache.bookkeeper.stream.proto.storage.StatusCode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class TableStoreUtils {
    private static final Logger log = LoggerFactory.getLogger(TableStoreUtils.class);
    static final byte SEP = 0;
    static final byte NO_ROUTING_KEY = 0;
    static final byte HAS_ROUTING_KEY = 1;

    static boolean hasRKey(ByteString rKey) {
        return null != rKey && rKey.size() > 0;
    }

    static byte[] newStoreKey(ByteString rKey, ByteString lKey) {
        boolean hasRkey = TableStoreUtils.hasRKey(rKey);
        int keyLen = hasRkey ? rKey.size() + lKey.size() + 2 : lKey.size() + 1;
        ByteBuf keyBuf = Unpooled.buffer((int)keyLen);
        if (hasRkey) {
            keyBuf.writeByte(1);
            keyBuf.writeBytes(rKey.asReadOnlyByteBuffer());
            keyBuf.writeByte(0);
            keyBuf.writeBytes(lKey.asReadOnlyByteBuffer());
        } else {
            keyBuf.writeByte(0);
            keyBuf.writeBytes(lKey.asReadOnlyByteBuffer());
        }
        return ByteBufUtil.getBytes((ByteBuf)keyBuf);
    }

    static ByteString getLKey(byte[] storeKey, ByteString rKey) {
        boolean hasRKey = TableStoreUtils.hasRKey(rKey);
        int lKeyOffset = hasRKey ? rKey.size() + 2 : 1;
        return UnsafeByteOperations.unsafeWrap((byte[])storeKey, (int)lKeyOffset, (int)(storeKey.length - lKeyOffset));
    }

    static StatusCode handleCause(Throwable cause) {
        if (cause instanceof ExecutionException) {
            return TableStoreUtils.handleCause(cause.getCause());
        }
        if (cause instanceof MVCCStoreException) {
            MVCCStoreException mse = (MVCCStoreException)cause;
            return TableStoreUtils.mvccCodeToStatusCode(mse.getCode());
        }
        return StatusCode.INTERNAL_SERVER_ERROR;
    }

    static StatusCode mvccCodeToStatusCode(Code code) {
        switch (code) {
            case OK: {
                return StatusCode.SUCCESS;
            }
            case INTERNAL_ERROR: {
                return StatusCode.INTERNAL_SERVER_ERROR;
            }
            case INVALID_ARGUMENT: {
                return StatusCode.BAD_REQUEST;
            }
            case ILLEGAL_OP: {
                return StatusCode.BAD_REQUEST;
            }
            case UNEXPECTED: {
                return StatusCode.UNEXPECTED;
            }
            case BAD_REVISION: {
                return StatusCode.BAD_REVISION;
            }
            case SMALLER_REVISION: {
                return StatusCode.BAD_REVISION;
            }
            case KEY_NOT_FOUND: {
                return StatusCode.KEY_NOT_FOUND;
            }
            case KEY_EXISTS: {
                return StatusCode.KEY_EXISTS;
            }
        }
        return StatusCode.INTERNAL_SERVER_ERROR;
    }

    static KeyValue newKeyValue(ByteString rKey, org.apache.bookkeeper.api.kv.result.KeyValue<byte[], byte[]> kv) {
        if (null == kv) {
            return null;
        }
        return KeyValue.newBuilder().setKey(TableStoreUtils.getLKey((byte[])kv.key(), rKey)).setValue(UnsafeByteOperations.unsafeWrap((byte[])((byte[])kv.value()))).setCreateRevision(kv.createRevision()).setModRevision(kv.modifiedRevision()).setVersion(kv.version()).setIsNumber(kv.isNumber()).setNumberValue(kv.numberValue()).build();
    }

    static PutResponse processPutResult(RoutingHeader routingHeader, PutResult<byte[], byte[]> result) {
        ByteString rKey = routingHeader.getRKey();
        PutResponse.Builder putRespBuilder = PutResponse.newBuilder().setHeader(ResponseHeader.newBuilder().setCode(TableStoreUtils.mvccCodeToStatusCode(result.code())).setRoutingHeader(routingHeader).build());
        if (null != result.prevKv()) {
            putRespBuilder = putRespBuilder.setPrevKv(TableStoreUtils.newKeyValue(rKey, (org.apache.bookkeeper.api.kv.result.KeyValue<byte[], byte[]>)result.prevKv()));
        }
        return putRespBuilder.build();
    }

    static IncrementResponse processIncrementResult(RoutingHeader routingHeader, IncrementResult<byte[], byte[]> result) {
        IncrementResponse.Builder putRespBuilder = IncrementResponse.newBuilder().setHeader(ResponseHeader.newBuilder().setCode(TableStoreUtils.mvccCodeToStatusCode(result.code())).setRoutingHeader(routingHeader).build()).setTotalAmount(result.totalAmount());
        return putRespBuilder.build();
    }

    static RangeResponse processRangeResult(RoutingHeader routingHeader, RangeResult<byte[], byte[]> result) {
        ByteString rKey = routingHeader.getRKey();
        return RangeResponse.newBuilder().setCount(result.count()).setHeader(ResponseHeader.newBuilder().setCode(TableStoreUtils.mvccCodeToStatusCode(result.code())).setRoutingHeader(routingHeader).build()).addAllKvs((Iterable)Lists.transform((List)result.kvs(), kv -> TableStoreUtils.newKeyValue(rKey, (org.apache.bookkeeper.api.kv.result.KeyValue<byte[], byte[]>)kv))).setMore(result.more()).build();
    }

    static DeleteRangeResponse processDeleteResult(RoutingHeader routingHeader, DeleteResult<byte[], byte[]> result) {
        ByteString rKey = routingHeader.getRKey();
        return DeleteRangeResponse.newBuilder().setHeader(ResponseHeader.newBuilder().setCode(TableStoreUtils.mvccCodeToStatusCode(result.code())).setRoutingHeader(routingHeader).build()).setDeleted(result.numDeleted()).addAllPrevKvs((Iterable)Lists.transform((List)result.prevKvs(), kv -> TableStoreUtils.newKeyValue(rKey, (org.apache.bookkeeper.api.kv.result.KeyValue<byte[], byte[]>)kv))).build();
    }

    static TxnResponse processTxnResult(RoutingHeader routingHeader, TxnResult<byte[], byte[]> txnResult) {
        return TxnResponse.newBuilder().setHeader(ResponseHeader.newBuilder().setCode(TableStoreUtils.mvccCodeToStatusCode(txnResult.code())).setRoutingHeader(routingHeader).build()).setSucceeded(txnResult.isSuccess()).addAllResponses((Iterable)Lists.transform((List)txnResult.results(), result -> TableStoreUtils.processTxnResult(routingHeader, (Result<byte[], byte[]>)result))).build();
    }

    static ResponseOp processTxnResult(RoutingHeader routingHeader, Result<byte[], byte[]> result) {
        ResponseOp.Builder respBuilder = ResponseOp.newBuilder();
        switch (result.type()) {
            case PUT: {
                PutResult putResult = (PutResult)result;
                respBuilder.setResponsePut(TableStoreUtils.processPutResult(routingHeader, (PutResult<byte[], byte[]>)putResult));
                break;
            }
            case DELETE: {
                DeleteResult delResult = (DeleteResult)result;
                respBuilder.setResponseDeleteRange(TableStoreUtils.processDeleteResult(routingHeader, (DeleteResult<byte[], byte[]>)delResult));
                break;
            }
            case RANGE: {
                RangeResult rangeResult = (RangeResult)result;
                respBuilder.setResponseRange(TableStoreUtils.processRangeResult(routingHeader, (RangeResult<byte[], byte[]>)rangeResult));
                break;
            }
        }
        return respBuilder.build();
    }

    static CompareOp<byte[], byte[]> fromProtoCompare(OpFactory<byte[], byte[]> opFactory, RoutingHeader header, Compare compare) {
        ByteString rKey = header.getRKey();
        ByteString lKey = compare.getKey();
        byte[] storeKey = TableStoreUtils.newStoreKey(rKey, lKey);
        CompareResult result = TableStoreUtils.fromProtoCompareResult(compare.getResult());
        switch (compare.getTarget()) {
            case MOD: {
                return opFactory.compareModRevision(result, (Object)storeKey, compare.getModRevision());
            }
            case CREATE: {
                return opFactory.compareCreateRevision(result, (Object)storeKey, compare.getCreateRevision());
            }
            case VERSION: {
                return opFactory.compareVersion(result, (Object)storeKey, compare.getVersion());
            }
            case VALUE: {
                return opFactory.compareValue(result, (Object)storeKey, null == compare.getValue() || compare.getValue().size() == 0 ? null : compare.getValue().toByteArray());
            }
        }
        throw new IllegalArgumentException("Invalid compare target " + compare.getTarget());
    }

    static CompareResult fromProtoCompareResult(Compare.CompareResult result) {
        switch (result) {
            case LESS: {
                return CompareResult.LESS;
            }
            case EQUAL: {
                return CompareResult.EQUAL;
            }
            case GREATER: {
                return CompareResult.GREATER;
            }
            case NOT_EQUAL: {
                return CompareResult.NOT_EQUAL;
            }
        }
        throw new IllegalArgumentException("Invalid compare result " + result);
    }

    private TableStoreUtils() {
    }
}

