/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zookeeper;

import java.io.IOException;
import org.apache.zookeeper.ClientCnxn;
import org.apache.zookeeper.ClientCnxnSocket;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.PortAssignment;
import org.apache.zookeeper.Watcher;
import org.apache.zookeeper.ZooDefs;
import org.apache.zookeeper.ZooKeeper;
import org.apache.zookeeper.client.HostProvider;
import org.apache.zookeeper.client.ZKClientConfig;
import org.apache.zookeeper.server.quorum.QuorumPeerTestBase;
import org.apache.zookeeper.test.ClientBase;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;

public class ClientRequestTimeoutTest
extends QuorumPeerTestBase {
    private static final int SERVER_COUNT = 3;
    private boolean dropPacket = false;
    private int dropPacketType = 1;

    @Test
    @Timeout(value=120L)
    public void testClientRequestTimeout() throws Exception {
        int i;
        int requestTimeOut = 15000;
        System.setProperty("zookeeper.request.timeout", Integer.toString(requestTimeOut));
        int[] clientPorts = new int[3];
        StringBuilder sb = new StringBuilder();
        for (int i2 = 0; i2 < 3; ++i2) {
            clientPorts[i2] = PortAssignment.unique();
            String server = "server." + i2 + "=127.0.0.1:" + PortAssignment.unique() + ":" + PortAssignment.unique() + ":participant;127.0.0.1:" + clientPorts[i2];
            sb.append(server + "\n");
        }
        String currentQuorumCfgSection = sb.toString();
        QuorumPeerTestBase.MainThread[] mt = new QuorumPeerTestBase.MainThread[3];
        for (i = 0; i < 3; ++i) {
            mt[i] = new QuorumPeerTestBase.MainThread(i, clientPorts[i], currentQuorumCfgSection, false);
            mt[i].start();
        }
        for (i = 0; i < 3; ++i) {
            Assertions.assertTrue((boolean)ClientBase.waitForServerUp("127.0.0.1:" + clientPorts[i], ClientBase.CONNECTION_TIMEOUT), (String)("waiting for server " + i + " being up"));
        }
        ClientBase.CountdownWatcher watch1 = new ClientBase.CountdownWatcher();
        CustomZooKeeper zk = new CustomZooKeeper(this.getCxnString(clientPorts), ClientBase.CONNECTION_TIMEOUT, watch1);
        watch1.waitForConnected(ClientBase.CONNECTION_TIMEOUT);
        String data = "originalData";
        zk.create("/clientHang1", data.getBytes(), ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT_SEQUENTIAL);
        this.dropPacket = true;
        this.dropPacketType = 1;
        try {
            zk.create("/clientHang2", data.getBytes(), ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
            Assertions.fail((String)"KeeperException is expected.");
        }
        catch (KeeperException exception) {
            Assertions.assertEquals((int)KeeperException.Code.REQUESTTIMEOUT.intValue(), (int)exception.code().intValue());
        }
        zk.close();
        for (int i3 = 0; i3 < 3; ++i3) {
            mt[i3].shutdown();
        }
    }

    private String getCxnString(int[] clientPorts) {
        StringBuffer hostPortBuffer = new StringBuffer();
        for (int i = 0; i < clientPorts.length; ++i) {
            hostPortBuffer.append("127.0.0.1:");
            hostPortBuffer.append(clientPorts[i]);
            if (i == clientPorts.length - 1) continue;
            hostPortBuffer.append(',');
        }
        return hostPortBuffer.toString();
    }

    class CustomZooKeeper
    extends ZooKeeper {
        public CustomZooKeeper(String connectString, int sessionTimeout, Watcher watcher) throws IOException {
            super(connectString, sessionTimeout, watcher);
        }

        ClientCnxn createConnection(String chrootPath, HostProvider hostProvider, int sessionTimeout, ZKClientConfig clientConfig, Watcher defaultWatcher, ClientCnxnSocket clientCnxnSocket, boolean canBeReadOnly) throws IOException {
            return new CustomClientCnxn(chrootPath, hostProvider, sessionTimeout, clientConfig, defaultWatcher, clientCnxnSocket, canBeReadOnly);
        }
    }

    class CustomClientCnxn
    extends ClientCnxn {
        CustomClientCnxn(String chrootPath, HostProvider hostProvider, int sessionTimeout, ZKClientConfig clientConfig, Watcher defaultWatcher, ClientCnxnSocket clientCnxnSocket, boolean canBeReadOnly) throws IOException {
            super(chrootPath, hostProvider, sessionTimeout, clientConfig, defaultWatcher, clientCnxnSocket, canBeReadOnly);
        }

        public void finishPacket(ClientCnxn.Packet p) {
            if (ClientRequestTimeoutTest.this.dropPacket && p.requestHeader.getType() == ClientRequestTimeoutTest.this.dropPacketType) {
                return;
            }
            super.finishPacket(p);
        }
    }
}

