/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zookeeper.common;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.apache.zookeeper.ZKTestCase;
import org.apache.zookeeper.common.AtomicFileWritingIdiom;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.io.TempDir;

public class AtomicFileWritingIdiomTest
extends ZKTestCase {
    @Test
    public void testOutputStreamSuccess(@TempDir File tmpdir) throws IOException {
        File target = new File(tmpdir, "target.txt");
        final File tmp = new File(tmpdir, "target.txt.tmp");
        this.createFile(target, "before");
        Assertions.assertEquals((Object)"before", (Object)this.getContent(target));
        new AtomicFileWritingIdiom(target, new AtomicFileWritingIdiom.OutputStreamStatement(){

            public void write(OutputStream os) throws IOException {
                os.write("after".getBytes(StandardCharsets.US_ASCII));
                Assertions.assertTrue((boolean)tmp.exists(), (String)"implementation of AtomicFileOutputStream has changed, update the test");
            }
        });
        Assertions.assertFalse((boolean)tmp.exists(), (String)"tmp file should have been deleted");
        Assertions.assertEquals((Object)"after", (Object)this.getContent(target));
    }

    @Test
    public void testWriterSuccess(@TempDir File tmpdir) throws IOException {
        File target = new File(tmpdir, "target.txt");
        final File tmp = new File(tmpdir, "target.txt.tmp");
        this.createFile(target, "before");
        Assertions.assertEquals((Object)"before", (Object)this.getContent(target));
        new AtomicFileWritingIdiom(target, new AtomicFileWritingIdiom.WriterStatement(){

            public void write(Writer os) throws IOException {
                os.write("after");
                Assertions.assertTrue((boolean)tmp.exists(), (String)"implementation of AtomicFileOutputStream has changed, update the test");
            }
        });
        Assertions.assertFalse((boolean)tmp.exists(), (String)"tmp file should have been deleted");
        Assertions.assertEquals((Object)"after", (Object)this.getContent(target));
    }

    @Test
    public void testOutputStreamFailure(@TempDir File tmpdir) throws IOException {
        File target = new File(tmpdir, "target.txt");
        final File tmp = new File(tmpdir, "target.txt.tmp");
        this.createFile(target, "before");
        Assertions.assertEquals((Object)"before", (Object)this.getContent(target));
        boolean exception = false;
        try {
            new AtomicFileWritingIdiom(target, new AtomicFileWritingIdiom.OutputStreamStatement(){

                public void write(OutputStream os) throws IOException {
                    os.write("after".getBytes(StandardCharsets.US_ASCII));
                    os.flush();
                    Assertions.assertTrue((boolean)tmp.exists(), (String)"implementation of AtomicFileOutputStream has changed, update the test");
                    throw new RuntimeException();
                }
            });
        }
        catch (RuntimeException ex) {
            exception = true;
        }
        Assertions.assertFalse((boolean)tmp.exists(), (String)"tmp file should have been deleted");
        Assertions.assertTrue((boolean)exception, (String)"should have raised an exception");
        Assertions.assertEquals((Object)"before", (Object)this.getContent(target));
    }

    @Test
    public void testWriterFailure(@TempDir File tmpdir) throws IOException {
        File target = new File(tmpdir, "target.txt");
        final File tmp = new File(tmpdir, "target.txt.tmp");
        this.createFile(target, "before");
        Assertions.assertEquals((Object)"before", (Object)this.getContent(target));
        boolean exception = false;
        try {
            new AtomicFileWritingIdiom(target, new AtomicFileWritingIdiom.WriterStatement(){

                public void write(Writer os) throws IOException {
                    os.write("after");
                    os.flush();
                    Assertions.assertTrue((boolean)tmp.exists(), (String)"implementation of AtomicFileOutputStream has changed, update the test");
                    throw new RuntimeException();
                }
            });
        }
        catch (RuntimeException ex) {
            exception = true;
        }
        Assertions.assertFalse((boolean)tmp.exists(), (String)"tmp file should have been deleted");
        Assertions.assertTrue((boolean)exception, (String)"should have raised an exception");
        Assertions.assertEquals((Object)"before", (Object)this.getContent(target));
    }

    @Test
    public void testOutputStreamFailureIOException(@TempDir File tmpdir) throws IOException {
        File target = new File(tmpdir, "target.txt");
        final File tmp = new File(tmpdir, "target.txt.tmp");
        this.createFile(target, "before");
        Assertions.assertEquals((Object)"before", (Object)this.getContent(target));
        boolean exception = false;
        try {
            new AtomicFileWritingIdiom(target, new AtomicFileWritingIdiom.OutputStreamStatement(){

                public void write(OutputStream os) throws IOException {
                    os.write("after".getBytes(StandardCharsets.US_ASCII));
                    os.flush();
                    Assertions.assertTrue((boolean)tmp.exists(), (String)"implementation of AtomicFileOutputStream has changed, update the test");
                    throw new IOException();
                }
            });
        }
        catch (IOException ex) {
            exception = true;
        }
        Assertions.assertFalse((boolean)tmp.exists(), (String)"tmp file should have been deleted");
        Assertions.assertTrue((boolean)exception, (String)"should have raised an exception");
        Assertions.assertEquals((Object)"before", (Object)this.getContent(target));
    }

    @Test
    public void testWriterFailureIOException(@TempDir File tmpdir) throws IOException {
        File target = new File(tmpdir, "target.txt");
        final File tmp = new File(tmpdir, "target.txt.tmp");
        this.createFile(target, "before");
        Assertions.assertEquals((Object)"before", (Object)this.getContent(target));
        boolean exception = false;
        try {
            new AtomicFileWritingIdiom(target, new AtomicFileWritingIdiom.WriterStatement(){

                public void write(Writer os) throws IOException {
                    os.write("after");
                    os.flush();
                    Assertions.assertTrue((boolean)tmp.exists(), (String)"implementation of AtomicFileOutputStream has changed, update the test");
                    throw new IOException();
                }
            });
        }
        catch (IOException ex) {
            exception = true;
        }
        Assertions.assertFalse((boolean)tmp.exists(), (String)"tmp file should have been deleted");
        Assertions.assertTrue((boolean)exception, (String)"should have raised an exception");
        Assertions.assertEquals((Object)"before", (Object)this.getContent(target));
    }

    @Test
    public void testOutputStreamFailureError(@TempDir File tmpdir) throws IOException {
        File target = new File(tmpdir, "target.txt");
        final File tmp = new File(tmpdir, "target.txt.tmp");
        this.createFile(target, "before");
        Assertions.assertEquals((Object)"before", (Object)this.getContent(target));
        boolean exception = false;
        try {
            new AtomicFileWritingIdiom(target, new AtomicFileWritingIdiom.OutputStreamStatement(){

                public void write(OutputStream os) throws IOException {
                    os.write("after".getBytes(StandardCharsets.US_ASCII));
                    os.flush();
                    Assertions.assertTrue((boolean)tmp.exists(), (String)"implementation of AtomicFileOutputStream has changed, update the test");
                    throw new Error();
                }
            });
        }
        catch (Error ex) {
            exception = true;
        }
        Assertions.assertFalse((boolean)tmp.exists(), (String)"tmp file should have been deleted");
        Assertions.assertTrue((boolean)exception, (String)"should have raised an exception");
        Assertions.assertEquals((Object)"before", (Object)this.getContent(target));
    }

    @Test
    public void testWriterFailureError(@TempDir File tmpdir) throws IOException {
        File target = new File(tmpdir, "target.txt");
        final File tmp = new File(tmpdir, "target.txt.tmp");
        this.createFile(target, "before");
        Assertions.assertEquals((Object)"before", (Object)this.getContent(target));
        boolean exception = false;
        try {
            new AtomicFileWritingIdiom(target, new AtomicFileWritingIdiom.WriterStatement(){

                public void write(Writer os) throws IOException {
                    os.write("after");
                    os.flush();
                    Assertions.assertTrue((boolean)tmp.exists(), (String)"implementation of AtomicFileOutputStream has changed, update the test");
                    throw new Error();
                }
            });
        }
        catch (Error ex) {
            exception = true;
        }
        Assertions.assertFalse((boolean)tmp.exists(), (String)"tmp file should have been deleted");
        Assertions.assertTrue((boolean)exception, (String)"should have raised an exception");
        Assertions.assertEquals((Object)"before", (Object)this.getContent(target));
    }

    @Test
    public void testOutputStreamSuccessNE(@TempDir File tmpdir) throws IOException {
        File target = new File(tmpdir, "target.txt");
        final File tmp = new File(tmpdir, "target.txt.tmp");
        target.delete();
        Assertions.assertFalse((boolean)target.exists(), (String)"file should not exist");
        new AtomicFileWritingIdiom(target, new AtomicFileWritingIdiom.OutputStreamStatement(){

            public void write(OutputStream os) throws IOException {
                os.write("after".getBytes(StandardCharsets.US_ASCII));
                Assertions.assertTrue((boolean)tmp.exists(), (String)"implementation of AtomicFileOutputStream has changed, update the test");
            }
        });
        Assertions.assertEquals((Object)"after", (Object)this.getContent(target));
    }

    @Test
    public void testWriterSuccessNE(@TempDir File tmpdir) throws IOException {
        File target = new File(tmpdir, "target.txt");
        final File tmp = new File(tmpdir, "target.txt.tmp");
        target.delete();
        Assertions.assertFalse((boolean)target.exists(), (String)"file should not exist");
        new AtomicFileWritingIdiom(target, new AtomicFileWritingIdiom.WriterStatement(){

            public void write(Writer os) throws IOException {
                os.write("after");
                Assertions.assertTrue((boolean)tmp.exists(), (String)"implementation of AtomicFileOutputStream has changed, update the test");
            }
        });
        Assertions.assertFalse((boolean)tmp.exists(), (String)"tmp file should have been deleted");
        Assertions.assertEquals((Object)"after", (Object)this.getContent(target));
    }

    @Test
    public void testOutputStreamFailureNE(@TempDir File tmpdir) throws IOException {
        File target = new File(tmpdir, "target.txt");
        final File tmp = new File(tmpdir, "target.txt.tmp");
        target.delete();
        Assertions.assertFalse((boolean)target.exists(), (String)"file should not exist");
        boolean exception = false;
        try {
            new AtomicFileWritingIdiom(target, new AtomicFileWritingIdiom.OutputStreamStatement(){

                public void write(OutputStream os) throws IOException {
                    os.write("after".getBytes(StandardCharsets.US_ASCII));
                    os.flush();
                    Assertions.assertTrue((boolean)tmp.exists(), (String)"implementation of AtomicFileOutputStream has changed, update the test");
                    throw new RuntimeException();
                }
            });
        }
        catch (RuntimeException ex) {
            exception = true;
        }
        Assertions.assertFalse((boolean)tmp.exists(), (String)"tmp file should have been deleted");
        Assertions.assertTrue((boolean)exception, (String)"should have raised an exception");
        Assertions.assertFalse((boolean)target.exists(), (String)"file should not exist");
    }

    @Test
    public void testWriterFailureNE(@TempDir File tmpdir) throws IOException {
        File target = new File(tmpdir, "target.txt");
        final File tmp = new File(tmpdir, "target.txt.tmp");
        target.delete();
        Assertions.assertFalse((boolean)target.exists(), (String)"file should not exist");
        boolean exception = false;
        try {
            new AtomicFileWritingIdiom(target, new AtomicFileWritingIdiom.WriterStatement(){

                public void write(Writer os) throws IOException {
                    os.write("after");
                    os.flush();
                    Assertions.assertTrue((boolean)tmp.exists(), (String)"implementation of AtomicFileOutputStream has changed, update the test");
                    throw new RuntimeException();
                }
            });
        }
        catch (RuntimeException ex) {
            exception = true;
        }
        Assertions.assertFalse((boolean)tmp.exists(), (String)"tmp file should have been deleted");
        Assertions.assertTrue((boolean)exception, (String)"should have raised an exception");
        Assertions.assertFalse((boolean)target.exists(), (String)"file should not exist");
    }

    private String getContent(File file, Charset encoding) throws IOException {
        int nb;
        StringBuilder result = new StringBuilder();
        FileInputStream fis = new FileInputStream(file);
        byte[] b = new byte[20];
        while ((nb = fis.read(b)) != -1) {
            result.append(new String(b, 0, nb, encoding));
        }
        fis.close();
        return result.toString();
    }

    private String getContent(File file) throws IOException {
        return this.getContent(file, StandardCharsets.US_ASCII);
    }

    private void createFile(File file, String content) throws IOException {
        FileOutputStream fos = new FileOutputStream(file);
        fos.write(content.getBytes(StandardCharsets.US_ASCII));
        fos.close();
    }
}

