/*
 * Decompiled with CFR 0.152.
 */
package org.inferred.freebuilder.shaded.org.openjdk.tools.jshell;

import java.util.Locale;
import java.util.function.BinaryOperator;
import org.inferred.freebuilder.shaded.org.openjdk.tools.javac.code.Kinds;
import org.inferred.freebuilder.shaded.org.openjdk.tools.javac.code.Printer;
import org.inferred.freebuilder.shaded.org.openjdk.tools.javac.code.Symbol;
import org.inferred.freebuilder.shaded.org.openjdk.tools.javac.code.Type;
import org.inferred.freebuilder.shaded.org.openjdk.tools.javac.util.JavacMessages;

class TypePrinter
extends Printer {
    private static final String OBJECT = "Object";
    private final JavacMessages messages;
    private final BinaryOperator<String> fullClassNameAndPackageToClass;
    private boolean useWildCard = false;

    TypePrinter(JavacMessages messages, BinaryOperator<String> fullClassNameAndPackageToClass, Type typeToPrint) {
        this.messages = messages;
        this.fullClassNameAndPackageToClass = fullClassNameAndPackageToClass;
    }

    @Override
    protected String localize(Locale locale, String key, Object ... args) {
        return this.messages.getLocalizedString(locale, key, args);
    }

    @Override
    protected String capturedVarId(Type.CapturedType t, Locale locale) {
        throw new InternalError("should never call this");
    }

    @Override
    public String visitCapturedType(Type.CapturedType t, Locale locale) {
        return this.visit(t.wildcard, locale);
    }

    @Override
    public String visitWildcardType(Type.WildcardType wt, Locale locale) {
        if (this.useWildCard) {
            return super.visitWildcardType(wt, locale);
        }
        Type extendsBound = wt.getExtendsBound();
        return extendsBound == null ? OBJECT : this.visit(extendsBound, locale);
    }

    @Override
    public String visitType(Type t, Locale locale) {
        String s = t.tsym == null || t.tsym.name == null ? OBJECT : t.tsym.name.toString();
        return s;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String visitClassType(Type.ClassType ct2, Locale locale) {
        boolean prevUseWildCard = this.useWildCard;
        try {
            this.useWildCard = true;
            String string = super.visitClassType(ct2, locale);
            return string;
        }
        finally {
            this.useWildCard = prevUseWildCard;
        }
    }

    @Override
    protected String className(Type.ClassType t, boolean longform, Locale locale) {
        Symbol.TypeSymbol sym = t.tsym;
        if (sym.name.length() == 0 && (sym.flags() & 0x1000000L) != 0L) {
            return OBJECT;
        }
        if (sym.name.length() == 0) {
            Type.ClassType norm = (Type.ClassType)t.tsym.type;
            String s = norm == null ? "object" : (norm.interfaces_field != null && norm.interfaces_field.nonEmpty() ? this.visit((Type)norm.interfaces_field.head, locale) : this.visit(norm.supertype_field, locale));
            return s;
        }
        if (longform) {
            String pkg = "";
            Symbol psym = sym;
            while (psym != null) {
                if (psym.kind == Kinds.Kind.PCK) {
                    pkg = psym.getQualifiedName().toString();
                    break;
                }
                psym = psym.owner;
            }
            return (String)this.fullClassNameAndPackageToClass.apply(sym.getQualifiedName().toString(), pkg);
        }
        return sym.name.toString();
    }

    @Override
    public String visitClassSymbol(Symbol.ClassSymbol sym, Locale locale) {
        return sym.name.isEmpty() ? sym.flatname.toString() : sym.fullname.toString();
    }

    @Override
    public String visitPackageSymbol(Symbol.PackageSymbol s, Locale locale) {
        return s.isUnnamed() ? "" : s.fullname.toString();
    }
}

