/*
 * Decompiled with CFR 0.152.
 */
package org.inferred.freebuilder.processor.source.feature;

import java.util.stream.Collectors;
import org.inferred.freebuilder.processor.source.feature.Feature;
import org.inferred.freebuilder.processor.source.feature.FeatureSet;
import org.inferred.freebuilder.processor.source.feature.FeatureType;
import org.inferred.freebuilder.shaded.com.google.common.collect.ImmutableMap;

public class StaticFeatureSet
implements FeatureSet {
    private final ImmutableMap<Class<? extends Feature>, Feature<?>> featuresByType;

    public StaticFeatureSet(Feature<?> ... features) {
        ImmutableMap.Builder<Class<?>, Feature<?>> featuresBuilder = ImmutableMap.builder();
        for (Feature<?> feature : features) {
            featuresBuilder.put(feature.getClass(), feature);
        }
        this.featuresByType = featuresBuilder.build();
    }

    @Override
    public <T extends Feature<T>> T get(FeatureType<T> featureType) {
        Feature<?> feature = this.featuresByType.get(featureType.type());
        if (feature != null) {
            return (T)feature;
        }
        return featureType.testDefault(this);
    }

    public String toString() {
        return this.featuresByType.values().stream().map(Object::toString).collect(Collectors.joining(", "));
    }
}

