/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zookeeper.test;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.zookeeper.AsyncCallback;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.Op;
import org.apache.zookeeper.OpResult;
import org.apache.zookeeper.ZooDefs;
import org.apache.zookeeper.ZooKeeper;
import org.apache.zookeeper.test.ClientBase;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class MultiAsyncTransactionTest
extends ClientBase {
    private ZooKeeper zk;
    private final AtomicInteger pendingOps = new AtomicInteger(0);

    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.zk = this.createClient();
        this.pendingOps.set(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void finishPendingOps() {
        if (this.pendingOps.decrementAndGet() == 0) {
            AtomicInteger atomicInteger = this.pendingOps;
            synchronized (atomicInteger) {
                this.pendingOps.notifyAll();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void waitForPendingOps(int timeout) throws Exception {
        AtomicInteger atomicInteger = this.pendingOps;
        synchronized (atomicInteger) {
            while (this.pendingOps.get() > 0) {
                this.pendingOps.wait(timeout);
            }
        }
    }

    @Test
    public void testSequentialNodeCreateInAsyncMulti() throws Exception {
        int iteration = 4;
        final ArrayList results = new ArrayList();
        this.pendingOps.set(4);
        List<Op> ops = Arrays.asList(Op.create((String)"/node-", (byte[])new byte[0], (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, (CreateMode)CreateMode.PERSISTENT_SEQUENTIAL), Op.create((String)"/dup", (byte[])new byte[0], (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, (CreateMode)CreateMode.PERSISTENT));
        for (int i = 0; i < 4; ++i) {
            this.zk.multi(ops, new AsyncCallback.MultiCallback(){

                public void processResult(int rc, String path, Object ctx, List<OpResult> opResults) {
                    MultiResult result = new MultiResult();
                    result.results = opResults;
                    result.rc = rc;
                    results.add(result);
                    MultiAsyncTransactionTest.this.finishPendingOps();
                }
            }, null);
        }
        this.waitForPendingOps(CONNECTION_TIMEOUT);
        Assert.assertEquals((long)KeeperException.Code.OK.intValue(), (long)((MultiResult)results.get((int)0)).rc);
        Assert.assertEquals((long)KeeperException.Code.NODEEXISTS.intValue(), (long)((MultiResult)results.get((int)1)).rc);
        Assert.assertEquals((long)KeeperException.Code.NODEEXISTS.intValue(), (long)((MultiResult)results.get((int)2)).rc);
        Assert.assertEquals((long)KeeperException.Code.NODEEXISTS.intValue(), (long)((MultiResult)results.get((int)3)).rc);
        Assert.assertTrue((boolean)(((MultiResult)results.get((int)0)).results.get(0) instanceof OpResult.CreateResult));
        Assert.assertEquals((long)KeeperException.Code.OK.intValue(), (long)((OpResult.ErrorResult)((MultiResult)results.get((int)1)).results.get(0)).getErr());
        Assert.assertEquals((long)KeeperException.Code.OK.intValue(), (long)((OpResult.ErrorResult)((MultiResult)results.get((int)2)).results.get(0)).getErr());
        Assert.assertEquals((long)KeeperException.Code.OK.intValue(), (long)((OpResult.ErrorResult)((MultiResult)results.get((int)3)).results.get(0)).getErr());
        Assert.assertEquals((long)KeeperException.Code.NODEEXISTS.intValue(), (long)((OpResult.ErrorResult)((MultiResult)results.get((int)1)).results.get(1)).getErr());
        Assert.assertEquals((long)KeeperException.Code.NODEEXISTS.intValue(), (long)((OpResult.ErrorResult)((MultiResult)results.get((int)2)).results.get(1)).getErr());
        Assert.assertEquals((long)KeeperException.Code.NODEEXISTS.intValue(), (long)((OpResult.ErrorResult)((MultiResult)results.get((int)3)).results.get(1)).getErr());
    }

    private static class MultiResult {
        int rc;
        List<OpResult> results;

        private MultiResult() {
        }
    }
}

