/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zookeeper.test;

import java.io.File;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.util.Enumeration;
import org.apache.zookeeper.PortAssignment;
import org.apache.zookeeper.ZKTestCase;
import org.apache.zookeeper.ZooKeeper;
import org.apache.zookeeper.server.ServerCnxnFactory;
import org.apache.zookeeper.server.ZooKeeperServer;
import org.apache.zookeeper.test.ClientBase;
import org.junit.Assert;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClientPortBindTest
extends ZKTestCase {
    protected static final Logger LOG = LoggerFactory.getLogger(ClientPortBindTest.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testBindByAddress() throws Exception {
        String bindAddress = null;
        Enumeration<NetworkInterface> intfs = NetworkInterface.getNetworkInterfaces();
        block5: while (intfs.hasMoreElements()) {
            NetworkInterface i = intfs.nextElement();
            try {
                if (!i.isLoopback()) continue;
                Enumeration<InetAddress> addrs = i.getInetAddresses();
                while (addrs.hasMoreElements()) {
                    InetAddress a = addrs.nextElement();
                    if (!a.isLoopbackAddress()) continue;
                    bindAddress = a.getHostAddress();
                    if (!(a instanceof Inet6Address)) continue block5;
                    bindAddress = "[" + bindAddress + "]";
                }
            }
            catch (SocketException se) {
                LOG.warn("Couldn't find loopback interface", (Throwable)se);
            }
        }
        if (bindAddress == null) {
            LOG.warn("Unable to determine loop back address, skipping test");
            return;
        }
        int PORT = PortAssignment.unique();
        LOG.info("Using {} as the bind address", bindAddress);
        String HOSTPORT = bindAddress + ":" + PORT;
        LOG.info("Using {} as the host/port", (Object)HOSTPORT);
        File tmpDir = ClientBase.createTmpDir();
        ClientBase.setupTestEnv();
        ZooKeeperServer zks = new ZooKeeperServer(tmpDir, tmpDir, 3000);
        ServerCnxnFactory f = ServerCnxnFactory.createFactory((InetSocketAddress)new InetSocketAddress(bindAddress, PORT), (int)-1);
        f.startup(zks);
        LOG.info("starting up the the server, waiting");
        Assert.assertTrue((String)"waiting for server up", (boolean)ClientBase.waitForServerUp(HOSTPORT, ClientBase.CONNECTION_TIMEOUT));
        ZooKeeper zk = ClientBase.createZKClient(HOSTPORT);
        try {
            zk.close();
        }
        finally {
            f.shutdown();
            zks.shutdown();
            Assert.assertTrue((String)"waiting for server down", (boolean)ClientBase.waitForServerDown(HOSTPORT, ClientBase.CONNECTION_TIMEOUT));
        }
    }
}

