/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zookeeper.server.quorum;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.PortAssignment;
import org.apache.zookeeper.Watcher;
import org.apache.zookeeper.ZooDefs;
import org.apache.zookeeper.ZooKeeper;
import org.apache.zookeeper.admin.ZooKeeperAdmin;
import org.apache.zookeeper.server.quorum.QuorumPeerConfig;
import org.apache.zookeeper.server.quorum.QuorumPeerTestBase;
import org.apache.zookeeper.test.ClientBase;
import org.apache.zookeeper.test.ReconfigTest;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class ReconfigLegacyTest
extends QuorumPeerTestBase {
    private static final int SERVER_COUNT = 3;

    @Before
    public void setup() {
        ClientBase.setupTestEnv();
        QuorumPeerConfig.setReconfigEnabled((boolean)true);
        System.setProperty("zookeeper.DigestAuthenticationProvider.superDigest", "super:D/InIHSb7yEEbrWz8b9l71RjZJU=");
    }

    @Test
    public void testConfigFileBackwardCompatibility() throws Exception {
        int i;
        int[] clientPorts = new int[3];
        StringBuilder sb = new StringBuilder();
        ArrayList<String> allServers = new ArrayList<String>();
        for (int i2 = 0; i2 < 3; ++i2) {
            clientPorts[i2] = PortAssignment.unique();
            String server = "server." + i2 + "=localhost:" + PortAssignment.unique() + ":" + PortAssignment.unique() + ":participant;localhost:" + clientPorts[i2];
            allServers.add(server);
            sb.append(server + "\n");
        }
        String currentQuorumCfgSection = sb.toString();
        QuorumPeerTestBase.MainThread[] mt = new QuorumPeerTestBase.MainThread[3];
        ZooKeeper[] zk = new ZooKeeper[3];
        for (i = 0; i < 3; ++i) {
            mt[i] = new QuorumPeerTestBase.MainThread(i, clientPorts[i], currentQuorumCfgSection, "participant", false);
            Assert.assertEquals((long)mt[i].getDynamicFiles().length, (long)0L);
            mt[i].start();
        }
        for (i = 0; i < 3; ++i) {
            int j;
            Assert.assertTrue((String)("waiting for server " + i + " being up"), (boolean)ClientBase.waitForServerUp("127.0.0.1:" + clientPorts[i], ClientBase.CONNECTION_TIMEOUT));
            zk[i] = ClientBase.createZKClient("127.0.0.1:" + clientPorts[i]);
            File[] dynamicFiles = mt[i].getDynamicFiles();
            Assert.assertTrue((dynamicFiles.length == 1 ? 1 : 0) != 0);
            ReconfigTest.testServerHasConfig(zk[i], allServers, null);
            Properties cfg = ReconfigLegacyTest.readPropertiesFromFile(mt[i].confFile);
            for (j = 0; j < 3; ++j) {
                Assert.assertFalse((boolean)cfg.containsKey("server." + j));
            }
            Assert.assertFalse((boolean)cfg.containsKey("peerType"));
            Assert.assertTrue((boolean)cfg.containsKey("dynamicConfigFile"));
            Assert.assertFalse((boolean)cfg.containsKey("clientPort"));
            cfg = ReconfigLegacyTest.readPropertiesFromFile(dynamicFiles[0]);
            for (j = 0; j < 3; ++j) {
                String serverLine = cfg.getProperty("server." + j, "");
                Assert.assertEquals((Object)allServers.get(j), (Object)("server." + j + "=" + serverLine));
            }
            Assert.assertFalse((boolean)cfg.containsKey("dynamicConfigFile"));
        }
        ReconfigTest.testNormalOperation(zk[0], zk[1]);
        for (i = 0; i < 3; ++i) {
            zk[i].close();
            mt[i].shutdown();
        }
        for (i = 0; i < 3; ++i) {
            mt[i].start();
        }
        for (i = 0; i < 3; ++i) {
            Assert.assertTrue((String)("waiting for server " + i + " being up"), (boolean)ClientBase.waitForServerUp("127.0.0.1:" + clientPorts[i], ClientBase.CONNECTION_TIMEOUT));
            zk[i] = ClientBase.createZKClient("127.0.0.1:" + clientPorts[i]);
            ReconfigTest.testServerHasConfig(zk[i], allServers, null);
        }
        ReconfigTest.testNormalOperation(zk[0], zk[1]);
        for (i = 0; i < 3; ++i) {
            mt[i].shutdown();
            zk[i].close();
        }
    }

    @Test
    public void testReconfigRemoveClientFromStatic() throws Exception {
        int i;
        int[] clientPorts = new int[3];
        int[] quorumPorts = new int[3];
        int[] electionPorts = new int[3];
        boolean changedServerId = false;
        int newClientPort = PortAssignment.unique();
        StringBuilder sb = new StringBuilder();
        ArrayList<String> allServers = new ArrayList<String>();
        ArrayList<String> newServers = new ArrayList<String>();
        for (int i2 = 0; i2 < 3; ++i2) {
            clientPorts[i2] = PortAssignment.unique();
            quorumPorts[i2] = PortAssignment.unique();
            electionPorts[i2] = PortAssignment.unique();
            String server = "server." + i2 + "=localhost:" + quorumPorts[i2] + ":" + electionPorts[i2] + ":participant";
            allServers.add(server);
            sb.append(server + "\n");
            if (i2 == 0) {
                newServers.add(server + ";0.0.0.0:" + newClientPort);
                continue;
            }
            newServers.add(server);
        }
        String quorumCfgSection = sb.toString();
        QuorumPeerTestBase.MainThread[] mt = new QuorumPeerTestBase.MainThread[3];
        ZooKeeper[] zk = new ZooKeeper[3];
        ZooKeeperAdmin[] zkAdmin = new ZooKeeperAdmin[3];
        for (i = 0; i < 3; ++i) {
            mt[i] = new QuorumPeerTestBase.MainThread(i, clientPorts[i], quorumCfgSection, false);
            mt[i].start();
        }
        for (i = 0; i < 3; ++i) {
            Assert.assertTrue((String)("waiting for server " + i + " being up"), (boolean)ClientBase.waitForServerUp("127.0.0.1:" + clientPorts[i], ClientBase.CONNECTION_TIMEOUT));
            zk[i] = ClientBase.createZKClient("127.0.0.1:" + clientPorts[i]);
            zkAdmin[i] = new ZooKeeperAdmin("127.0.0.1:" + clientPorts[i], ClientBase.CONNECTION_TIMEOUT, (Watcher)this);
            zkAdmin[i].addAuthInfo("digest", "super:test".getBytes());
            ReconfigTest.testServerHasConfig(zk[i], allServers, null);
            Properties cfg = ReconfigLegacyTest.readPropertiesFromFile(mt[i].confFile);
            Assert.assertTrue((boolean)cfg.containsKey("dynamicConfigFile"));
            Assert.assertTrue((boolean)cfg.containsKey("clientPort"));
        }
        ReconfigTest.testNormalOperation(zk[0], zk[1]);
        ReconfigTest.reconfig(zkAdmin[1], null, null, newServers, -1L);
        ReconfigTest.testNormalOperation(zk[0], zk[1]);
        Thread.sleep(1000L);
        for (i = 0; i < 3; ++i) {
            ReconfigTest.testServerHasConfig(zk[i], newServers, null);
            Properties staticCfg = ReconfigLegacyTest.readPropertiesFromFile(mt[i].confFile);
            if (i == 0) {
                Assert.assertFalse((boolean)staticCfg.containsKey("clientPort"));
                continue;
            }
            Assert.assertTrue((boolean)staticCfg.containsKey("clientPort"));
        }
        for (i = 0; i < 3; ++i) {
            mt[i].shutdown();
            zk[i].close();
            zkAdmin[i].close();
        }
    }

    public static Properties readPropertiesFromFile(File file) throws IOException {
        Properties cfg = new Properties();
        try (FileInputStream in = new FileInputStream(file);){
            cfg.load(in);
        }
        return cfg;
    }

    @Test(timeout=120000L)
    public void testRestartZooKeeperServer() throws Exception {
        int i;
        int[] clientPorts = new int[3];
        StringBuilder sb = new StringBuilder();
        for (int i2 = 0; i2 < 3; ++i2) {
            clientPorts[i2] = PortAssignment.unique();
            String server = "server." + i2 + "=127.0.0.1:" + PortAssignment.unique() + ":" + PortAssignment.unique() + ":participant;127.0.0.1:" + clientPorts[i2];
            sb.append(server + "\n");
        }
        String currentQuorumCfgSection = sb.toString();
        QuorumPeerTestBase.MainThread[] mt = new QuorumPeerTestBase.MainThread[3];
        for (i = 0; i < 3; ++i) {
            mt[i] = new QuorumPeerTestBase.MainThread(i, clientPorts[i], currentQuorumCfgSection, false);
            mt[i].start();
        }
        for (i = 0; i < 3; ++i) {
            Assert.assertTrue((String)("waiting for server " + i + " being up"), (boolean)ClientBase.waitForServerUp("127.0.0.1:" + clientPorts[i], ClientBase.CONNECTION_TIMEOUT));
        }
        ZooKeeper zk = ClientBase.createZKClient("127.0.0.1:" + clientPorts[0]);
        String zNodePath = "/serverRestartTest";
        String data = "originalData";
        zk.create(zNodePath, data.getBytes(), (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
        zk.close();
        mt[0].shutdown();
        mt[1].shutdown();
        mt[0].start();
        mt[1].start();
        for (int i3 = 0; i3 < 3; ++i3) {
            Assert.assertTrue((String)("waiting for server " + i3 + " being up"), (boolean)ClientBase.waitForServerUp("127.0.0.1:" + clientPorts[i3], ClientBase.CONNECTION_TIMEOUT));
        }
        zk = ClientBase.createZKClient("127.0.0.1:" + clientPorts[0]);
        byte[] dataBytes = zk.getData(zNodePath, null, null);
        String receivedData = new String(dataBytes);
        Assert.assertEquals((Object)data, (Object)receivedData);
        for (int i4 = 0; i4 < 3; ++i4) {
            mt[i4].shutdown();
        }
    }
}

