/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zookeeper.common;

import java.util.concurrent.TimeUnit;
import org.apache.zookeeper.common.ClientX509Util;
import org.apache.zookeeper.common.X509Util;
import org.apache.zookeeper.common.ZKConfig;
import org.junit.After;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.Timeout;

public class ZKConfigTest {
    X509Util x509Util = new ClientX509Util();
    @Rule
    public Timeout timeout = new Timeout(10L, TimeUnit.SECONDS);

    @After
    public void tearDown() throws Exception {
        System.clearProperty(this.x509Util.getSslProtocolProperty());
    }

    @Test
    public void testBooleanRetrievalFromPropertyDefault() {
        ZKConfig conf = new ZKConfig();
        String prop = "UnSetProperty" + System.currentTimeMillis();
        boolean defaultValue = false;
        boolean result = conf.getBoolean(prop, defaultValue);
        Assert.assertEquals((Object)defaultValue, (Object)result);
    }

    @Test
    public void testBooleanRetrievalFromProperty() {
        boolean value = true;
        boolean defaultValue = false;
        System.setProperty(this.x509Util.getSslProtocolProperty(), Boolean.toString(value));
        ZKConfig conf = new ZKConfig();
        boolean result = conf.getBoolean(this.x509Util.getSslProtocolProperty(), defaultValue);
        Assert.assertEquals((Object)value, (Object)result);
    }

    @Test
    public void testBooleanRetrievalFromPropertyWithWhitespacesInBeginning() {
        boolean value = true;
        boolean defaultValue = false;
        System.setProperty(this.x509Util.getSslProtocolProperty(), " " + value);
        ZKConfig conf = new ZKConfig();
        boolean result = conf.getBoolean(this.x509Util.getSslProtocolProperty(), defaultValue);
        Assert.assertEquals((Object)value, (Object)result);
    }

    @Test
    public void testBooleanRetrievalFromPropertyWithWhitespacesAtEnd() {
        boolean value = true;
        boolean defaultValue = false;
        System.setProperty(this.x509Util.getSslProtocolProperty(), value + " ");
        ZKConfig conf = new ZKConfig();
        boolean result = conf.getBoolean(this.x509Util.getSslProtocolProperty(), defaultValue);
        Assert.assertEquals((Object)value, (Object)result);
    }

    @Test
    public void testBooleanRetrievalFromPropertyWithWhitespacesAtBeginningAndEnd() {
        boolean value = true;
        boolean defaultValue = false;
        System.setProperty(this.x509Util.getSslProtocolProperty(), " " + value + " ");
        ZKConfig conf = new ZKConfig();
        boolean result = conf.getBoolean(this.x509Util.getSslProtocolProperty(), defaultValue);
        Assert.assertEquals((Object)value, (Object)result);
    }
}

