/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zookeeper;

import io.netty.buffer.ByteBufAllocator;
import java.io.IOException;
import org.apache.zookeeper.ClientCnxnSocketNIO;
import org.apache.zookeeper.ClientCnxnSocketNetty;
import org.apache.zookeeper.client.ZKClientConfig;
import org.apache.zookeeper.test.TestByteBufAllocator;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class ClientCnxnSocketTest {
    @Before
    public void setUp() {
        ClientCnxnSocketNetty.setTestAllocator((ByteBufAllocator)TestByteBufAllocator.getInstance());
    }

    @After
    public void tearDown() {
        ClientCnxnSocketNetty.clearTestAllocator();
        TestByteBufAllocator.checkForLeaks();
    }

    @Test
    public void testWhenInvalidJuteMaxBufferIsConfiguredIOExceptionIsThrown() {
        ZKClientConfig clientConfig = new ZKClientConfig();
        String value = "SomeInvalidInt";
        clientConfig.setProperty("jute.maxbuffer", value);
        try {
            new ClientCnxnSocketNIO(clientConfig);
            Assert.fail((String)"IOException is expected.");
        }
        catch (IOException e) {
            Assert.assertTrue((boolean)e.getMessage().contains(value));
        }
        try {
            new ClientCnxnSocketNetty(clientConfig);
            Assert.fail((String)"IOException is expected.");
        }
        catch (IOException e) {
            Assert.assertTrue((boolean)e.getMessage().contains(value));
        }
    }
}

