/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.fips;

import java.math.BigInteger;
import org.bouncycastle.crypto.fips.DhKeyGeneratorHelper;
import org.bouncycastle.crypto.internal.AsymmetricCipherKeyPair;
import org.bouncycastle.crypto.internal.AsymmetricCipherKeyPairGenerator;
import org.bouncycastle.crypto.internal.KeyGenerationParameters;
import org.bouncycastle.crypto.internal.params.DhKeyGenerationParameters;
import org.bouncycastle.crypto.internal.params.DhParameters;
import org.bouncycastle.crypto.internal.params.DhPrivateKeyParameters;
import org.bouncycastle.crypto.internal.params.DhPublicKeyParameters;

class DhKeyPairGenerator
implements AsymmetricCipherKeyPairGenerator {
    private DhKeyGenerationParameters param;

    DhKeyPairGenerator() {
    }

    public void init(KeyGenerationParameters keyGenerationParameters) {
        this.param = (DhKeyGenerationParameters)keyGenerationParameters;
    }

    public AsymmetricCipherKeyPair generateKeyPair() {
        DhKeyGeneratorHelper dhKeyGeneratorHelper = DhKeyGeneratorHelper.INSTANCE;
        DhParameters dhParameters = this.param.getParameters();
        BigInteger bigInteger = dhKeyGeneratorHelper.calculatePrivate(dhParameters, this.param.getRandom());
        BigInteger bigInteger2 = dhKeyGeneratorHelper.calculatePublic(dhParameters, bigInteger);
        return new AsymmetricCipherKeyPair(new DhPublicKeyParameters(bigInteger2, dhParameters), new DhPrivateKeyParameters(bigInteger, dhParameters));
    }
}

