/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zookeeper;

import java.io.File;
import org.apache.zookeeper.server.ServerConfig;
import org.apache.zookeeper.server.quorum.QuorumPeerConfig;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;

public class ServerConfigTest {
    private ServerConfig serverConfig;

    @Before
    public void setUp() {
        this.serverConfig = new ServerConfig();
    }

    @Test(expected=IllegalArgumentException.class)
    public void testFewArguments() {
        String[] args = new String[]{"2181"};
        this.serverConfig.parse(args);
    }

    @Test
    public void testValidArguments() {
        String[] args = new String[]{"2181", "/data/dir", "60000", "10000"};
        this.serverConfig.parse(args);
        Assert.assertEquals((long)2181L, (long)this.serverConfig.getClientPortAddress().getPort());
        Assert.assertTrue((boolean)this.checkEquality("/data/dir", this.serverConfig.getDataDir()));
        Assert.assertEquals((long)60000L, (long)this.serverConfig.getTickTime());
        Assert.assertEquals((long)10000L, (long)this.serverConfig.getMaxClientCnxns());
    }

    @Test(expected=IllegalArgumentException.class)
    public void testTooManyArguments() {
        String[] args = new String[]{"2181", "/data/dir", "60000", "10000", "9999"};
        this.serverConfig.parse(args);
    }

    @Test
    public void testJvmPauseMonitorConfigured() {
        Long sleepTime = 444L;
        Long warnTH = 5555L;
        Long infoTH = 555L;
        QuorumPeerConfig qpConfig = (QuorumPeerConfig)Mockito.mock(QuorumPeerConfig.class);
        Mockito.when((Object)qpConfig.isJvmPauseMonitorToRun()).thenReturn((Object)true);
        Mockito.when((Object)qpConfig.getJvmPauseSleepTimeMs()).thenReturn((Object)sleepTime);
        Mockito.when((Object)qpConfig.getJvmPauseWarnThresholdMs()).thenReturn((Object)warnTH);
        Mockito.when((Object)qpConfig.getJvmPauseInfoThresholdMs()).thenReturn((Object)infoTH);
        this.serverConfig.readFrom(qpConfig);
        Assert.assertEquals((Object)sleepTime, (Object)this.serverConfig.getJvmPauseSleepTimeMs());
        Assert.assertEquals((Object)warnTH, (Object)this.serverConfig.getJvmPauseWarnThresholdMs());
        Assert.assertEquals((Object)infoTH, (Object)this.serverConfig.getJvmPauseInfoThresholdMs());
        Assert.assertTrue((boolean)this.serverConfig.isJvmPauseMonitorToRun());
    }

    boolean checkEquality(String a, String b) {
        Assert.assertNotNull((Object)a);
        Assert.assertNotNull((Object)b);
        return a.equals(b);
    }

    boolean checkEquality(String a, File b) {
        Assert.assertNotNull((Object)a);
        Assert.assertNotNull((Object)b);
        return new File(a).equals(b);
    }
}

