/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zookeeper.test;

import java.util.EnumSet;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.ZKTestCase;
import org.junit.Assert;
import org.junit.Test;

public class CreateModeTest
extends ZKTestCase {
    @Test
    public void testBasicCreateMode() {
        CreateMode cm = CreateMode.PERSISTENT;
        Assert.assertEquals((long)cm.toFlag(), (long)0L);
        Assert.assertFalse((boolean)cm.isEphemeral());
        Assert.assertFalse((boolean)cm.isSequential());
        Assert.assertFalse((boolean)cm.isContainer());
        cm = CreateMode.EPHEMERAL;
        Assert.assertEquals((long)cm.toFlag(), (long)1L);
        Assert.assertTrue((boolean)cm.isEphemeral());
        Assert.assertFalse((boolean)cm.isSequential());
        Assert.assertFalse((boolean)cm.isContainer());
        cm = CreateMode.PERSISTENT_SEQUENTIAL;
        Assert.assertEquals((long)cm.toFlag(), (long)2L);
        Assert.assertFalse((boolean)cm.isEphemeral());
        Assert.assertTrue((boolean)cm.isSequential());
        Assert.assertFalse((boolean)cm.isContainer());
        cm = CreateMode.EPHEMERAL_SEQUENTIAL;
        Assert.assertEquals((long)cm.toFlag(), (long)3L);
        Assert.assertTrue((boolean)cm.isEphemeral());
        Assert.assertTrue((boolean)cm.isSequential());
        Assert.assertFalse((boolean)cm.isContainer());
        cm = CreateMode.CONTAINER;
        Assert.assertEquals((long)cm.toFlag(), (long)4L);
        Assert.assertFalse((boolean)cm.isEphemeral());
        Assert.assertFalse((boolean)cm.isSequential());
        Assert.assertTrue((boolean)cm.isContainer());
    }

    @Test
    public void testFlagConversion() throws KeeperException {
        EnumSet<CreateMode> allModes = EnumSet.allOf(CreateMode.class);
        for (CreateMode cm : allModes) {
            Assert.assertEquals((Object)cm, (Object)CreateMode.fromFlag((int)cm.toFlag()));
        }
    }

    @Test
    public void testInvalidFlagConversion() throws KeeperException {
        try {
            CreateMode.fromFlag((int)99);
            Assert.fail((String)"Shouldn't be able to convert 99 to a CreateMode.");
        }
        catch (KeeperException ke) {
            Assert.assertEquals((Object)KeeperException.Code.BADARGUMENTS, (Object)ke.code());
        }
        try {
            CreateMode.fromFlag((int)-1);
            Assert.fail((String)"Shouldn't be able to convert -1 to a CreateMode.");
        }
        catch (KeeperException ke) {
            Assert.assertEquals((Object)KeeperException.Code.BADARGUMENTS, (Object)ke.code());
        }
    }
}

