/*
 * Decompiled with CFR 0.152.
 */
package org.apache.distributedlog.logsegment;

import org.apache.distributedlog.common.util.Sizable;
import org.apache.distributedlog.logsegment.SizeBasedRollingPolicy;
import org.apache.distributedlog.logsegment.TimeBasedRollingPolicy;
import org.junit.Assert;
import org.junit.Test;

public class TestRollingPolicy {
    @Test(timeout=60000L)
    public void testTimeBasedRollingPolicy() {
        TimeBasedRollingPolicy policy1 = new TimeBasedRollingPolicy(Long.MAX_VALUE);
        TestSizable maxSize = new TestSizable(Long.MAX_VALUE);
        Assert.assertFalse((boolean)policy1.shouldRollover((Sizable)maxSize, System.currentTimeMillis()));
        long currentMs = System.currentTimeMillis();
        TimeBasedRollingPolicy policy2 = new TimeBasedRollingPolicy(1000L);
        Assert.assertTrue((boolean)policy2.shouldRollover((Sizable)maxSize, currentMs - 2000L));
    }

    @Test(timeout=60000L)
    public void testSizeBasedRollingPolicy() {
        SizeBasedRollingPolicy policy = new SizeBasedRollingPolicy(1000L);
        TestSizable sizable1 = new TestSizable(10L);
        Assert.assertFalse((boolean)policy.shouldRollover((Sizable)sizable1, 0L));
        TestSizable sizable2 = new TestSizable(10000L);
        Assert.assertTrue((boolean)policy.shouldRollover((Sizable)sizable2, 0L));
    }

    static class TestSizable
    implements Sizable {
        long size;

        TestSizable(long size) {
            this.size = size;
        }

        public long size() {
            return this.size;
        }
    }
}

