/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.bookie;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.util.concurrent.RateLimiter;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import java.io.IOException;
import java.util.List;
import java.util.Optional;
import java.util.PrimitiveIterator;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.bookkeeper.bookie.Bookie;
import org.apache.bookkeeper.bookie.BookieException;
import org.apache.bookkeeper.bookie.BookieStateManager;
import org.apache.bookkeeper.bookie.CacheCallback;
import org.apache.bookkeeper.bookie.CheckpointSource;
import org.apache.bookkeeper.bookie.Checkpointer;
import org.apache.bookkeeper.bookie.CompactableLedgerStorage;
import org.apache.bookkeeper.bookie.EntryKeyValue;
import org.apache.bookkeeper.bookie.EntryLocation;
import org.apache.bookkeeper.bookie.EntryLogger;
import org.apache.bookkeeper.bookie.EntryMemTable;
import org.apache.bookkeeper.bookie.EntryMemTableWithParallelFlusher;
import org.apache.bookkeeper.bookie.GarbageCollectionStatus;
import org.apache.bookkeeper.bookie.InterleavedLedgerStorage;
import org.apache.bookkeeper.bookie.LastAddConfirmedUpdateNotification;
import org.apache.bookkeeper.bookie.LedgerDirsManager;
import org.apache.bookkeeper.bookie.LedgerStorage;
import org.apache.bookkeeper.bookie.SkipListFlusher;
import org.apache.bookkeeper.bookie.StateManager;
import org.apache.bookkeeper.common.util.Watcher;
import org.apache.bookkeeper.conf.ServerConfiguration;
import org.apache.bookkeeper.meta.LedgerManager;
import org.apache.bookkeeper.stats.StatsLogger;
import org.apache.bookkeeper.util.IteratorUtility;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SortedLedgerStorage
implements LedgerStorage,
CacheCallback,
SkipListFlusher,
CompactableLedgerStorage,
EntryLogger.EntryLogListener {
    private static final Logger LOG = LoggerFactory.getLogger(SortedLedgerStorage.class);
    EntryMemTable memTable;
    private ScheduledExecutorService scheduler;
    private StateManager stateManager;
    private final InterleavedLedgerStorage interleavedLedgerStorage;

    public SortedLedgerStorage() {
        this(new InterleavedLedgerStorage());
    }

    @VisibleForTesting
    protected SortedLedgerStorage(InterleavedLedgerStorage ils) {
        this.interleavedLedgerStorage = ils;
    }

    @Override
    public void initialize(ServerConfiguration conf, LedgerManager ledgerManager, LedgerDirsManager ledgerDirsManager, LedgerDirsManager indexDirsManager, StateManager stateManager, CheckpointSource checkpointSource, Checkpointer checkpointer, StatsLogger statsLogger, ByteBufAllocator allocator) throws IOException {
        this.interleavedLedgerStorage.initializeWithEntryLogListener(conf, ledgerManager, ledgerDirsManager, indexDirsManager, stateManager, checkpointSource, checkpointer, this, statsLogger, allocator);
        this.memTable = conf.isEntryLogPerLedgerEnabled() ? new EntryMemTableWithParallelFlusher(conf, checkpointSource, statsLogger) : new EntryMemTable(conf, checkpointSource, statsLogger);
        this.scheduler = Executors.newSingleThreadScheduledExecutor(new ThreadFactoryBuilder().setNameFormat("SortedLedgerStorage-%d").setPriority(7).build());
        this.stateManager = stateManager;
    }

    @VisibleForTesting
    ScheduledExecutorService getScheduler() {
        return this.scheduler;
    }

    @Override
    public void start() {
        try {
            this.flush();
        }
        catch (IOException e) {
            LOG.error("Exception thrown while flushing ledger cache.", (Throwable)e);
        }
        this.interleavedLedgerStorage.start();
    }

    @Override
    public void shutdown() throws InterruptedException {
        this.scheduler.shutdown();
        if (!this.scheduler.awaitTermination(3L, TimeUnit.SECONDS)) {
            this.scheduler.shutdownNow();
        }
        try {
            this.memTable.close();
        }
        catch (Exception e) {
            LOG.error("Error while closing the memtable", (Throwable)e);
        }
        this.interleavedLedgerStorage.shutdown();
    }

    @Override
    public boolean ledgerExists(long ledgerId) throws IOException {
        EntryKeyValue kv;
        if (!this.interleavedLedgerStorage.ledgerExists(ledgerId) && null == (kv = this.memTable.getLastEntry(ledgerId))) {
            return this.interleavedLedgerStorage.ledgerExists(ledgerId);
        }
        return true;
    }

    @Override
    public boolean setFenced(long ledgerId) throws IOException {
        return this.interleavedLedgerStorage.setFenced(ledgerId);
    }

    @Override
    public boolean isFenced(long ledgerId) throws IOException {
        return this.interleavedLedgerStorage.isFenced(ledgerId);
    }

    @Override
    public void setMasterKey(long ledgerId, byte[] masterKey) throws IOException {
        this.interleavedLedgerStorage.setMasterKey(ledgerId, masterKey);
    }

    @Override
    public byte[] readMasterKey(long ledgerId) throws IOException, BookieException {
        return this.interleavedLedgerStorage.readMasterKey(ledgerId);
    }

    @Override
    public long addEntry(ByteBuf entry) throws IOException {
        long ledgerId = entry.getLong(entry.readerIndex() + 0);
        long entryId = entry.getLong(entry.readerIndex() + 8);
        long lac = entry.getLong(entry.readerIndex() + 16);
        this.memTable.addEntry(ledgerId, entryId, entry.nioBuffer(), this);
        this.interleavedLedgerStorage.ledgerCache.updateLastAddConfirmed(ledgerId, lac);
        return entryId;
    }

    private ByteBuf getLastEntryId(long ledgerId) throws IOException {
        EntryKeyValue kv = this.memTable.getLastEntry(ledgerId);
        if (null != kv) {
            return kv.getValueAsByteBuffer();
        }
        return this.interleavedLedgerStorage.getEntry(ledgerId, -1L);
    }

    @Override
    public ByteBuf getEntry(long ledgerId, long entryId) throws IOException {
        ByteBuf buffToRet;
        if (entryId == -1L) {
            return this.getLastEntryId(ledgerId);
        }
        try {
            buffToRet = this.interleavedLedgerStorage.getEntry(ledgerId, entryId);
        }
        catch (Bookie.NoEntryException nee) {
            EntryKeyValue kv = this.memTable.getEntry(ledgerId, entryId);
            buffToRet = null == kv ? this.interleavedLedgerStorage.getEntry(ledgerId, entryId) : kv.getValueAsByteBuffer();
        }
        return buffToRet;
    }

    @Override
    public long getLastAddConfirmed(long ledgerId) throws IOException {
        return this.interleavedLedgerStorage.getLastAddConfirmed(ledgerId);
    }

    @Override
    public boolean waitForLastAddConfirmedUpdate(long ledgerId, long previousLAC, Watcher<LastAddConfirmedUpdateNotification> watcher) throws IOException {
        return this.interleavedLedgerStorage.waitForLastAddConfirmedUpdate(ledgerId, previousLAC, watcher);
    }

    @Override
    public void cancelWaitForLastAddConfirmedUpdate(long ledgerId, Watcher<LastAddConfirmedUpdateNotification> watcher) throws IOException {
        this.interleavedLedgerStorage.cancelWaitForLastAddConfirmedUpdate(ledgerId, watcher);
    }

    @Override
    public void checkpoint(CheckpointSource.Checkpoint checkpoint) throws IOException {
        long numBytesFlushed = this.memTable.flush(this, checkpoint);
        this.interleavedLedgerStorage.getEntryLogger().prepareSortedLedgerStorageCheckpoint(numBytesFlushed);
        this.interleavedLedgerStorage.checkpoint(checkpoint);
    }

    @Override
    public void deleteLedger(long ledgerId) throws IOException {
        this.interleavedLedgerStorage.deleteLedger(ledgerId);
    }

    @Override
    public void registerLedgerDeletionListener(LedgerStorage.LedgerDeletionListener listener) {
        this.interleavedLedgerStorage.registerLedgerDeletionListener(listener);
    }

    @Override
    public void setExplicitlac(long ledgerId, ByteBuf lac) throws IOException {
        this.interleavedLedgerStorage.setExplicitlac(ledgerId, lac);
    }

    @Override
    public ByteBuf getExplicitLac(long ledgerId) {
        return this.interleavedLedgerStorage.getExplicitLac(ledgerId);
    }

    @Override
    public void process(long ledgerId, long entryId, ByteBuf buffer) throws IOException {
        this.interleavedLedgerStorage.processEntry(ledgerId, entryId, buffer, false);
    }

    @Override
    public void flush() throws IOException {
        this.memTable.flush(this, CheckpointSource.Checkpoint.MAX);
        this.interleavedLedgerStorage.flush();
    }

    @Override
    public void onSizeLimitReached(final CheckpointSource.Checkpoint cp) throws IOException {
        LOG.info("Reached size {}", (Object)cp);
        this.scheduler.execute(new Runnable(){

            @Override
            public void run() {
                try {
                    LOG.info("Started flushing mem table.");
                    SortedLedgerStorage.this.interleavedLedgerStorage.getEntryLogger().prepareEntryMemTableFlush();
                    SortedLedgerStorage.this.memTable.flush(SortedLedgerStorage.this);
                    if (SortedLedgerStorage.this.interleavedLedgerStorage.getEntryLogger().commitEntryMemTableFlush()) {
                        ((SortedLedgerStorage)SortedLedgerStorage.this).interleavedLedgerStorage.checkpointer.startCheckpoint(cp);
                    }
                }
                catch (Exception e) {
                    SortedLedgerStorage.this.stateManager.transitionToReadOnlyMode();
                    LOG.error("Exception thrown while flushing skip list cache.", (Throwable)e);
                }
            }
        });
    }

    @Override
    public void onRotateEntryLog() {
    }

    BookieStateManager getStateManager() {
        return (BookieStateManager)this.stateManager;
    }

    @Override
    public EntryLogger getEntryLogger() {
        return this.interleavedLedgerStorage.getEntryLogger();
    }

    @Override
    public Iterable<Long> getActiveLedgersInRange(long firstLedgerId, long lastLedgerId) throws IOException {
        return this.interleavedLedgerStorage.getActiveLedgersInRange(firstLedgerId, lastLedgerId);
    }

    @Override
    public void updateEntriesLocations(Iterable<EntryLocation> locations) throws IOException {
        this.interleavedLedgerStorage.updateEntriesLocations(locations);
    }

    @Override
    public void flushEntriesLocationsIndex() throws IOException {
        this.interleavedLedgerStorage.flushEntriesLocationsIndex();
    }

    @Override
    public LedgerStorage getUnderlyingLedgerStorage() {
        return this.interleavedLedgerStorage;
    }

    @Override
    public void forceGC() {
        this.interleavedLedgerStorage.forceGC();
    }

    @Override
    public List<LedgerStorage.DetectedInconsistency> localConsistencyCheck(Optional<RateLimiter> rateLimiter) throws IOException {
        return this.interleavedLedgerStorage.localConsistencyCheck(rateLimiter);
    }

    @Override
    public boolean isInForceGC() {
        return this.interleavedLedgerStorage.isInForceGC();
    }

    @Override
    public List<GarbageCollectionStatus> getGarbageCollectionStatus() {
        return this.interleavedLedgerStorage.getGarbageCollectionStatus();
    }

    @Override
    public PrimitiveIterator.OfLong getListOfEntriesOfLedger(long ledgerId) throws IOException {
        PrimitiveIterator.OfLong entriesInMemtableItr = this.memTable.getListOfEntriesOfLedger(ledgerId);
        PrimitiveIterator.OfLong entriesFromILSItr = this.interleavedLedgerStorage.getListOfEntriesOfLedger(ledgerId);
        return IteratorUtility.mergePrimitiveLongIterator(entriesInMemtableItr, entriesFromILSItr);
    }
}

