/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.eventbus.impl.codecs;

import io.netty.util.CharsetUtil;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.eventbus.MessageCodec;
import io.vertx.core.json.JsonArray;

public class JsonArrayMessageCodec
implements MessageCodec<JsonArray, JsonArray> {
    @Override
    public void encodeToWire(Buffer buffer, JsonArray jsonArray) {
        String strJson = jsonArray.encode();
        byte[] encoded = strJson.getBytes(CharsetUtil.UTF_8);
        buffer.appendInt(encoded.length);
        Buffer buff = Buffer.buffer(encoded);
        buffer.appendBuffer(buff);
    }

    @Override
    public JsonArray decodeFromWire(int pos, Buffer buffer) {
        int length = buffer.getInt(pos);
        byte[] encoded = buffer.getBytes(pos += 4, pos + length);
        String str = new String(encoded, CharsetUtil.UTF_8);
        return new JsonArray(str);
    }

    @Override
    public JsonArray transform(JsonArray jsonArray) {
        return jsonArray.copy();
    }

    @Override
    public String name() {
        return "jsonarray";
    }

    @Override
    public byte systemCodecID() {
        return 14;
    }
}

