/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sandesha2.util;

import java.io.Serializable;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.sandesha2.i18n.SandeshaMessageHelper;

public class Range
implements Serializable {
    private static final long serialVersionUID = 1701339894096240940L;
    private static final Log log = LogFactory.getLog(Range.class);
    public long lowerValue;
    public long upperValue;

    public Range(long value) {
        this(value, value);
    }

    public Range(long low, long high) {
        if (high < low || high < 0L || low < 0L) {
            throw new IllegalArgumentException(SandeshaMessageHelper.getMessage("invalidRange", "" + low, "" + high));
        }
        this.lowerValue = low;
        this.upperValue = high;
    }

    public Range(String s) {
        s = s.trim();
        int length = s.length();
        if (s.charAt(0) != '[' || s.charAt(length - 1) != ']') {
            String message = SandeshaMessageHelper.getMessage("invalidStringArray", s);
            log.debug((Object)message);
            throw new IllegalArgumentException(message);
        }
        String subStr = s.substring(1, length - 1);
        String[] parts = subStr.split(",");
        if (parts.length != 2) {
            String message = SandeshaMessageHelper.getMessage("invalidStringArray", s);
            log.debug((Object)message);
            throw new IllegalArgumentException(message);
        }
        this.lowerValue = Long.parseLong(parts[0]);
        this.upperValue = Long.parseLong(parts[1]);
    }

    public boolean rangeContainsValue(long value) {
        return value <= this.upperValue && value >= this.lowerValue;
    }

    public String toString() {
        return "[" + this.lowerValue + "," + this.upperValue + "]";
    }

    public int hashCode() {
        int PRIME = 31;
        int result = 1;
        result = 31 * result + (int)(this.lowerValue ^ this.lowerValue >>> 32);
        result = 31 * result + (int)(this.upperValue ^ this.upperValue >>> 32);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Range other = (Range)obj;
        if (this.lowerValue != other.lowerValue) {
            return false;
        }
        return this.upperValue == other.upperValue;
    }
}

