/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ws.secpolicy.model;

import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.apache.neethi.PolicyComponent;
import org.apache.ws.secpolicy.SP11Constants;
import org.apache.ws.secpolicy.SP12Constants;
import org.apache.ws.secpolicy.SPConstants;
import org.apache.ws.secpolicy.model.AbstractSecurityAssertion;
import org.apache.ws.secpolicy.model.Token;
import org.apache.ws.secpolicy.model.TokenWrapper;

public class InitiatorToken
extends AbstractSecurityAssertion
implements TokenWrapper {
    private Token initiatorToken;

    public InitiatorToken(int version) {
        this.setVersion(version);
    }

    public Token getInitiatorToken() {
        return this.initiatorToken;
    }

    public void setInitiatorToken(Token initiatorToken) {
        this.initiatorToken = initiatorToken;
    }

    @Override
    public void setToken(Token tok) {
        this.setInitiatorToken(tok);
    }

    public QName getName() {
        if (this.version == 2) {
            return SP12Constants.INITIATOR_TOKEN;
        }
        return SP11Constants.INITIATOR_TOKEN;
    }

    @Override
    public PolicyComponent normalize() {
        throw new UnsupportedOperationException();
    }

    public void serialize(XMLStreamWriter writer) throws XMLStreamException {
        InitiatorToken.writeStartElement(writer, this.getName());
        InitiatorToken.writeStartElement(writer, SPConstants.POLICY);
        Token token = this.getInitiatorToken();
        if (token == null) {
            throw new RuntimeException("InitiatorToken doesn't contain any token assertions");
        }
        token.serialize(writer);
        writer.writeEndElement();
        writer.writeEndElement();
    }
}

