/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rampart.builder;

import java.util.ArrayList;
import java.util.Base64;
import java.util.Iterator;
import java.util.List;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.soap.SOAPEnvelope;
import org.apache.axis2.context.MessageContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.rahas.TrustException;
import org.apache.rampart.RampartException;
import org.apache.rampart.RampartMessageData;
import org.apache.rampart.builder.BindingBuilder;
import org.apache.rampart.policy.RampartPolicyData;
import org.apache.rampart.util.RampartUtil;
import org.apache.ws.secpolicy.model.AlgorithmSuite;
import org.apache.ws.secpolicy.model.Header;
import org.apache.ws.secpolicy.model.IssuedToken;
import org.apache.ws.secpolicy.model.KerberosToken;
import org.apache.ws.secpolicy.model.SecureConversationToken;
import org.apache.ws.secpolicy.model.SignedEncryptedParts;
import org.apache.ws.secpolicy.model.SupportingToken;
import org.apache.ws.secpolicy.model.Token;
import org.apache.ws.secpolicy.model.UsernameToken;
import org.apache.ws.secpolicy.model.X509Token;
import org.apache.wss4j.common.WSEncryptionPart;
import org.apache.wss4j.common.ext.WSSecurityException;
import org.apache.wss4j.common.util.KeyUtils;
import org.apache.wss4j.dom.message.WSSecDKSign;
import org.apache.wss4j.dom.message.WSSecEncryptedKey;
import org.apache.wss4j.dom.message.WSSecHeader;
import org.apache.wss4j.dom.message.WSSecSignature;
import org.apache.wss4j.dom.message.WSSecUsernameToken;
import org.apache.wss4j.dom.message.token.KerberosSecurity;
import org.apache.wss4j.dom.util.WSSecurityUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class TransportBindingBuilder
extends BindingBuilder {
    private static Log log = LogFactory.getLog(TransportBindingBuilder.class);
    private static Log tlog = LogFactory.getLog((String)"org.apache.rampart.TIME");

    public void build(RampartMessageData rmd) throws RampartException {
        RampartPolicyData rpd;
        log.debug((Object)"TransportBindingBuilder build invoked");
        long t0 = 0L;
        long t1 = 0L;
        if (tlog.isDebugEnabled()) {
            t1 = System.currentTimeMillis();
        }
        if ((rpd = rmd.getPolicyData()).isIncludeTimestamp()) {
            this.addTimestamp(rmd);
        }
        if (rmd.isInitiator()) {
            SupportingToken endSupptokens;
            SupportingToken sgndEndSuppTokens;
            ArrayList<byte[]> signatureValues = new ArrayList<byte[]>();
            SupportingToken sgndSuppTokens = rpd.getSignedSupportingTokens();
            if (sgndSuppTokens != null && sgndSuppTokens.getTokens() != null && sgndSuppTokens.getTokens().size() > 0) {
                log.debug((Object)"Processing signed supporting tokens");
                ArrayList tokens = sgndSuppTokens.getTokens();
                for (Object signedSupportingToken : tokens) {
                    Token token = (Token)signedSupportingToken;
                    if (token instanceof UsernameToken) {
                        WSSecUsernameToken utBuilder = this.addUsernameToken(rmd, (UsernameToken)token);
                        utBuilder.prepare();
                        utBuilder.appendToHeader();
                        continue;
                    }
                    throw new RampartException("unsupportedSignedSupportingToken", new String[]{"{" + token.getName().getNamespaceURI() + "}" + token.getName().getLocalPart()});
                }
            }
            if ((sgndEndSuppTokens = rpd.getSignedEndorsingSupportingTokens()) != null && sgndEndSuppTokens.getTokens() != null && sgndEndSuppTokens.getTokens().size() > 0) {
                log.debug((Object)"Processing endorsing signed supporting tokens");
                ArrayList tokens = sgndEndSuppTokens.getTokens();
                SignedEncryptedParts signdParts = sgndEndSuppTokens.getSignedParts();
                for (Iterator objectToken : tokens) {
                    Token token = (Token)objectToken;
                    if (token instanceof IssuedToken && rmd.isInitiator()) {
                        signatureValues.add(this.doIssuedTokenSignature(rmd, token, signdParts));
                        continue;
                    }
                    if (!(token instanceof X509Token)) continue;
                    signatureValues.add(this.doX509TokenSignature(rmd, token, signdParts));
                }
            }
            if ((endSupptokens = rpd.getEndorsingSupportingTokens()) != null && endSupptokens.getTokens() != null && endSupptokens.getTokens().size() > 0) {
                log.debug((Object)"Processing endorsing supporting tokens");
                ArrayList tokens = endSupptokens.getTokens();
                SignedEncryptedParts signdParts = endSupptokens.getSignedParts();
                for (Object objectToken : tokens) {
                    Token token = (Token)objectToken;
                    if (token instanceof IssuedToken && rmd.isInitiator()) {
                        signatureValues.add(this.doIssuedTokenSignature(rmd, token, signdParts));
                        continue;
                    }
                    if (token instanceof X509Token) {
                        signatureValues.add(this.doX509TokenSignature(rmd, token, signdParts));
                        continue;
                    }
                    if (token instanceof SecureConversationToken) {
                        this.handleSecureConversationTokens(rmd, (SecureConversationToken)token);
                        signatureValues.add(this.doSecureConversationSignature(rmd, token, signdParts));
                        continue;
                    }
                    if (!(token instanceof KerberosToken)) continue;
                    signatureValues.add(this.doKerberosTokenSignature(rmd, (KerberosToken)token, signdParts));
                }
            }
            List<SupportingToken> supportingToks = rpd.getSupportingTokensList();
            for (SupportingToken supportingTok : supportingToks) {
                this.handleSupportingTokens(rmd, supportingTok);
            }
            rmd.getMsgContext().setProperty("_sendSignatureValues_", signatureValues);
        } else {
            this.addSignatureConfirmation(rmd, null);
        }
        if (tlog.isDebugEnabled()) {
            t1 = System.currentTimeMillis();
            tlog.debug((Object)("Transport binding build took " + (t1 - t0)));
        }
    }

    private byte[] doX509TokenSignature(RampartMessageData rmd, Token token, SignedEncryptedParts signdParts) throws RampartException {
        RampartPolicyData rpd = rmd.getPolicyData();
        Document doc = rmd.getDocument();
        ArrayList<WSEncryptionPart> sigParts = new ArrayList<WSEncryptionPart>();
        if (this.timestampElement != null) {
            sigParts.add(new WSEncryptionPart(rmd.getTimestampId()));
        }
        if (signdParts != null) {
            if (signdParts.isBody()) {
                SOAPEnvelope env = rmd.getMsgContext().getEnvelope();
                sigParts.add(new WSEncryptionPart(RampartUtil.addWsuIdToElement((OMElement)env.getBody())));
            }
            ArrayList headers = signdParts.getHeaders();
            for (Header header : headers) {
                WSEncryptionPart wep = new WSEncryptionPart(header.getName(), header.getNamespace(), "Content");
                sigParts.add(wep);
            }
        }
        if (token.isDerivedKeys()) {
            try {
                KeyGenerator keyGen;
                try {
                    keyGen = KeyUtils.getKeyGenerator((String)"http://www.w3.org/2001/04/xmlenc#aes128-cbc");
                }
                catch (WSSecurityException e) {
                    e.printStackTrace();
                    return null;
                }
                SecretKey symmetricKey = keyGen.generateKey();
                WSSecEncryptedKey encrKey = this.getEncryptedKeyBuilder(rmd, token, symmetricKey);
                Element bstElem = encrKey.getBinarySecurityTokenElement();
                if (bstElem != null) {
                    RampartUtil.appendChildToSecHeader(rmd, bstElem);
                }
                encrKey.appendToHeader();
                WSSecDKSign dkSig = new WSSecDKSign(rmd.getSecHeader());
                dkSig.setSigCanonicalization(rpd.getAlgorithmSuite().getInclusiveC14n());
                dkSig.setSignatureAlgorithm(rpd.getAlgorithmSuite().getSymmetricSignature());
                dkSig.setDerivedKeyLength(rpd.getAlgorithmSuite().getSignatureDerivedKeyLength() / 8);
                dkSig.setTokenIdentifier(encrKey.getId());
                dkSig.prepare(encrKey.getEncryptedKeySHA1().getBytes());
                if (rpd.isTokenProtection()) {
                    sigParts.add(new WSEncryptionPart(encrKey.getBSTTokenId()));
                }
                dkSig.getParts().addAll(sigParts);
                dkSig.setDigestAlgorithm(rpd.getAlgorithmSuite().getDigest());
                List referenceList = dkSig.addReferencesToSign(sigParts);
                dkSig.appendDKElementToHeader();
                dkSig.computeSignature(referenceList, false, null);
                return dkSig.getSignatureValue();
            }
            catch (WSSecurityException e) {
                throw new RampartException("errorInDerivedKeyTokenSignature", e);
            }
            catch (Exception e) {
                throw new RampartException("errorInDerivedKeyTokenSignature", e);
            }
        }
        try {
            WSSecSignature sig = this.getSignatureBuilder(rmd, token);
            sig.appendBSTElementToHeader();
            if (rpd.isTokenProtection() && 1 != token.getInclusion()) {
                sigParts.add(new WSEncryptionPart(sig.getBSTTokenId()));
            }
            sig.setDigestAlgo(rpd.getAlgorithmSuite().getDigest());
            List referenceList = sig.addReferencesToSign(sigParts);
            sig.computeSignature(referenceList, false, null);
            return sig.getSignatureValue();
        }
        catch (WSSecurityException e) {
            throw new RampartException("errorInSignatureWithX509Token", e);
        }
    }

    private byte[] doKerberosTokenSignature(RampartMessageData rmd, KerberosToken token, SignedEncryptedParts signdParts) throws RampartException {
        Document doc = rmd.getDocument();
        ArrayList<WSEncryptionPart> sigParts = new ArrayList<WSEncryptionPart>();
        if (this.timestampElement != null) {
            sigParts.add(new WSEncryptionPart(rmd.getTimestampId()));
        }
        if (signdParts != null) {
            if (signdParts.isBody()) {
                SOAPEnvelope env = rmd.getMsgContext().getEnvelope();
                sigParts.add(new WSEncryptionPart(RampartUtil.addWsuIdToElement((OMElement)env.getBody())));
            }
            ArrayList headers = signdParts.getHeaders();
            for (Header header : headers) {
                WSEncryptionPart wep = new WSEncryptionPart(header.getName(), header.getNamespace(), "Content");
                sigParts.add(wep);
            }
        }
        try {
            KerberosSecurity kerberosBst = this.addKerberosToken(rmd, (Token)token);
            kerberosBst.setID("Id-" + kerberosBst.hashCode());
            WSSecSignature sign = new WSSecSignature(rmd.getSecHeader());
            sign.setSignatureAlgorithm("http://www.w3.org/2000/09/xmldsig#hmac-sha1");
            if (token.isRequiresKeyIdentifierReference()) {
                sign.setKeyIdentifierType(12);
                byte[] digestBytes = KeyUtils.generateDigest((byte[])kerberosBst.getToken());
                sign.setCustomTokenId(new String(Base64.getEncoder().encode(digestBytes)));
                sign.setCustomTokenValueType("http://docs.oasis-open.org/wss/oasis-wss-kerberos-token-profile-1.1#Kerberosv5APREQSHA1");
            } else {
                sign.setKeyIdentifierType(9);
                sign.setCustomTokenId(kerberosBst.getID());
                sign.setCustomTokenValueType(kerberosBst.getValueType());
            }
            SecretKey secretKey = kerberosBst.getSecretKey();
            sign.setSecretKey(secretKey.getEncoded());
            sign.prepare(null);
            WSSecurityUtil.prependChildElement((Element)rmd.getSecHeader().getSecurityHeaderElement(), (Element)kerberosBst.getElement());
            List referenceList = sign.addReferencesToSign(sigParts);
            sign.computeSignature(referenceList, false, null);
            return sign.getSignatureValue();
        }
        catch (WSSecurityException e) {
            throw new RampartException("errorInSignatureWithKerberosToken", e);
        }
    }

    private void appendToHeader(WSSecHeader secHeader, Element appendingChild) {
        Element secHeaderElement = secHeader.getSecurityHeaderElement();
        secHeaderElement.appendChild(appendingChild);
    }

    private byte[] doIssuedTokenSignature(RampartMessageData rmd, Token token, SignedEncryptedParts signdParts) throws RampartException {
        List referenceList;
        RampartPolicyData rpd = rmd.getPolicyData();
        Document doc = rmd.getDocument();
        String id = RampartUtil.getIssuedToken(rmd, (IssuedToken)token);
        int inclusion = token.getInclusion();
        org.apache.rahas.Token tok = null;
        try {
            tok = rmd.getTokenStorage().getToken(id);
        }
        catch (TrustException e) {
            throw new RampartException("errorExtractingToken", new String[]{id}, e);
        }
        boolean tokenIncluded = false;
        if (inclusion == 5 || (inclusion == 3 || inclusion == 2) && rmd.isInitiator()) {
            rmd.getSecHeader().getSecurityHeaderElement().appendChild(doc.importNode((Element)tok.getToken(), true));
            tokenIncluded = true;
        }
        ArrayList<WSEncryptionPart> sigParts = new ArrayList<WSEncryptionPart>();
        if (this.timestampElement != null) {
            sigParts.add(new WSEncryptionPart(rmd.getTimestampId()));
        }
        if (rpd.isTokenProtection() && tokenIncluded) {
            sigParts.add(new WSEncryptionPart(id));
        }
        if (signdParts != null) {
            if (signdParts.isBody()) {
                SOAPEnvelope env = rmd.getMsgContext().getEnvelope();
                sigParts.add(new WSEncryptionPart(RampartUtil.addWsuIdToElement((OMElement)env.getBody())));
            }
            ArrayList headers = signdParts.getHeaders();
            for (Object signedHeader : headers) {
                Header header = (Header)signedHeader;
                WSEncryptionPart wep = new WSEncryptionPart(header.getName(), header.getNamespace(), "Content");
                sigParts.add(wep);
            }
        }
        AlgorithmSuite algorithmSuite = rpd.getAlgorithmSuite();
        if (token.isDerivedKeys()) {
            try {
                WSSecDKSign dkSign = new WSSecDKSign(doc);
                OMElement ref = tokenIncluded ? tok.getAttachedReference() : tok.getUnattachedReference();
                if (ref != null) {
                    dkSign.setStrElem((Element)doc.importNode((Element)ref, true));
                } else {
                    dkSign.setTokenIdentifier(tok.getId());
                }
                dkSign.setSignatureAlgorithm(algorithmSuite.getSymmetricSignature());
                dkSign.setDerivedKeyLength(algorithmSuite.getSignatureDerivedKeyLength());
                dkSign.prepare(tok.getSecret());
                dkSign.appendDKElementToHeader();
                dkSign.getParts().addAll(sigParts);
                referenceList = dkSign.addReferencesToSign(sigParts);
                dkSign.computeSignature(referenceList, false, null);
                return dkSign.getSignatureValue();
            }
            catch (WSSecurityException e) {
                throw new RampartException("errorInDerivedKeyTokenSignature", e);
            }
            catch (Exception e) {
                throw new RampartException("errorInDerivedKeyTokenSignature", e);
            }
        }
        try {
            WSSecSignature sig = new WSSecSignature(rmd.getSecHeader());
            String tokId = tok.getId();
            if (tokId.charAt(0) == '#') {
                tokId = tokId.substring(1);
            }
            sig.setCustomTokenId(tokId);
            sig.setCustomTokenValueType(RampartUtil.getSAML10AssertionNamespace());
            sig.setSecretKey(tok.getSecret());
            sig.setSignatureAlgorithm(algorithmSuite.getAsymmetricSignature());
            sig.setSignatureAlgorithm(algorithmSuite.getSymmetricSignature());
            sig.setKeyIdentifierType(9);
            sig.prepare(RampartUtil.getSignatureCrypto(rpd.getRampartConfig(), rmd.getCustomClassLoader()));
            sig.getParts().addAll(sigParts);
            sig.setDigestAlgo(rpd.getAlgorithmSuite().getDigest());
            referenceList = sig.addReferencesToSign(sigParts);
            sig.computeSignature(referenceList);
            this.setInsertionLocation(RampartUtil.insertSiblingAfter(rmd, this.getInsertionLocation(), sig.getSignatureElement()));
            return sig.getSignatureValue();
        }
        catch (WSSecurityException e) {
            throw new RampartException("errorInSignatureWithACustomToken", e);
        }
    }

    private byte[] doSecureConversationSignature(RampartMessageData rmd, Token token, SignedEncryptedParts signdParts) throws RampartException {
        RampartPolicyData rpd = rmd.getPolicyData();
        Document doc = rmd.getDocument();
        String id = rmd.getSecConvTokenId();
        int inclusion = token.getInclusion();
        org.apache.rahas.Token tok = null;
        try {
            tok = rmd.getTokenStorage().getToken(id);
        }
        catch (TrustException e) {
            throw new RampartException("errorExtractingToken", new String[]{id}, e);
        }
        boolean tokenIncluded = false;
        if (inclusion == 5 || (inclusion == 3 || inclusion == 2) && rmd.isInitiator()) {
            rmd.getSecHeader().getSecurityHeaderElement().appendChild(doc.importNode((Element)tok.getToken(), true));
            tokenIncluded = true;
        }
        ArrayList<WSEncryptionPart> sigParts = new ArrayList<WSEncryptionPart>();
        if (this.timestampElement != null) {
            sigParts.add(new WSEncryptionPart(rmd.getTimestampId()));
        }
        if (rpd.isTokenProtection() && tokenIncluded) {
            sigParts.add(new WSEncryptionPart(id));
        }
        if (signdParts != null) {
            if (signdParts.isBody()) {
                SOAPEnvelope env = rmd.getMsgContext().getEnvelope();
                sigParts.add(new WSEncryptionPart(RampartUtil.addWsuIdToElement((OMElement)env.getBody())));
            }
            ArrayList headers = signdParts.getHeaders();
            for (Object objectHeader : headers) {
                Header header = (Header)objectHeader;
                WSEncryptionPart wep = new WSEncryptionPart(header.getName(), header.getNamespace(), "Content");
                sigParts.add(wep);
            }
        }
        AlgorithmSuite algorithmSuite = rpd.getAlgorithmSuite();
        if (token.isDerivedKeys()) {
            try {
                WSSecDKSign dkSign = new WSSecDKSign(rmd.getSecHeader());
                OMElement ref = tokenIncluded ? tok.getAttachedReference() : tok.getUnattachedReference();
                if (ref != null) {
                    dkSign.setStrElem((Element)doc.importNode((Element)ref, true));
                } else {
                    dkSign.setTokenIdentifier(tok.getId());
                }
                dkSign.setSignatureAlgorithm(algorithmSuite.getSymmetricSignature());
                dkSign.setDerivedKeyLength(algorithmSuite.getSignatureDerivedKeyLength());
                dkSign.prepare(tok.getSecret());
                dkSign.appendDKElementToHeader();
                dkSign.getParts().addAll(sigParts);
                List referenceList = dkSign.addReferencesToSign(sigParts);
                dkSign.computeSignature(referenceList, false, null);
                return dkSign.getSignatureValue();
            }
            catch (WSSecurityException e) {
                throw new RampartException("errorInDerivedKeyTokenSignature", e);
            }
            catch (Exception e) {
                throw new RampartException("errorInDerivedKeyTokenSignature", e);
            }
        }
        try {
            WSSecSignature sig = new WSSecSignature(rmd.getSecHeader());
            sig.setCustomTokenId(tok.getId().substring(1));
            sig.setCustomTokenValueType(RampartUtil.getSAML10AssertionNamespace());
            sig.setSecretKey(tok.getSecret());
            sig.setSignatureAlgorithm(algorithmSuite.getAsymmetricSignature());
            sig.setSignatureAlgorithm(algorithmSuite.getSymmetricSignature());
            sig.setKeyIdentifierType(9);
            sig.prepare(RampartUtil.getSignatureCrypto(rpd.getRampartConfig(), rmd.getCustomClassLoader()));
            sig.getParts().addAll(sigParts);
            sig.setDigestAlgo(rpd.getAlgorithmSuite().getDigest());
            List referenceList = sig.addReferencesToSign(sigParts);
            sig.computeSignature(referenceList, false, this.getInsertionLocation());
            this.setInsertionLocation(sig.getSignatureElement());
            return sig.getSignatureValue();
        }
        catch (WSSecurityException e) {
            throw new RampartException("errorInSignatureWithACustomToken", e);
        }
    }

    private void handleSecureConversationTokens(RampartMessageData rmd, SecureConversationToken secConvTok) throws RampartException {
        boolean cancelReqResp;
        MessageContext msgContext = rmd.getMsgContext();
        String secConvTokenId = rmd.getSecConvTokenId();
        String action = msgContext.getOptions().getAction();
        boolean bl = cancelReqResp = action.equals("http://schemas.xmlsoap.org/ws/2005/02/trust/RSTR/SCT/Cancel") || action.equals("http://schemas.xmlsoap.org/ws/2005/02/trust/RSTR/SCT/Cancel") || action.equals("http://schemas.xmlsoap.org/ws/2005/02/trust/RST/SCT/Cancel") || action.equals("http://schemas.xmlsoap.org/ws/2005/02/trust/RST/SCT/Cancel");
        if (secConvTokenId != null && cancelReqResp) {
            try {
                rmd.getTokenStorage().getToken(secConvTokenId).setState(3);
                msgContext.setProperty("sctID", (Object)secConvTokenId);
                String contextIdentifierKey = RampartUtil.getContextIdentifierKey(msgContext);
                RampartUtil.getContextMap(msgContext).remove(contextIdentifierKey);
            }
            catch (TrustException e) {
                throw new RampartException("errorExtractingToken", e);
            }
        }
        if (secConvTokenId == null || secConvTokenId != null && !RampartUtil.isTokenValid(rmd, secConvTokenId) && !cancelReqResp) {
            log.debug((Object)"No SecureConversationToken found, requesting a new token");
            try {
                secConvTokenId = RampartUtil.getSecConvToken(rmd, secConvTok);
                rmd.setSecConvTokenId(secConvTokenId);
            }
            catch (TrustException e) {
                throw new RampartException("errorInObtainingSct", e);
            }
        }
    }
}

