/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.description;

import java.net.URL;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.HashMap;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMElement;
import org.apache.axis2.AxisFault;
import org.apache.axis2.description.AxisOperation;
import org.apache.axis2.description.Flow;
import org.apache.axis2.description.FlowInclude;
import org.apache.axis2.description.Parameter;
import org.apache.axis2.description.ParameterInclude;
import org.apache.axis2.description.ParameterIncludeImpl;
import org.apache.axis2.description.PolicyInclude;
import org.apache.axis2.description.PolicySubject;
import org.apache.axis2.description.Version;
import org.apache.axis2.engine.AxisConfiguration;
import org.apache.axis2.i18n.Messages;
import org.apache.axis2.modules.Module;

public class AxisModule
implements ParameterInclude {
    private final FlowInclude flowInclude = new FlowInclude();
    private final ParameterInclude parameters = new ParameterIncludeImpl();
    private Module module;
    private ClassLoader moduleClassLoader;
    private URL fileName;
    private String name;
    private Version version;
    private HashMap<QName, AxisOperation> operations = new HashMap();
    private AxisConfiguration parent;
    private PolicyInclude policyInclude = null;
    private String moduleDescription;
    private String[] supportedPolicyNames;
    private QName[] localPolicyAssertions;
    public static final String VERSION_SNAPSHOT = "SNAPSHOT";
    public static final String MODULE_SERVICE = "moduleService";
    private PolicySubject policySubject = new PolicySubject();
    private String archiveName;

    public AxisModule() {
    }

    public AxisModule(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getArchiveName() {
        if (this.archiveName == null) {
            this.archiveName = this.version == null ? this.name : this.name + "-" + String.valueOf(this.version);
        }
        return this.archiveName;
    }

    public void setArchiveName(String archiveName) {
        char c;
        int index = 0;
        while ((index = archiveName.indexOf(45, index)) != -1 && ('0' > (c = archiveName.charAt(++index)) || c > '9')) {
        }
        if (index == -1 && archiveName.endsWith("-SNAPSHOT")) {
            index = archiveName.length() - 8;
        }
        if (index == -1) {
            this.name = archiveName;
            this.version = null;
        } else {
            try {
                this.version = new Version(archiveName.substring(index));
            }
            catch (ParseException ex) {
                this.version = null;
            }
            this.name = this.version == null ? archiveName : archiveName.substring(0, index - 1);
        }
    }

    public Version getVersion() {
        return this.version;
    }

    public void setVersion(Version version) {
        this.version = version;
    }

    public void addOperation(AxisOperation axisOperation) {
        this.operations.put(axisOperation.getName(), axisOperation);
    }

    @Override
    public void addParameter(Parameter param) throws AxisFault {
        if (this.isParameterLocked(param.getName())) {
            throw new AxisFault(Messages.getMessage("paramterlockedbyparent", param.getName()));
        }
        this.parameters.addParameter(param);
    }

    @Override
    public void removeParameter(Parameter param) throws AxisFault {
        if (this.isParameterLocked(param.getName())) {
            throw new AxisFault(Messages.getMessage("paramterlockedbyparent", param.getName()));
        }
        this.parameters.removeParameter(param);
    }

    @Override
    public void deserializeParameters(OMElement parameterElement) throws AxisFault {
        this.parameters.deserializeParameters(parameterElement);
    }

    public Flow getFaultInFlow() {
        return this.flowInclude.getFaultInFlow();
    }

    public Flow getFaultOutFlow() {
        return this.flowInclude.getFaultOutFlow();
    }

    public Flow getInFlow() {
        return this.flowInclude.getInFlow();
    }

    public Module getModule() {
        return this.module;
    }

    public ClassLoader getModuleClassLoader() {
        return this.moduleClassLoader;
    }

    public HashMap<QName, AxisOperation> getOperations() {
        return this.operations;
    }

    public Flow getOutFlow() {
        return this.flowInclude.getOutFlow();
    }

    @Override
    public Parameter getParameter(String name) {
        return this.parameters.getParameter(name);
    }

    @Override
    public ArrayList<Parameter> getParameters() {
        return this.parameters.getParameters();
    }

    public AxisConfiguration getParent() {
        return this.parent;
    }

    @Override
    public boolean isParameterLocked(String parameterName) {
        boolean loscked = false;
        if (this.parent != null) {
            loscked = this.parent.isParameterLocked(parameterName);
        }
        if (loscked) {
            return true;
        }
        Parameter parameter = this.getParameter(parameterName);
        return parameter != null && parameter.isLocked();
    }

    public void setFaultInFlow(Flow faultFlow) {
        this.flowInclude.setFaultInFlow(faultFlow);
    }

    public void setFaultOutFlow(Flow faultFlow) {
        this.flowInclude.setFaultOutFlow(faultFlow);
    }

    public void setInFlow(Flow inFlow) {
        this.flowInclude.setInFlow(inFlow);
    }

    public void setModule(Module module) {
        this.module = module;
    }

    public void setModuleClassLoader(ClassLoader moduleClassLoader) {
        this.moduleClassLoader = moduleClassLoader;
    }

    public void setOutFlow(Flow outFlow) {
        this.flowInclude.setOutFlow(outFlow);
    }

    public void setParent(AxisConfiguration parent) {
        this.parent = parent;
    }

    public void setPolicyInclude(PolicyInclude policyInclude) {
        this.policyInclude = policyInclude;
    }

    public PolicyInclude getPolicyInclude() {
        if (this.policyInclude == null) {
            this.policyInclude = new PolicyInclude();
        }
        return this.policyInclude;
    }

    public PolicySubject getPolicySubject() {
        return this.policySubject;
    }

    public String getModuleDescription() {
        return this.moduleDescription;
    }

    public void setModuleDescription(String moduleDescription) {
        this.moduleDescription = moduleDescription;
    }

    public String[] getSupportedPolicyNamespaces() {
        return this.supportedPolicyNames;
    }

    public void setSupportedPolicyNamespaces(String[] supportedPolicyNamespaces) {
        this.supportedPolicyNames = supportedPolicyNamespaces;
    }

    public QName[] getLocalPolicyAssertions() {
        return this.localPolicyAssertions;
    }

    public void setLocalPolicyAssertions(QName[] localPolicyAssertions) {
        this.localPolicyAssertions = localPolicyAssertions;
    }

    public URL getFileName() {
        return this.fileName;
    }

    public void setFileName(URL fileName) {
        this.fileName = fileName;
    }
}

