/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.json.moshi.rpc;

import com.squareup.moshi.JsonReader;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.apache.axis2.AxisFault;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.description.AxisOperation;
import org.apache.axis2.json.moshi.MoshiXMLStreamReader;
import org.apache.axis2.json.moshi.rpc.JsonUtils;
import org.apache.axis2.rpc.receivers.RPCMessageReceiver;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class JsonRpcMessageReceiver
extends RPCMessageReceiver {
    private static final Log log = LogFactory.getLog(RPCMessageReceiver.class);

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void invokeBusinessLogic(MessageContext inMessage, MessageContext outMessage) throws AxisFault {
        Object tempObj = inMessage.getProperty("isJsonStream");
        boolean isJsonStream = tempObj != null ? Boolean.valueOf(tempObj.toString()) : false;
        if (isJsonStream) {
            Object o = inMessage.getProperty("MoshiXMLStreamReader");
            if (o == null) throw new AxisFault("MoshiXMLStreamReader should be put as a property of messageContext to evaluate JSON message");
            MoshiXMLStreamReader moshiXMLStreamReader = (MoshiXMLStreamReader)o;
            JsonReader jsonReader = moshiXMLStreamReader.getJsonReader();
            if (jsonReader == null) {
                throw new AxisFault("JsonReader should not be null");
            }
            Object serviceObj = this.getTheImplementationObject(inMessage);
            AxisOperation op = inMessage.getOperationContext().getAxisOperation();
            String operation = op.getName().getLocalPart();
            String enableJSONOnly = (String)inMessage.getAxisService().getParameterValue("enableJSONOnly");
            this.invokeService(jsonReader, serviceObj, operation, outMessage, enableJSONOnly);
            return;
        } else {
            super.invokeBusinessLogic(inMessage, outMessage);
        }
    }

    public void invokeService(JsonReader jsonReader, Object serviceObj, String operation_name, MessageContext outMes, String enableJSONOnly) throws AxisFault {
        Class<?> implClass = serviceObj.getClass();
        Method[] allMethods = implClass.getDeclaredMethods();
        Method method = JsonUtils.getOpMethod(operation_name, allMethods);
        Class[] paramClasses = method.getParameterTypes();
        try {
            int paramCount = paramClasses.length;
            Object retObj = JsonUtils.invokeServiceClass(jsonReader, serviceObj, method, paramClasses, paramCount, enableJSONOnly);
            outMes.setProperty("returnObject", retObj);
            outMes.setProperty("returnType", method.getReturnType());
        }
        catch (IllegalAccessException e) {
            String msg = "Does not have access to the definition of the specified class, field, method or constructor";
            log.error((Object)msg, (Throwable)e);
            throw AxisFault.makeFault((Throwable)e);
        }
        catch (InvocationTargetException e) {
            String msg = "Exception occurred while trying to invoke service method " + (method != null ? method.getName() : "null");
            log.error((Object)msg, (Throwable)e);
            throw AxisFault.makeFault((Throwable)e);
        }
        catch (IOException e) {
            String msg = "Exception occur while encording or access to the input string at the JsonRpcMessageReceiver";
            log.error((Object)msg, (Throwable)e);
            throw AxisFault.makeFault((Throwable)e);
        }
    }
}

