/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.transport.http.server;

import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;
import org.apache.axis2.transport.http.server.AxisHttpConnection;
import org.apache.axis2.transport.http.server.AxisHttpRequest;
import org.apache.hc.core5.http.ClassicHttpRequest;
import org.apache.hc.core5.http.EntityDetails;
import org.apache.hc.core5.http.Header;
import org.apache.hc.core5.http.HttpException;
import org.apache.hc.core5.http.HttpRequest;
import org.apache.hc.core5.http.ProtocolException;
import org.apache.hc.core5.http.ProtocolVersion;
import org.apache.hc.core5.http.impl.io.SocketHolder;
import org.apache.hc.core5.http.message.BasicHeader;
import org.apache.hc.core5.http.protocol.HttpContext;
import org.apache.hc.core5.http.protocol.HttpProcessor;

public class AxisHttpRequestImpl
implements AxisHttpRequest {
    private final ClassicHttpRequest request;
    private final AxisHttpConnection conn;
    private final HttpProcessor httpproc;
    private final HttpContext context;

    public AxisHttpRequestImpl(AxisHttpConnection conn, ClassicHttpRequest request, HttpProcessor httpproc, HttpContext context) {
        if (conn == null) {
            throw new IllegalArgumentException("Http connection may not be null");
        }
        if (request == null) {
            throw new IllegalArgumentException("Http request may not be null");
        }
        if (httpproc == null) {
            throw new IllegalArgumentException("Http processor may not be null");
        }
        if (context == null) {
            throw new IllegalArgumentException("Http context may not be null");
        }
        this.request = request;
        this.conn = conn;
        this.httpproc = httpproc;
        this.context = context;
    }

    public void prepare() throws IOException, HttpException {
        this.context.setAttribute("http.connection-endpoint", (Object)this.conn);
        this.context.setAttribute("http.request", (Object)this.request);
        this.httpproc.process((HttpRequest)this.request, (EntityDetails)this.request.getEntity(), this.context);
    }

    @Override
    public String getMethod() {
        return this.request.getMethod();
    }

    @Override
    public String getRequestURI() {
        return this.request.getRequestUri();
    }

    public ProtocolVersion getVersion() {
        return this.request.getVersion();
    }

    @Override
    public String getContentType() {
        Header header = this.request.getFirstHeader("Content-Type");
        if (header != null) {
            return header.getValue();
        }
        return null;
    }

    public void setVersion(ProtocolVersion version) {
        this.request.setVersion(version);
    }

    public Header[] getHeaders() {
        return this.request.getHeaders();
    }

    public Header getHeader(String name) throws ProtocolException {
        return this.request.getHeader(name);
    }

    public int countHeaders(String name) {
        return this.request.countHeaders(name);
    }

    public void addHeader(Header header) {
        this.request.addHeader(header);
    }

    public void addHeader(String name, String value) {
        this.request.addHeader(name, (Object)value);
    }

    public void addHeader(String name, Object value) {
        this.request.addHeader(name, value);
    }

    public boolean containsHeader(String name) {
        return this.request.containsHeader(name);
    }

    public Header[] getAllHeaders() {
        return this.request.getHeaders();
    }

    public Header getFirstHeader(String name) {
        return this.request.getFirstHeader(name);
    }

    public Header[] getHeaders(String name) {
        return this.request.getHeaders(name);
    }

    public Header getLastHeader(String name) {
        return this.request.getLastHeader(name);
    }

    public Iterator<Header> headerIterator() {
        return this.request.headerIterator();
    }

    public Iterator<Header> headerIterator(String name) {
        return this.request.headerIterator(name);
    }

    public boolean removeHeader(Header header) {
        return this.request.removeHeader(header);
    }

    public boolean removeHeaders(String name) {
        return this.request.removeHeaders(name);
    }

    public void setHeader(Header header) {
        this.request.setHeader(header);
    }

    public void setHeader(String name, String value) {
        this.request.setHeader(name, (Object)value);
    }

    public void setHeaders(Header[] headers) {
        this.request.setHeaders(headers);
    }

    public void setHeader(String name, Object value) {
        this.request.setHeader((Header)new BasicHeader(name, value));
    }

    @Override
    public SocketHolder getSocketHolder() {
        return this.conn.getSocketHolder();
    }

    @Override
    public InputStream getInputStream() {
        return this.conn.getInputStream();
    }
}

