/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axiom.attachments;

import jakarta.activation.DataHandler;
import jakarta.activation.DataSource;
import java.net.URL;
import org.apache.axiom.blob.Blob;
import org.apache.axiom.mime.ContentTransferEncoding;
import org.apache.axiom.mime.ContentType;
import org.apache.axiom.om.format.xop.ContentTransferEncodingPolicy;
import org.apache.axiom.util.activation.DataHandlerUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ConfigurableDataHandler
extends DataHandler {
    private static final Log log = LogFactory.getLog(ConfigurableDataHandler.class);
    public static final ContentTransferEncodingPolicy CONTENT_TRANSFER_ENCODING_POLICY = new ContentTransferEncodingPolicy(){

        public ContentTransferEncoding getContentTransferEncoding(Blob blob, ContentType contentType) {
            DataHandler dataHandler = DataHandlerUtils.toDataHandler((Blob)blob);
            if (!(dataHandler instanceof ConfigurableDataHandler)) {
                return null;
            }
            String cte = ((ConfigurableDataHandler)dataHandler).getTransferEncoding();
            if (cte == null) {
                return null;
            }
            switch (cte) {
                case "8bit": {
                    return ContentTransferEncoding.EIGHT_BIT;
                }
                case "binary": {
                    return ContentTransferEncoding.BINARY;
                }
                case "base64": {
                    return ContentTransferEncoding.BASE64;
                }
            }
            log.warn((Object)String.format("Unrecognized content transfer encoding: %s", cte));
            return null;
        }
    };
    private String transferEncoding;
    private String contentType;

    public ConfigurableDataHandler(DataSource ds) {
        super(ds);
    }

    public ConfigurableDataHandler(Object data, String type) {
        super(data, type);
    }

    public ConfigurableDataHandler(URL url) {
        super(url);
    }

    public String getContentType() {
        if (this.contentType != null) {
            return this.contentType;
        }
        return super.getContentType();
    }

    public void setContentType(String contentType) {
        this.contentType = contentType;
    }

    public String getTransferEncoding() {
        return this.transferEncoding;
    }

    public void setTransferEncoding(String transferEncoding) {
        this.transferEncoding = transferEncoding;
    }
}

