/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.addressing;

import java.util.HashMap;
import java.util.Map;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMAbstractFactory;
import org.apache.axiom.om.OMContainer;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMNamespace;
import org.apache.axiom.soap.SOAPFactory;
import org.apache.axiom.soap.SOAPFaultCode;
import org.apache.axiom.soap.SOAPFaultSubCode;
import org.apache.axiom.soap.SOAPFaultValue;
import org.apache.axis2.AxisFault;
import org.apache.axis2.addressing.i18n.AddressingMessages;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.context.OperationContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class AddressingFaultsHelper {
    private static final Log log = LogFactory.getLog(AddressingFaultsHelper.class);

    public static String getMessageForAxisFault(String faultCodeLocalName, String faultDetail) {
        String result = null;
        if ("InvalidMessageInformationHeader".equals(faultCodeLocalName)) {
            result = faultDetail != null ? AddressingMessages.getMessage("specificInvalidAddressingHeader", faultDetail) : AddressingMessages.getMessage("invalidAddressingHeader");
        } else if ("InvalidAddressingHeader".equals(faultCodeLocalName)) {
            result = faultDetail != null ? AddressingMessages.getMessage("specificInvalidAddressingHeader", faultDetail) : AddressingMessages.getMessage("invalidAddressingHeader");
        } else if ("InvalidCardinality".equals(faultCodeLocalName)) {
            result = faultDetail != null ? AddressingMessages.getMessage("specificInvalidCardinality", faultDetail) : AddressingMessages.getMessage("invalidCardinality");
        } else if ("MissingAddressInEPR".equals(faultCodeLocalName)) {
            result = faultDetail != null ? AddressingMessages.getMessage("specificMissingAddressInEPR", faultDetail) : AddressingMessages.getMessage("missingAddressInEPR");
        } else if ("DuplicateMessageID".equals(faultCodeLocalName)) {
            result = AddressingMessages.getMessage("duplicateMessageID");
        } else if ("ActionMismatch".equals(faultCodeLocalName)) {
            result = AddressingMessages.getMessage("actionMismatch");
        } else if ("OnlyAnonymousAddressSupported".equals(faultCodeLocalName)) {
            result = faultDetail != null ? AddressingMessages.getMessage("specificOnlyAnonymousSupported", faultDetail) : AddressingMessages.getMessage("onlyAnonymousSupported");
        } else if ("OnlyNonAnonymousAddressSupported".equals(faultCodeLocalName)) {
            result = faultDetail != null ? AddressingMessages.getMessage("specificOnlyNonAnonSupported", faultDetail) : AddressingMessages.getMessage("onlyNonAnonSupported");
        } else if ("MessageInformationHeaderRequired".equals(faultCodeLocalName)) {
            result = faultDetail != null ? AddressingMessages.getMessage("specificAddressingHeaderRequired", faultDetail) : AddressingMessages.getMessage("addressingHeaderRequired");
        } else if ("MessageAddressingHeaderRequired".equals(faultCodeLocalName)) {
            result = faultDetail != null ? AddressingMessages.getMessage("specificAddressingHeaderRequired", faultDetail) : AddressingMessages.getMessage("addressingHeaderRequired");
        } else if ("DestinationUnreachable".equals(faultCodeLocalName)) {
            result = faultDetail != null ? AddressingMessages.getMessage("specificDestinationUnreachable", faultDetail) : AddressingMessages.getMessage("destinationUnreachable");
        } else if ("ActionNotSupported".equals(faultCodeLocalName)) {
            result = faultDetail != null ? AddressingMessages.getMessage("specificActionNotRecognised", faultDetail) : AddressingMessages.getMessage("actionNotRecognised");
        }
        return result;
    }

    public static void triggerInvalidEPRFault(MessageContext messageContext, String incorrectHeaderName) throws AxisFault {
        log.warn((Object)("triggerInvalidEPRFault: messageContext: " + String.valueOf(messageContext) + " incorrectHeaderName: " + incorrectHeaderName));
        String namespace = (String)messageContext.getProperty("WSAddressingVersion");
        if ("http://schemas.xmlsoap.org/ws/2004/08/addressing".equals(namespace)) {
            AddressingFaultsHelper.triggerAddressingFault(messageContext, "ProblemHeaderQName", "wsa:" + incorrectHeaderName, "InvalidMessageInformationHeader", null, AddressingMessages.getMessage("spec.submission.FAULT_INVALID_HEADER_REASON"));
        } else {
            AddressingFaultsHelper.triggerAddressingFault(messageContext, "ProblemHeaderQName", "wsa:" + incorrectHeaderName, "InvalidAddressingHeader", "InvalidEPR", AddressingMessages.getMessage("spec.final.FAULT_INVALID_HEADER_REASON"));
        }
    }

    public static void triggerInvalidCardinalityFault(MessageContext messageContext, String incorrectHeaderName) throws AxisFault {
        log.warn((Object)("triggerInvalidCardinalityFault: messageContext: " + String.valueOf(messageContext) + " incorrectHeaderName: " + incorrectHeaderName));
        String namespace = (String)messageContext.getProperty("WSAddressingVersion");
        if ("http://schemas.xmlsoap.org/ws/2004/08/addressing".equals(namespace)) {
            AddressingFaultsHelper.triggerAddressingFault(messageContext, "ProblemHeaderQName", "wsa:" + incorrectHeaderName, "InvalidMessageInformationHeader", null, AddressingMessages.getMessage("spec.submission.FAULT_INVALID_HEADER_REASON"));
        } else {
            AddressingFaultsHelper.triggerAddressingFault(messageContext, "ProblemHeaderQName", "wsa:" + incorrectHeaderName, "InvalidAddressingHeader", "InvalidCardinality", AddressingMessages.getMessage("spec.final.FAULT_INVALID_HEADER_REASON"));
        }
    }

    public static void triggerMissingAddressInEPRFault(MessageContext messageContext, String incorrectHeaderName) throws AxisFault {
        log.warn((Object)("triggerMissingAddressInEPRFault: messageContext: " + String.valueOf(messageContext) + " incorrectHeaderName: " + incorrectHeaderName));
        String namespace = (String)messageContext.getProperty("WSAddressingVersion");
        if ("http://schemas.xmlsoap.org/ws/2004/08/addressing".equals(namespace)) {
            AddressingFaultsHelper.triggerAddressingFault(messageContext, "ProblemHeaderQName", "wsa:" + incorrectHeaderName, "InvalidMessageInformationHeader", null, AddressingMessages.getMessage("spec.submission.FAULT_INVALID_HEADER_REASON"));
        } else {
            AddressingFaultsHelper.triggerAddressingFault(messageContext, "ProblemHeaderQName", "wsa:" + incorrectHeaderName, "InvalidAddressingHeader", "MissingAddressInEPR", AddressingMessages.getMessage("spec.final.FAULT_INVALID_HEADER_REASON"));
        }
    }

    public static void triggerActionMismatchFault(MessageContext messageContext, String soapAction, String wsaAction) throws AxisFault {
        log.warn((Object)("triggerActionMismatchFault: messageContext: " + String.valueOf(messageContext) + " soapAction=" + soapAction + " wsaAction=" + wsaAction));
        String namespace = (String)messageContext.getProperty("WSAddressingVersion");
        if ("http://schemas.xmlsoap.org/ws/2004/08/addressing".equals(namespace)) {
            AddressingFaultsHelper.triggerAddressingFault(messageContext, "ProblemHeaderQName", "wsa:Action", "InvalidMessageInformationHeader", null, AddressingMessages.getMessage("spec.submission.FAULT_INVALID_HEADER_REASON"));
        } else {
            AddressingFaultsHelper.triggerAddressingFault(messageContext, "ProblemHeaderQName", "wsa:Action", "InvalidAddressingHeader", "ActionMismatch", AddressingMessages.getMessage("spec.final.FAULT_INVALID_HEADER_REASON"));
        }
    }

    public static void triggerOnlyAnonymousAddressSupportedFault(MessageContext messageContext, String incorrectHeaderName) throws AxisFault {
        String namespace;
        if (log.isDebugEnabled()) {
            log.debug((Object)("triggerOnlyAnonymousAddressSupportedFault: messageContext: " + String.valueOf(messageContext) + " incorrectHeaderName: " + incorrectHeaderName));
        }
        if ("http://schemas.xmlsoap.org/ws/2004/08/addressing".equals(namespace = (String)messageContext.getProperty("WSAddressingVersion"))) {
            AddressingFaultsHelper.triggerAddressingFault(messageContext, "ProblemHeaderQName", "wsa:" + incorrectHeaderName, "InvalidMessageInformationHeader", null, AddressingMessages.getMessage("spec.submission.FAULT_INVALID_HEADER_REASON"));
        } else {
            AddressingFaultsHelper.triggerAddressingFault(messageContext, "ProblemHeaderQName", "wsa:" + incorrectHeaderName, "InvalidAddressingHeader", "OnlyAnonymousAddressSupported", AddressingMessages.getMessage("spec.final.FAULT_INVALID_HEADER_REASON"));
        }
    }

    public static void triggerOnlyNonAnonymousAddressSupportedFault(MessageContext messageContext, String incorrectHeaderName) throws AxisFault {
        String namespace;
        if (log.isDebugEnabled()) {
            log.debug((Object)("triggerOnlyNonAnonymousAddressSupportedFault: messageContext: " + String.valueOf(messageContext) + " incorrectHeaderName: " + incorrectHeaderName));
        }
        if ("http://schemas.xmlsoap.org/ws/2004/08/addressing".equals(namespace = (String)messageContext.getProperty("WSAddressingVersion"))) {
            AddressingFaultsHelper.triggerAddressingFault(messageContext, "ProblemHeaderQName", "wsa:" + incorrectHeaderName, "InvalidMessageInformationHeader", null, AddressingMessages.getMessage("spec.submission.FAULT_INVALID_HEADER_REASON"));
        } else {
            AddressingFaultsHelper.triggerAddressingFault(messageContext, "ProblemHeaderQName", "wsa:" + incorrectHeaderName, "InvalidAddressingHeader", "OnlyNonAnonymousAddressSupported", AddressingMessages.getMessage("spec.final.FAULT_INVALID_HEADER_REASON"));
        }
    }

    public static void triggerMessageAddressingRequiredFault(MessageContext messageContext, String missingHeaderName) throws AxisFault {
        String namespace;
        if (log.isDebugEnabled()) {
            log.debug((Object)("triggerMessageAddressingRequiredFault: messageContext: " + String.valueOf(messageContext) + " missingHeaderName: " + missingHeaderName));
        }
        if ("http://schemas.xmlsoap.org/ws/2004/08/addressing".equals(namespace = (String)messageContext.getProperty("WSAddressingVersion"))) {
            AddressingFaultsHelper.triggerAddressingFault(messageContext, "ProblemHeaderQName", "wsa:" + missingHeaderName, "MessageInformationHeaderRequired", null, AddressingMessages.getMessage("spec.submission.FAULT_ADDRESSING_HEADER_REQUIRED_REASON"));
        } else {
            AddressingFaultsHelper.triggerAddressingFault(messageContext, "ProblemHeaderQName", "wsa:" + missingHeaderName, "MessageAddressingHeaderRequired", null, AddressingMessages.getMessage("spec.final.FAULT_ADDRESSING_HEADER_REQUIRED_REASON"));
        }
    }

    public static void triggerDestinationUnreachableFault(MessageContext messageContext, String address) throws AxisFault {
        String namespace;
        if (log.isDebugEnabled()) {
            log.debug((Object)("triggerDestinationUnreachableFault: messageContext: " + String.valueOf(messageContext) + " address: " + address));
        }
        if ("http://schemas.xmlsoap.org/ws/2004/08/addressing".equals(namespace = (String)messageContext.getProperty("WSAddressingVersion"))) {
            AddressingFaultsHelper.triggerAddressingFault(messageContext, "ProblemIRI", null, "DestinationUnreachable", null, AddressingMessages.getMessage("spec.submission.FAULT_ADDRESSING_DESTINATION_UNREACHABLE_REASON"));
        } else {
            AddressingFaultsHelper.triggerAddressingFault(messageContext, "ProblemIRI", address, "DestinationUnreachable", null, AddressingMessages.getMessage("spec.final.FAULT_ADDRESSING_DESTINATION_UNREACHABLE_REASON"));
        }
    }

    public static void triggerActionNotSupportedFault(MessageContext messageContext, String problemAction) throws AxisFault {
        log.warn((Object)("triggerActionNotSupportedFault: messageContext: " + String.valueOf(messageContext) + " problemAction: " + problemAction));
        AddressingFaultsHelper.triggerAddressingFault(messageContext, "ProblemAction", problemAction, "ActionNotSupported", null, AddressingMessages.getMessage("spec.FAULT_ACTION_NOT_SUPPORTED_REASON"));
    }

    private static void triggerAddressingFault(MessageContext messageContext, String faultInformationKey, Object faultInformationValue, String faultcode, String faultSubcode, String faultReason) throws AxisFault {
        HashMap<String, Object> faultInformation = (HashMap<String, Object>)messageContext.getLocalProperty("FaultHeaders");
        if (faultInformation == null) {
            faultInformation = new HashMap<String, Object>();
            messageContext.setProperty("FaultHeaders", faultInformation);
        }
        faultInformation.put(faultInformationKey, faultInformationValue);
        if (messageContext.isSOAP11()) {
            faultcode = faultSubcode != null ? faultSubcode : faultcode;
        } else {
            AddressingFaultsHelper.setFaultCode(messageContext, faultcode, faultSubcode);
        }
        OperationContext oc = messageContext.getOperationContext();
        if (oc != null) {
            oc.setProperty("sendStacktraceDetailsWithFaults", "false");
        }
        messageContext.setProperty("disableAddressingForOutMessages", Boolean.FALSE);
        String namespace = (String)messageContext.getProperty("WSAddressingVersion");
        throw new AxisFault(faultReason, new QName(namespace, faultcode, "wsa"));
    }

    private static void setFaultCode(MessageContext messageContext, String faultCode, String faultSubCode) {
        SOAPFactory soapFac = OMAbstractFactory.getSOAP12Factory();
        SOAPFaultCode soapFaultCode = soapFac.createSOAPFaultCode();
        if (messageContext.isSOAP11()) {
            soapFaultCode.setText(faultCode);
        } else {
            SOAPFaultValue soapFaultValue = soapFac.createSOAPFaultValue(soapFaultCode);
            soapFaultValue.setText("soapenv:Sender");
            SOAPFaultSubCode soapFaultSubCode = soapFac.createSOAPFaultSubCode(soapFaultCode);
            SOAPFaultValue soapFaultSubcodeValue = soapFac.createSOAPFaultValue(soapFaultSubCode);
            if (faultCode != null) {
                String namespace = (String)messageContext.getProperty("WSAddressingVersion");
                if (namespace == null) {
                    namespace = "http://www.w3.org/2005/08/addressing";
                }
                OMNamespace wsaNS = soapFac.createOMNamespace(namespace, "wsa");
                soapFaultSubcodeValue.declareNamespace(wsaNS);
                soapFaultSubcodeValue.setText("wsa:" + faultCode);
            }
            if (faultSubCode != null) {
                SOAPFaultSubCode soapFaultSubCode2 = soapFac.createSOAPFaultSubCode(soapFaultSubCode);
                SOAPFaultValue soapFaultSubcodeValue2 = soapFac.createSOAPFaultValue(soapFaultSubCode2);
                String namespace = (String)messageContext.getProperty("WSAddressingVersion");
                if (namespace == null) {
                    namespace = "http://www.w3.org/2005/08/addressing";
                }
                OMNamespace wsaNS = soapFac.createOMNamespace(namespace, "wsa");
                soapFaultSubcodeValue2.declareNamespace(wsaNS);
                soapFaultSubcodeValue2.setText("wsa:" + faultSubCode);
            }
        }
        messageContext.setProperty("Code", soapFaultCode);
    }

    public static OMElement getDetailElementForAddressingFault(MessageContext messageContext, OMNamespace addressingNamespaceObject) {
        Map faultInfo = (Map)messageContext.getLocalProperty("FaultHeaders");
        OMElement problemDetail = null;
        if (faultInfo != null) {
            String faultyHeaderQName = (String)faultInfo.get("ProblemHeaderQName");
            String faultyAction = (String)faultInfo.get("ProblemAction");
            String faultyAddress = (String)faultInfo.get("ProblemIRI");
            if (faultyAddress != null && !"".equals(faultyAddress)) {
                problemDetail = messageContext.getEnvelope().getOMFactory().createOMElement("ProblemIRI", addressingNamespaceObject);
                problemDetail.setText(faultyAddress);
            }
            if (faultyAction != null && !"".equals(faultyAction)) {
                problemDetail = messageContext.getEnvelope().getOMFactory().createOMElement("ProblemAction", addressingNamespaceObject);
                OMElement probH2 = messageContext.getEnvelope().getOMFactory().createOMElement("Action", addressingNamespaceObject, (OMContainer)problemDetail);
                probH2.setText(faultyAction);
            }
            if (faultyHeaderQName != null && !"".equals(faultyHeaderQName)) {
                problemDetail = messageContext.getEnvelope().getOMFactory().createOMElement("ProblemHeaderQName", addressingNamespaceObject);
                problemDetail.setText(faultyHeaderQName);
            }
        }
        return problemDetail;
    }
}

