/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axiom.om.format.xop;

import org.apache.axiom.blob.Blob;
import org.apache.axiom.mime.ContentTransferEncoding;
import org.apache.axiom.mime.ContentType;
import org.apache.axiom.om.format.xop.ContentTransferEncodingPolicy;

public final class CombinedContentTransferEncodingPolicy
implements ContentTransferEncodingPolicy {
    private final ContentTransferEncodingPolicy[] policies;

    public CombinedContentTransferEncodingPolicy(ContentTransferEncodingPolicy ... policies) {
        this.policies = (ContentTransferEncodingPolicy[])policies.clone();
    }

    @Override
    public ContentTransferEncoding getContentTransferEncoding(Blob blob, ContentType contentType) {
        if (blob == null) {
            return null;
        }
        for (ContentTransferEncodingPolicy policy : this.policies) {
            ContentTransferEncoding cte = policy.getContentTransferEncoding(blob, contentType);
            if (cte == null) continue;
            return cte;
        }
        return null;
    }
}

