/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.app.nc;

import java.io.FilenameFilter;
import java.io.IOException;
import java.nio.channels.ClosedByInterruptException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import org.apache.asterix.common.storage.IIndexCheckpointManager;
import org.apache.asterix.common.storage.IndexCheckpoint;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.api.io.FileReference;
import org.apache.hyracks.api.io.IIOBulkOperation;
import org.apache.hyracks.api.io.IIOManager;
import org.apache.hyracks.api.util.IoUtil;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class IndexCheckpointManager
implements IIndexCheckpointManager {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final int HISTORY_CHECKPOINTS = 1;
    private static final int MAX_CHECKPOINT_WRITE_ATTEMPTS = 5;
    private static final FilenameFilter CHECKPOINT_FILE_FILTER = (file, name) -> name.startsWith(".idx_checkpoint_");
    private static final long BULKLOAD_LSN = 0L;
    private final FileReference indexPath;
    private final IIOManager ioManager;

    public IndexCheckpointManager(FileReference indexPath, IIOManager ioManager) {
        this.indexPath = indexPath;
        this.ioManager = ioManager;
    }

    public synchronized void init(long validComponentSequence, long lsn, long validComponentId, String masterNodeId) throws HyracksDataException {
        List<IndexCheckpoint> checkpoints;
        try {
            checkpoints = this.getCheckpoints();
        }
        catch (ClosedByInterruptException e) {
            throw HyracksDataException.create((Throwable)e);
        }
        if (!checkpoints.isEmpty()) {
            LOGGER.warn(() -> "Checkpoints found on initializing: " + this.indexPath);
            this.delete();
        }
        IndexCheckpoint firstCheckpoint = IndexCheckpoint.first((long)validComponentSequence, (long)lsn, (long)validComponentId, (String)masterNodeId);
        this.persist(firstCheckpoint);
    }

    public synchronized void replicated(long componentSequence, long masterLsn, long componentId, String masterNodeId) throws HyracksDataException {
        Long localLsn = (Long)this.getLatest().getMasterNodeFlushMap().get(masterLsn);
        if (localLsn == null) {
            throw new IllegalStateException("Component replicated before lsn mapping was received");
        }
        this.flushed(componentSequence, localLsn, componentId, masterNodeId);
    }

    public synchronized void flushed(long componentSequence, long lsn, long componentId, String masterNodeId) throws HyracksDataException {
        IndexCheckpoint latest = this.getLatest();
        IndexCheckpoint nextCheckpoint = IndexCheckpoint.next((IndexCheckpoint)latest, (long)lsn, (long)componentSequence, (long)componentId, (String)masterNodeId);
        this.persist(nextCheckpoint);
        this.deleteHistory(nextCheckpoint.getId(), 1);
    }

    public synchronized void flushed(long componentSequence, long lsn, long componentId) throws HyracksDataException {
        this.flushed(componentSequence, lsn, componentId, null);
    }

    public synchronized void masterFlush(long masterLsn, long localLsn) throws HyracksDataException {
        IndexCheckpoint latest = this.getLatest();
        latest.getMasterNodeFlushMap().put(masterLsn, localLsn);
        LOGGER.trace("index {} master flush {} -> {}", (Object)this.indexPath, (Object)masterLsn, (Object)localLsn);
        IndexCheckpoint next = IndexCheckpoint.next((IndexCheckpoint)latest, (long)latest.getLowWatermark(), (long)latest.getValidComponentSequence(), (long)latest.getLastComponentId(), null);
        this.persist(next);
        this.notifyAll();
    }

    public synchronized long getLowWatermark() throws HyracksDataException {
        return this.getLatest().getLowWatermark();
    }

    public synchronized boolean isFlushed(long masterLsn) throws HyracksDataException {
        if (masterLsn == 0L) {
            return true;
        }
        return this.getLatest().getMasterNodeFlushMap().containsKey(masterLsn);
    }

    public synchronized void delete() {
        this.deleteHistory(Long.MAX_VALUE, 0);
    }

    public synchronized boolean isValidIndex() throws HyracksDataException {
        return this.getCheckpointCount() > 0;
    }

    public long getValidComponentSequence() throws HyracksDataException {
        if (this.getCheckpointCount() > 0) {
            return this.getLatest().getValidComponentSequence();
        }
        return -1L;
    }

    public int getCheckpointCount() throws HyracksDataException {
        try {
            return this.getCheckpoints().size();
        }
        catch (ClosedByInterruptException e) {
            throw HyracksDataException.create((Throwable)e);
        }
    }

    public synchronized IndexCheckpoint getLatest() throws HyracksDataException {
        List<IndexCheckpoint> checkpoints;
        try {
            checkpoints = this.getCheckpoints();
        }
        catch (ClosedByInterruptException e) {
            throw HyracksDataException.create((Throwable)e);
        }
        if (checkpoints.isEmpty()) {
            LOGGER.warn("Couldn't find any checkpoint file for index {}. Content of dir are {}.", (Object)this.indexPath, (Object)this.ioManager.list(this.indexPath, IoUtil.NO_OP_FILTER).toString());
            throw new IllegalStateException("Couldn't find any checkpoints for resource: " + this.indexPath);
        }
        checkpoints.sort(Comparator.comparingLong(IndexCheckpoint::getId).reversed());
        return checkpoints.get(0);
    }

    public synchronized void setLastComponentId(long componentId) throws HyracksDataException {
        IndexCheckpoint latest = this.getLatest();
        IndexCheckpoint next = IndexCheckpoint.next((IndexCheckpoint)latest, (long)latest.getLowWatermark(), (long)latest.getValidComponentSequence(), (long)componentId, null);
        this.persist(next);
    }

    public synchronized void advanceValidComponent(long componentSequence, long componentId) throws HyracksDataException {
        IndexCheckpoint latest = this.getLatest();
        if (componentSequence > latest.getValidComponentSequence()) {
            IndexCheckpoint next = IndexCheckpoint.next((IndexCheckpoint)latest, (long)latest.getLowWatermark(), (long)componentSequence, (long)componentId, null);
            this.persist(next);
        }
    }

    private List<IndexCheckpoint> getCheckpoints() throws ClosedByInterruptException, HyracksDataException {
        ArrayList<IndexCheckpoint> checkpoints = new ArrayList<IndexCheckpoint>();
        Set checkpointFiles = this.ioManager.list(this.indexPath, CHECKPOINT_FILE_FILTER);
        if (!checkpointFiles.isEmpty()) {
            for (FileReference checkpointFile : checkpointFiles) {
                try {
                    checkpoints.add(this.read(checkpointFile));
                }
                catch (ClosedByInterruptException e) {
                    throw e;
                }
                catch (IOException e) {
                    LOGGER.warn(() -> "Couldn't read index checkpoint file: " + checkpointFile, (Throwable)e);
                }
            }
        }
        return checkpoints;
    }

    private void persist(IndexCheckpoint checkpoint) throws HyracksDataException {
        FileReference checkpointPath = this.getCheckpointPath(checkpoint);
        for (int i = 1; i <= 5; ++i) {
            try {
                this.ioManager.overwrite(checkpointPath, checkpoint.asJson().getBytes());
                this.read(checkpointPath);
                return;
            }
            catch (ClosedByInterruptException e) {
                LOGGER.info("interrupted while writing checkpoint at {}", (Object)checkpointPath);
                throw HyracksDataException.create((Throwable)e);
            }
            catch (IOException e) {
                if (i == 5) {
                    throw HyracksDataException.create((Throwable)e);
                }
                LOGGER.warn(() -> "Filed to write checkpoint at: " + this.indexPath, (Throwable)e);
                int nextAttempt = i + 1;
                LOGGER.info(() -> "Checkpoint write attempt " + nextAttempt + "/5");
                continue;
            }
        }
    }

    private IndexCheckpoint read(FileReference checkpointPath) throws IOException {
        return IndexCheckpoint.fromJson((String)new String(this.ioManager.readAllBytes(checkpointPath)));
    }

    public void deleteLatest(long latestId, int historyToDelete) {
        try {
            Set checkpointFiles = this.ioManager.list(this.indexPath, CHECKPOINT_FILE_FILTER);
            if (!checkpointFiles.isEmpty()) {
                for (FileReference checkpointFile : checkpointFiles) {
                    if (this.getCheckpointIdFromFileName(checkpointFile) <= latestId - (long)historyToDelete) continue;
                    this.ioManager.delete(checkpointFile);
                }
            }
        }
        catch (Exception e) {
            LOGGER.warn(() -> "Couldn't delete history checkpoints at " + this.indexPath, (Throwable)e);
        }
    }

    private void deleteHistory(long latestId, int historyToKeep) {
        try {
            Set checkpointFiles = this.ioManager.list(this.indexPath, CHECKPOINT_FILE_FILTER);
            if (!checkpointFiles.isEmpty()) {
                IIOBulkOperation deleteBulk = this.ioManager.createDeleteBulkOperation();
                for (FileReference checkpointFile : checkpointFiles) {
                    if (this.getCheckpointIdFromFileName(checkpointFile) >= latestId - (long)historyToKeep) continue;
                    deleteBulk.add(checkpointFile);
                }
                this.ioManager.performBulkOperation(deleteBulk);
            }
        }
        catch (Exception e) {
            LOGGER.warn(() -> "Couldn't delete history checkpoints at " + this.indexPath, (Throwable)e);
        }
    }

    private FileReference getCheckpointPath(IndexCheckpoint checkpoint) {
        return this.indexPath.getChild(".idx_checkpoint_" + checkpoint.getId());
    }

    private long getCheckpointIdFromFileName(FileReference checkpointPath) {
        return Long.parseLong(checkpointPath.getName().substring(".idx_checkpoint_".length()));
    }
}

