/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.om.pointables.cast;

import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.OutputStream;
import java.util.List;
import org.apache.asterix.builders.OrderedListBuilder;
import org.apache.asterix.builders.UnorderedListBuilder;
import org.apache.asterix.om.pointables.AListVisitablePointable;
import org.apache.asterix.om.pointables.PointableAllocator;
import org.apache.asterix.om.pointables.base.DefaultOpenFieldType;
import org.apache.asterix.om.pointables.base.IVisitablePointable;
import org.apache.asterix.om.pointables.cast.ACastVisitor;
import org.apache.asterix.om.types.ATypeTag;
import org.apache.asterix.om.types.AbstractCollectionType;
import org.apache.asterix.om.types.EnumDeserializer;
import org.apache.asterix.om.types.IAType;
import org.apache.asterix.om.utils.ResettableByteArrayOutputStream;
import org.apache.hyracks.algebricks.common.utils.Triple;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.data.std.api.IValueReference;

class AListCaster {
    private final IVisitablePointable itemTempReference = PointableAllocator.allocateUnrestableEmpty();
    private final Triple<IVisitablePointable, IAType, Boolean> itemVisitorArg = new Triple((Object)this.itemTempReference, null, null);
    private final UnorderedListBuilder unOrderedListBuilder = new UnorderedListBuilder();
    private final OrderedListBuilder orderedListBuilder = new OrderedListBuilder();
    private final ResettableByteArrayOutputStream dataBos = new ResettableByteArrayOutputStream();
    private final DataOutput dataDos = new DataOutputStream((OutputStream)((Object)this.dataBos));
    private IAType reqItemType;

    AListCaster() {
    }

    public void castList(AListVisitablePointable listAccessor, IVisitablePointable resultAccessor, AbstractCollectionType reqType, ACastVisitor visitor) throws HyracksDataException {
        if (reqType.getTypeTag().equals(ATypeTag.MULTISET)) {
            this.unOrderedListBuilder.reset(reqType);
            this.reqItemType = reqType.getItemType();
        }
        if (reqType.getTypeTag().equals(ATypeTag.ARRAY)) {
            this.orderedListBuilder.reset(reqType);
            this.reqItemType = reqType.getItemType();
        }
        this.dataBos.reset();
        List<IVisitablePointable> itemTags = listAccessor.getItemTags();
        List<IVisitablePointable> items = listAccessor.getItems();
        int start = this.dataBos.size();
        for (int i = 0; i < items.size(); ++i) {
            IVisitablePointable itemTypeTag = itemTags.get(i);
            IVisitablePointable item = items.get(i);
            ATypeTag typeTag = EnumDeserializer.ATYPETAGDESERIALIZER.deserialize(itemTypeTag.getByteArray()[itemTypeTag.getStartOffset()]);
            this.itemVisitorArg.second = this.reqItemType == null || this.reqItemType.getTypeTag().equals(ATypeTag.ANY) ? DefaultOpenFieldType.getDefaultOpenFieldType(typeTag) : this.reqItemType;
            item.accept(visitor, this.itemVisitorArg);
            if (reqType.getTypeTag().equals(ATypeTag.ARRAY)) {
                this.orderedListBuilder.addItem((IValueReference)this.itemVisitorArg.first);
            }
            if (!reqType.getTypeTag().equals(ATypeTag.MULTISET)) continue;
            this.unOrderedListBuilder.addItem((IValueReference)this.itemVisitorArg.first);
        }
        if (reqType.getTypeTag().equals(ATypeTag.ARRAY)) {
            this.orderedListBuilder.write(this.dataDos, true);
        }
        if (reqType.getTypeTag().equals(ATypeTag.MULTISET)) {
            this.unOrderedListBuilder.write(this.dataDos, true);
        }
        int end = this.dataBos.size();
        resultAccessor.set(this.dataBos.getByteArray(), start, end - start);
    }
}

