/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.app.function;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.asterix.common.exceptions.CompilationException;
import org.apache.asterix.common.exceptions.ErrorCode;
import org.apache.asterix.common.metadata.DataverseName;
import org.apache.asterix.metadata.declared.FunctionDataSource;
import org.apache.asterix.om.base.AOrderedList;
import org.apache.asterix.om.base.AString;
import org.apache.asterix.om.base.IAObject;
import org.apache.asterix.om.exceptions.UnsupportedTypeException;
import org.apache.asterix.om.functions.IFunctionToDataSourceRewriter;
import org.apache.asterix.om.types.ATypeTag;
import org.apache.asterix.om.utils.ConstantExpressionUtil;
import org.apache.asterix.optimizer.rules.UnnestToDataScanRule;
import org.apache.commons.lang3.mutable.Mutable;
import org.apache.hyracks.algebricks.common.exceptions.AlgebricksException;
import org.apache.hyracks.algebricks.core.algebra.base.ILogicalExpression;
import org.apache.hyracks.algebricks.core.algebra.base.ILogicalOperator;
import org.apache.hyracks.algebricks.core.algebra.base.IOptimizationContext;
import org.apache.hyracks.algebricks.core.algebra.base.LogicalExpressionTag;
import org.apache.hyracks.algebricks.core.algebra.base.LogicalVariable;
import org.apache.hyracks.algebricks.core.algebra.expressions.AbstractFunctionCallExpression;
import org.apache.hyracks.algebricks.core.algebra.functions.FunctionIdentifier;
import org.apache.hyracks.algebricks.core.algebra.metadata.IDataSource;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.DataSourceScanOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.UnnestOperator;
import org.apache.hyracks.api.exceptions.SourceLocation;

public abstract class FunctionRewriter
implements IFunctionToDataSourceRewriter {
    FunctionIdentifier functionId;

    public FunctionRewriter(FunctionIdentifier functionId) {
        this.functionId = functionId;
    }

    public final boolean rewrite(Mutable<ILogicalOperator> opRef, IOptimizationContext context) throws AlgebricksException {
        AbstractFunctionCallExpression f = UnnestToDataScanRule.getFunctionCall(opRef);
        List args = f.getArguments();
        if (args.size() != this.functionId.getArity()) {
            throw new CompilationException(ErrorCode.COMPILATION_ERROR, f.getSourceLocation(), new Serializable[]{"Function " + this.functionId.getNamespace() + "." + this.functionId.getName() + " expects " + this.functionId.getArity() + " arguments"});
        }
        for (int i = 0; i < args.size(); ++i) {
            ILogicalExpression argExpr = (ILogicalExpression)((Mutable)args.get(i)).getValue();
            if (argExpr.getExpressionTag() == LogicalExpressionTag.CONSTANT) continue;
            throw new CompilationException(ErrorCode.COMPILATION_ERROR, argExpr.getSourceLocation(), new Serializable[]{"Function " + this.functionId.getNamespace() + "." + this.functionId.getName() + " expects constant arguments while arg[" + i + "] is of type " + argExpr.getExpressionTag()});
        }
        UnnestOperator unnest = (UnnestOperator)opRef.getValue();
        if (unnest.getPositionalVariable() != null) {
            throw new CompilationException(ErrorCode.COMPILATION_ERROR, unnest.getSourceLocation(), new Serializable[]{"No positional variables are allowed over datasource functions"});
        }
        this.createDataScanOp(opRef, unnest, context, f);
        return true;
    }

    protected void createDataScanOp(Mutable<ILogicalOperator> opRef, UnnestOperator unnest, IOptimizationContext context, AbstractFunctionCallExpression f) throws AlgebricksException {
        FunctionDataSource datasource = this.toDatasource(context, f);
        ArrayList<LogicalVariable> variables = new ArrayList<LogicalVariable>();
        variables.add(unnest.getVariable());
        DataSourceScanOperator scan = new DataSourceScanOperator(variables, (IDataSource)datasource);
        scan.setSourceLocation(unnest.getSourceLocation());
        List scanInpList = scan.getInputs();
        scanInpList.addAll(unnest.getInputs());
        opRef.setValue((Object)scan);
        context.computeAndSetTypeEnvironmentForOperator((ILogicalOperator)scan);
    }

    protected abstract FunctionDataSource toDatasource(IOptimizationContext var1, AbstractFunctionCallExpression var2) throws AlgebricksException;

    protected String getString(SourceLocation loc, List<Mutable<ILogicalExpression>> args, int i) throws AlgebricksException {
        IAObject iaObject = ConstantExpressionUtil.getConstantIaObject((ILogicalExpression)((ILogicalExpression)args.get(i).getValue()), null);
        if (iaObject == null) {
            throw new CompilationException(ErrorCode.EXPECTED_CONSTANT_VALUE, loc, new Serializable[0]);
        }
        ATypeTag tt = iaObject.getType().getTypeTag();
        if (tt != ATypeTag.STRING) {
            throw new UnsupportedTypeException(loc, this.functionId, tt);
        }
        return ((AString)iaObject).getStringValue();
    }

    protected DataverseName getDataverseName(SourceLocation loc, List<Mutable<ILogicalExpression>> args, int i) throws AlgebricksException {
        IAObject iaObject = ConstantExpressionUtil.getConstantIaObject((ILogicalExpression)((ILogicalExpression)args.get(i).getValue()), null);
        if (iaObject == null) {
            throw new CompilationException(ErrorCode.EXPECTED_CONSTANT_VALUE, loc, new Serializable[0]);
        }
        ATypeTag tt = iaObject.getType().getTypeTag();
        switch (tt) {
            case STRING: {
                AString str = (AString)iaObject;
                return DataverseName.createSinglePartName((String)str.getStringValue());
            }
            case ARRAY: {
                AOrderedList list = (AOrderedList)iaObject;
                int ln = list.size();
                ArrayList<String> parts = new ArrayList<String>(ln);
                for (int j = 0; j < ln; ++j) {
                    IAObject item = list.getItem(j);
                    ATypeTag itt = item.getType().getTypeTag();
                    if (itt != ATypeTag.STRING) {
                        throw new UnsupportedTypeException(loc, this.functionId, itt);
                    }
                    parts.add(((AString)item).getStringValue());
                }
                return DataverseName.create(parts);
            }
        }
        throw new UnsupportedTypeException(loc, this.functionId, tt);
    }
}

