/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.fuzzyjoin.similarity;

import org.apache.asterix.fuzzyjoin.similarity.IGenericSimilarityMetric;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.data.std.util.ISequenceIterator;
import org.apache.hyracks.data.std.util.UTF8StringCharByCharIterator;
import org.apache.hyracks.util.string.UTF8StringUtil;

public class SimilarityMetricEditDistance
implements IGenericSimilarityMetric {
    private final int rows = 2;
    private int cols = 100;
    private int[][] matrix;
    private final UTF8StringCharByCharIterator leftIt = new UTF8StringCharByCharIterator();
    private final UTF8StringCharByCharIterator rightIt = new UTF8StringCharByCharIterator();
    public static final int SIMILARITY_THRESHOLD_NOT_SATISFIED_VALUE = -1;

    public SimilarityMetricEditDistance() {
        this.matrix = new int[2][this.cols];
    }

    private float computeActualSimilarity(ISequenceIterator firstSequence, ISequenceIterator secondSequence, float simThresh) throws HyracksDataException {
        boolean canTerminateEarly;
        int flLen = firstSequence.size();
        int slLen = secondSequence.size();
        int edThresh = (int)simThresh;
        boolean bl = canTerminateEarly = edThresh >= 0;
        if (slLen >= this.cols) {
            this.cols = slLen + 1;
            this.matrix = new int[2][this.cols];
        }
        for (int i = 0; i <= slLen; ++i) {
            this.matrix[0][i] = i;
        }
        int currRow = 1;
        int prevRow = 0;
        int from = 1;
        int to = slLen;
        int minDistance = -1;
        for (int i = 1; i <= flLen; ++i) {
            int j;
            this.matrix[currRow][0] = i;
            secondSequence.reset();
            if (canTerminateEarly) {
                minDistance = edThresh + 1;
                from = Math.max(i - edThresh - 1, 1);
                to = Math.min(i + edThresh + 1, slLen);
                for (j = 1; j < from; ++j) {
                    secondSequence.next();
                }
                if (from > 1) {
                    this.matrix[currRow][from - 1] = edThresh + 1;
                }
                if (to < slLen) {
                    this.matrix[currRow][to + 1] = edThresh + 1;
                }
            }
            for (j = from; j <= to; ++j) {
                this.matrix[currRow][j] = Math.min(Math.min(this.matrix[prevRow][j] + 1, this.matrix[currRow][j - 1] + 1), this.matrix[prevRow][j - 1] + (firstSequence.compare(secondSequence) == 0 ? 0 : 1));
                if (canTerminateEarly && this.matrix[currRow][j] < minDistance) {
                    minDistance = this.matrix[currRow][j];
                }
                secondSequence.next();
            }
            if (canTerminateEarly && minDistance > edThresh) {
                return -1.0f;
            }
            firstSequence.next();
            int tmp = currRow;
            currRow = prevRow;
            prevRow = tmp;
        }
        return this.matrix[prevRow][slLen];
    }

    @Override
    public float computeSimilarity(ISequenceIterator firstList, ISequenceIterator secondList, float simThresh) throws HyracksDataException {
        int slLen;
        int edThresh = (int)simThresh;
        int flLen = firstList.size();
        if (Math.abs(flLen - (slLen = secondList.size())) > edThresh) {
            return -1.0f;
        }
        float ed = this.computeActualSimilarity(firstList, secondList, simThresh);
        if (ed > (float)edThresh || ed < 0.0f) {
            return -1.0f;
        }
        return ed;
    }

    public int getSimilarityContains(ISequenceIterator exprList, ISequenceIterator patternList, int simThresh) throws HyracksDataException {
        int exprLen = exprList.size();
        int patternLen = patternList.size();
        if (patternLen >= this.cols) {
            this.cols = patternLen + 1;
            this.matrix = new int[2][this.cols];
        }
        for (int i = 0; i <= patternLen; ++i) {
            this.matrix[0][i] = i;
        }
        int currRow = 1;
        int prevRow = 0;
        int minEd = Integer.MAX_VALUE;
        for (int i = 1; i <= exprLen; ++i) {
            this.matrix[currRow][0] = 0;
            patternList.reset();
            for (int j = 1; j <= patternLen; ++j) {
                this.matrix[currRow][j] = Math.min(Math.min(this.matrix[prevRow][j] + 1, this.matrix[currRow][j - 1] + 1), this.matrix[prevRow][j - 1] + (exprList.compare(patternList) == 0 ? 0 : 1));
                patternList.next();
                if (j != patternLen || this.matrix[currRow][patternLen] >= minEd) continue;
                minEd = this.matrix[currRow][patternLen];
            }
            exprList.next();
            int tmp = currRow;
            currRow = prevRow;
            prevRow = tmp;
        }
        if (minEd > simThresh) {
            return -1;
        }
        return minEd;
    }

    public int getActualUTF8StringEditDistanceVal(byte[] leftBytes, int fsStart, byte[] rightBytes, int ssStart, int edThresh) throws HyracksDataException {
        this.leftIt.reset(leftBytes, fsStart);
        this.rightIt.reset(rightBytes, ssStart);
        return (int)this.computeActualSimilarity((ISequenceIterator)this.leftIt, (ISequenceIterator)this.rightIt, edThresh);
    }

    public int UTF8StringEditDistance(byte[] bytesLeft, int fsStart, byte[] bytesRight, int ssStart, int edThresh) throws HyracksDataException {
        int ssStrLen;
        int fsStrLen = UTF8StringUtil.getStringLength((byte[])bytesLeft, (int)fsStart);
        if (Math.abs(fsStrLen - (ssStrLen = UTF8StringUtil.getStringLength((byte[])bytesRight, (int)ssStart))) > edThresh) {
            return -1;
        }
        int ed = this.getActualUTF8StringEditDistanceVal(bytesLeft, fsStart, bytesRight, ssStart, edThresh);
        if (ed > edThresh || ed < 0) {
            return -1;
        }
        return ed;
    }

    public int UTF8StringEditDistanceContains(byte[] strBytes, int stringStart, byte[] patternBytes, int patternStart, int edThresh) throws HyracksDataException {
        this.leftIt.reset(strBytes, stringStart);
        this.rightIt.reset(patternBytes, patternStart);
        return this.getSimilarityContains((ISequenceIterator)this.leftIt, (ISequenceIterator)this.rightIt, edThresh);
    }

    @Override
    public float computeSimilarity(ISequenceIterator firstSequence, ISequenceIterator secondSequence) throws HyracksDataException {
        return this.computeActualSimilarity(firstSequence, secondSequence, -1.0f);
    }
}

