/*
 * Decompiled with CFR 0.152.
 */
package autovalue.shaded.com.google.escapevelocity;

import autovalue.shaded.com.google.common.base.CharMatcher;
import autovalue.shaded.com.google.common.collect.ImmutableList;
import autovalue.shaded.com.google.common.collect.ImmutableSet;
import autovalue.shaded.com.google.common.collect.Iterables;
import autovalue.shaded.com.google.escapevelocity.ConstantExpressionNode;
import autovalue.shaded.com.google.escapevelocity.DirectiveNode;
import autovalue.shaded.com.google.escapevelocity.Macro;
import autovalue.shaded.com.google.escapevelocity.Node;
import autovalue.shaded.com.google.escapevelocity.ParseException;
import autovalue.shaded.com.google.escapevelocity.ReferenceNode;
import autovalue.shaded.com.google.escapevelocity.Template;
import autovalue.shaded.com.google.escapevelocity.TokenNode;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;

class Reparser {
    private static final ImmutableSet<Class<? extends TokenNode>> END_SET = ImmutableSet.of(TokenNode.EndTokenNode.class);
    private static final ImmutableSet<Class<? extends TokenNode>> EOF_SET = ImmutableSet.of(TokenNode.EofNode.class);
    private static final ImmutableSet<Class<? extends TokenNode>> ELSE_ELSE_IF_END_SET = ImmutableSet.of(TokenNode.ElseTokenNode.class, TokenNode.ElseIfTokenNode.class, TokenNode.EndTokenNode.class);
    private final ImmutableList<Node> nodes;
    private int nodeIndex;
    private final Map<String, Macro> macros;

    Reparser(ImmutableList<Node> nodes) {
        this(nodes, new TreeMap<String, Macro>());
    }

    private Reparser(ImmutableList<Node> nodes, Map<String, Macro> macros) {
        this.nodes = Reparser.removeSpaceBeforeSet(nodes);
        this.nodeIndex = 0;
        this.macros = macros;
    }

    Template reparse() {
        Node root = this.reparseNodes();
        this.linkMacroCalls();
        return new Template(root);
    }

    private Node reparseNodes() {
        return this.parseTo(EOF_SET, new TokenNode.EofNode(null, 1));
    }

    private static ImmutableList<Node> removeSpaceBeforeSet(ImmutableList<Node> nodes) {
        assert (Iterables.getLast(nodes) instanceof TokenNode.EofNode);
        ImmutableList.Builder newNodes = ImmutableList.builder();
        for (int i = 0; i < nodes.size(); ++i) {
            Node nodeI = (Node)nodes.get(i);
            newNodes.add(nodeI);
            if (!Reparser.shouldDeleteSpaceBetweenThisAndSet(nodeI) || !Reparser.isWhitespaceLiteral((Node)nodes.get(i + 1)) || !(nodes.get(i + 2) instanceof DirectiveNode.SetNode)) continue;
            ++i;
        }
        return newNodes.build();
    }

    private static boolean shouldDeleteSpaceBetweenThisAndSet(Node node) {
        return node instanceof TokenNode.CommentTokenNode || node instanceof ReferenceNode || node instanceof DirectiveNode.SetNode || node instanceof TokenNode.MacroDefinitionTokenNode;
    }

    private static boolean isWhitespaceLiteral(Node node) {
        if (node instanceof ConstantExpressionNode) {
            Object constant = node.evaluate(null);
            return constant instanceof String && CharMatcher.whitespace().matchesAllOf((String)constant);
        }
        return false;
    }

    private Node parseTo(Set<Class<? extends TokenNode>> stopSet, TokenNode forWhat) {
        Node currentNode;
        ImmutableList.Builder nodeList = ImmutableList.builder();
        while (!stopSet.contains((currentNode = this.currentNode()).getClass())) {
            Node parsed;
            if (currentNode instanceof TokenNode.EofNode) {
                throw new ParseException("Reached end of file while parsing " + forWhat.name(), forWhat.resourceName, forWhat.lineNumber);
            }
            if (currentNode instanceof TokenNode) {
                parsed = this.parseTokenNode();
            } else {
                parsed = currentNode;
                this.nextNode();
            }
            nodeList.add(parsed);
        }
        return Node.cons(forWhat.resourceName, forWhat.lineNumber, (ImmutableList<Node>)nodeList.build());
    }

    private Node currentNode() {
        return (Node)this.nodes.get(this.nodeIndex);
    }

    private Node nextNode() {
        Node currentNode = this.currentNode();
        if (currentNode instanceof TokenNode.EofNode) {
            return currentNode;
        }
        ++this.nodeIndex;
        return this.currentNode();
    }

    private Node parseTokenNode() {
        TokenNode tokenNode = (TokenNode)this.currentNode();
        this.nextNode();
        if (tokenNode instanceof TokenNode.CommentTokenNode) {
            return Node.emptyNode(tokenNode.resourceName, tokenNode.lineNumber);
        }
        if (tokenNode instanceof TokenNode.IfTokenNode) {
            return this.parseIfOrElseIf((TokenNode.IfTokenNode)tokenNode);
        }
        if (tokenNode instanceof TokenNode.ForEachTokenNode) {
            return this.parseForEach((TokenNode.ForEachTokenNode)tokenNode);
        }
        if (tokenNode instanceof TokenNode.NestedTokenNode) {
            return this.parseNested((TokenNode.NestedTokenNode)tokenNode);
        }
        if (tokenNode instanceof TokenNode.MacroDefinitionTokenNode) {
            return this.parseMacroDefinition((TokenNode.MacroDefinitionTokenNode)tokenNode);
        }
        throw new IllegalArgumentException("Unexpected token: " + tokenNode.name() + " on line " + tokenNode.lineNumber);
    }

    private Node parseForEach(TokenNode.ForEachTokenNode forEach) {
        Node body = this.parseTo(END_SET, forEach);
        this.nextNode();
        return new DirectiveNode.ForEachNode(forEach.resourceName, forEach.lineNumber, forEach.var, forEach.collection, body);
    }

    private Node parseIfOrElseIf(TokenNode.IfOrElseIfTokenNode ifOrElseIf) {
        Node falsePart;
        Node truePart = this.parseTo(ELSE_ELSE_IF_END_SET, ifOrElseIf);
        Node token = this.currentNode();
        this.nextNode();
        if (token instanceof TokenNode.EndTokenNode) {
            falsePart = Node.emptyNode(token.resourceName, token.lineNumber);
        } else if (token instanceof TokenNode.ElseTokenNode) {
            falsePart = this.parseTo(END_SET, ifOrElseIf);
            this.nextNode();
        } else if (token instanceof TokenNode.ElseIfTokenNode) {
            falsePart = this.parseIfOrElseIf((TokenNode.ElseIfTokenNode)token);
        } else {
            throw new AssertionError(this.currentNode());
        }
        return new DirectiveNode.IfNode(ifOrElseIf.resourceName, ifOrElseIf.lineNumber, ifOrElseIf.condition, truePart, falsePart);
    }

    private Node parseNested(TokenNode.NestedTokenNode nested) {
        Reparser reparser = new Reparser(nested.nodes, this.macros);
        return reparser.reparseNodes();
    }

    private Node parseMacroDefinition(TokenNode.MacroDefinitionTokenNode macroDefinition) {
        Node body = this.parseTo(END_SET, macroDefinition);
        this.nextNode();
        if (!this.macros.containsKey(macroDefinition.name)) {
            Macro macro = new Macro(macroDefinition.lineNumber, macroDefinition.name, macroDefinition.parameterNames, body);
            this.macros.put(macroDefinition.name, macro);
        }
        return Node.emptyNode(macroDefinition.resourceName, macroDefinition.lineNumber);
    }

    private void linkMacroCalls() {
        for (Node node : this.nodes) {
            if (!(node instanceof DirectiveNode.MacroCallNode)) continue;
            this.linkMacroCall((DirectiveNode.MacroCallNode)node);
        }
    }

    private void linkMacroCall(DirectiveNode.MacroCallNode macroCall) {
        Macro macro = this.macros.get(macroCall.name());
        if (macro == null) {
            throw new ParseException("#" + macroCall.name() + " is neither a standard directive nor a macro that has been defined", macroCall.resourceName, macroCall.lineNumber);
        }
        if (macro.parameterCount() != macroCall.argumentCount()) {
            throw new ParseException("Wrong number of arguments to #" + macroCall.name() + ": expected " + macro.parameterCount() + ", got " + macroCall.argumentCount(), macroCall.resourceName, macroCall.lineNumber);
        }
        macroCall.setMacro(macro);
    }
}

