/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.runtime.operators.joins.interval.utils.memory;

import org.apache.asterix.dataflow.data.nontagged.serde.AIntervalSerializerDeserializer;
import org.apache.asterix.runtime.operators.joins.interval.utils.IIntervalJoinUtil;
import org.apache.asterix.runtime.operators.joins.interval.utils.memory.ITupleCursor;
import org.apache.asterix.runtime.operators.joins.interval.utils.memory.IntervalJoinUtil;
import org.apache.hyracks.api.exceptions.HyracksDataException;

public class IntervalSideTuple {
    int fieldId;
    ITupleCursor cursor;
    long start;
    long end;
    final IIntervalJoinUtil imjc;

    public IntervalSideTuple(IIntervalJoinUtil imjc, ITupleCursor cursor, int fieldId) {
        this.imjc = imjc;
        this.cursor = cursor;
        this.fieldId = fieldId;
    }

    public void loadTuple() {
        int offset = IntervalJoinUtil.getIntervalOffset(this.cursor.getAccessor(), this.cursor.getTupleId(), this.fieldId);
        this.start = AIntervalSerializerDeserializer.getIntervalStart((byte[])this.cursor.getAccessor().getBuffer().array(), (int)offset);
        this.end = AIntervalSerializerDeserializer.getIntervalEnd((byte[])this.cursor.getAccessor().getBuffer().array(), (int)offset);
    }

    public int getTupleIndex() {
        return this.cursor.getTupleId();
    }

    public ITupleCursor getCursor() {
        return this.cursor;
    }

    public long getStart() {
        return this.start;
    }

    public long getEnd() {
        return this.end;
    }

    public boolean compareJoin(IntervalSideTuple ist) throws HyracksDataException {
        return this.imjc.checkToSaveInResult(this.cursor.getAccessor(), this.cursor.getTupleId(), ist.cursor.getAccessor(), ist.cursor.getTupleId());
    }

    public boolean removeFromMemory(IntervalSideTuple ist) {
        return this.imjc.checkToRemoveInMemory(this.cursor.getAccessor(), this.cursor.getTupleId(), ist.cursor.getAccessor(), ist.cursor.getTupleId());
    }

    public boolean checkForEarlyExit(IntervalSideTuple ist) {
        return this.imjc.checkForEarlyExit(this.cursor.getAccessor(), this.cursor.getTupleId(), ist.cursor.getAccessor(), ist.cursor.getTupleId());
    }
}

