/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.blueprint.plugin.model;

import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.Collection;
import java.util.SortedSet;
import java.util.TreeSet;
import javax.inject.Named;
import org.apache.aries.blueprint.plugin.model.Bean;
import org.apache.aries.blueprint.plugin.model.Matcher;
import org.apache.aries.blueprint.plugin.model.OsgiServiceBean;
import org.ops4j.pax.cdi.api.OsgiService;
import org.springframework.beans.factory.annotation.Qualifier;

public class Context
implements Matcher {
    SortedSet<Bean> beans = new TreeSet<Bean>();
    SortedSet<OsgiServiceBean> serviceRefs = new TreeSet<OsgiServiceBean>();

    public Context(Class<?> ... beanClasses) {
        this(Arrays.asList(beanClasses));
    }

    public Context(Collection<Class<?>> beanClasses) {
        this.addBeans(beanClasses);
    }

    private void addBeans(Collection<Class<?>> beanClasses) {
        for (Class<?> clazz : beanClasses) {
            Bean bean = new Bean(clazz);
            this.beans.add(bean);
            this.addServiceRefs(clazz);
        }
    }

    private void addServiceRefs(Class<?> clazz) {
        for (Field field : clazz.getDeclaredFields()) {
            OsgiService osgiService = field.getAnnotation(OsgiService.class);
            if (osgiService == null) continue;
            this.serviceRefs.add(new OsgiServiceBean(field.getType(), osgiService));
        }
    }

    public void resolve() {
        for (Bean bean : this.beans) {
            bean.resolve(this);
        }
    }

    @Override
    public Bean getMatching(Field field) {
        String destId = this.getDestinationId(field);
        for (Bean bean : this.beans) {
            if (!bean.matches(field.getType(), destId)) continue;
            return bean;
        }
        for (Bean bean : this.serviceRefs) {
            if (!bean.matches(field.getType(), destId)) continue;
            return bean;
        }
        return null;
    }

    private String getDestinationId(Field field) {
        Named named = field.getAnnotation(Named.class);
        if (named != null) {
            return named.value();
        }
        Qualifier qualifier = field.getAnnotation(Qualifier.class);
        if (qualifier != null) {
            return qualifier.value();
        }
        return null;
    }

    public SortedSet<Bean> getBeans() {
        return this.beans;
    }

    public SortedSet<OsgiServiceBean> getServiceRefs() {
        return this.serviceRefs;
    }
}

