/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xylem.optimizers.partialeval;

import com.ibm.xylem.Function;
import com.ibm.xylem.IBinding;
import com.ibm.xylem.Instruction;
import com.ibm.xylem.instructions.ApplyInstruction;
import com.ibm.xylem.instructions.FunctionCallInstruction;
import com.ibm.xylem.instructions.IdentifierInstruction;
import com.ibm.xylem.instructions.LambdaInstruction;
import com.ibm.xylem.instructions.LetInstruction;
import com.ibm.xylem.optimizers.partialeval.LetChainManager;
import com.ibm.xylem.optimizers.partialeval.PartialEvaluationResult;
import com.ibm.xylem.optimizers.partialeval.PartialEvaluator;
import com.ibm.xylem.optimizers.partialeval.PartialInformationCollector;
import java.util.HashMap;

public class ApplyEvaluator
extends PartialEvaluator {
    public static LambdaInstruction extractLambda(PartialInformationCollector partialInformationCollector, Instruction instruction, LetChainManager letChainManager) {
        if (instruction == null) {
            return null;
        }
        if (instruction instanceof LambdaInstruction) {
            return (LambdaInstruction)instruction;
        }
        if (instruction instanceof IdentifierInstruction) {
            return ApplyEvaluator.extractLambda(partialInformationCollector, letChainManager.lookupBinding(instruction), letChainManager);
        }
        if (instruction instanceof FunctionCallInstruction) {
            FunctionCallInstruction functionCallInstruction = (FunctionCallInstruction)instruction;
            if (0 != functionCallInstruction.m_parameters.length) {
                return null;
            }
            Function function = letChainManager.getCurrentFunction().getTypeEnvironment().getModule().getFunction(functionCallInstruction.getFunction());
            if (!(function.getBody() instanceof LambdaInstruction)) {
                return null;
            }
            return (LambdaInstruction)function.getBody();
        }
        return null;
    }

    @Override
    public PartialEvaluationResult extractPartialInformation(Instruction instruction, PartialInformationCollector partialInformationCollector, LetInstruction letInstruction, LetChainManager letChainManager) {
        ApplyInstruction applyInstruction = (ApplyInstruction)instruction;
        partialInformationCollector.partiallyEvaluate(applyInstruction.getLambda(), letChainManager);
        LambdaInstruction lambdaInstruction = ApplyEvaluator.extractLambda(partialInformationCollector, applyInstruction.getLambda(), letChainManager);
        if (lambdaInstruction == null) {
            return PartialEvaluationResult.s_emptyResult;
        }
        IBinding[] iBindingArray = lambdaInstruction.getChildInstructionBindings(0);
        Instruction instruction2 = lambdaInstruction.getBody();
        HashMap hashMap = PartialInformationCollector.setupDeconstructionBindingReplacement(applyInstruction.m_parameters, iBindingArray, instruction2, letChainManager, letInstruction);
        instruction2 = instruction2.assignNewNames(hashMap);
        IdentifierInstruction identifierInstruction = letChainManager.insertBody(instruction2, letInstruction);
        return new PartialEvaluationResult((Instruction)identifierInstruction, true);
    }
}

