/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xylem;

import com.ibm.xylem.Binding;
import com.ibm.xylem.ITypeStore;
import com.ibm.xylem.Instruction;
import com.ibm.xylem.Type;
import com.ibm.xylem.types.BigIntegerType;
import com.ibm.xylem.types.ByteType;
import com.ibm.xylem.types.CharType;
import com.ibm.xylem.types.DecimalType;
import com.ibm.xylem.types.DoubleType;
import com.ibm.xylem.types.FloatType;
import com.ibm.xylem.types.IntType;
import com.ibm.xylem.types.JavaObjectType;
import com.ibm.xylem.types.LambdaType;
import com.ibm.xylem.types.LongType;
import com.ibm.xylem.types.NamedType;
import com.ibm.xylem.types.ShortType;
import com.ibm.xylem.types.SlotType;
import com.ibm.xylem.types.StreamType;
import com.ibm.xylem.types.TupleType;
import com.ibm.xylem.types.TypeLambda;
import com.ibm.xylem.types.TypeVariable;
import com.ibm.xylem.types.UnitType;
import java.io.IOException;
import java.io.ObjectOutput;

public class WriteObjectFileHelper {
    protected ObjectOutput m_out;
    protected ITypeStore m_typeStore;

    public WriteObjectFileHelper(ITypeStore iTypeStore, ObjectOutput objectOutput) {
        this.m_out = objectOutput;
        this.m_typeStore = iTypeStore;
    }

    public void writeString(String string) throws IOException {
        this.m_out.writeUTF(string);
    }

    public void writeBindingName(Object object) throws IOException {
        if (object instanceof String) {
            this.m_out.writeByte(1);
            this.writeString((String)object);
        } else if (object instanceof Integer) {
            this.m_out.writeByte(2);
            this.m_out.writeInt((Integer)object);
        } else {
            this.m_out.writeByte(3);
            this.m_out.writeObject(object);
        }
    }

    public void writeInstructionTag(Instruction instruction) throws IOException {
        this.writeString(instruction.getClass().getName());
    }

    public void writeInt(int n) throws IOException {
        this.m_out.writeInt(n);
    }

    public void writeByte(int n) throws IOException {
        this.m_out.writeByte(n);
    }

    public void writeBoolean(boolean bl) throws IOException {
        this.m_out.writeBoolean(bl);
    }

    public void writeInstruction(Instruction instruction) throws IOException {
        this.writeInstructionTag(instruction);
        instruction.write(this);
    }

    public void writeType(Type type) throws IOException {
        if (type instanceof StreamType) {
            this.writeByte(1);
            this.writeType(((StreamType)type).getElementType());
        } else if (type instanceof SlotType) {
            this.writeByte(2);
            this.writeType(((SlotType)type).getElementType());
        } else if (type instanceof TupleType) {
            this.writeByte(3);
            TupleType tupleType = (TupleType)type;
            Type[] typeArray = tupleType.getElementTypes();
            int n = typeArray.length;
            this.writeInt(n);
            for (int i = 0; i < n; ++i) {
                this.writeType(typeArray[i]);
            }
        } else if (type instanceof LambdaType) {
            this.writeByte(4);
            LambdaType lambdaType = (LambdaType)type;
            this.writeBoolean(lambdaType.isPure());
            this.writeType(lambdaType.getReturnType());
            Type[] typeArray = lambdaType.getElementTypes();
            int n = typeArray.length;
            this.writeInt(n);
            for (int i = 0; i < n; ++i) {
                this.writeType(typeArray[i]);
            }
        } else if (IntType.s_intType.equals(type)) {
            this.writeByte(5);
        } else if (ShortType.s_shortType.equals(type)) {
            this.writeByte(6);
        } else if (LongType.s_longType.equals(type)) {
            this.writeByte(7);
        } else if (FloatType.s_floatType.equals(type)) {
            this.writeByte(8);
        } else if (DoubleType.s_doubleType.equals(type)) {
            this.writeByte(9);
        } else if (CharType.s_charType.equals(type)) {
            this.writeByte(10);
        } else if (ByteType.s_byteType.equals(type)) {
            this.writeByte(11);
        } else if (BigIntegerType.s_bigIntegerType.equals(type)) {
            this.writeByte(12);
        } else if (DecimalType.s_decimalType.equals(type)) {
            this.writeByte(13);
        } else if (UnitType.s_unitType.equals(type)) {
            this.writeByte(14);
        } else if (JavaObjectType.s_javaStringType.equals(type)) {
            this.writeByte(15);
        } else if (type instanceof TypeVariable) {
            this.writeByte(16);
            this.m_out.writeObject(type);
        } else if (type instanceof NamedType) {
            int n;
            this.writeByte(17);
            NamedType namedType = (NamedType)type;
            this.writeString(namedType.getName());
            this.writeBoolean(namedType.getModule() != null);
            if (namedType.getModule() != null) {
                this.writeString(namedType.getModule());
            }
            if ((n = namedType.getChildTypeCount()) > 0) {
                this.writeTypes(namedType.getTypeParameters());
            } else {
                this.writeInt(0);
            }
        } else if (type instanceof JavaObjectType) {
            this.writeByte(18);
            this.writeString(((JavaObjectType)type).getClassName());
        } else {
            this.writeByte(19);
            this.writeObject(type);
        }
    }

    public void writeTypeSpecificBindingSet(Binding[] bindingArray) throws IOException {
        int n = bindingArray.length;
        this.writeInt(n);
        for (int i = 0; i < n; ++i) {
            this.writeBindingName(bindingArray[i].getName());
            this.writeType(bindingArray[i].getBindingType());
        }
    }

    public void writeTypes(Type[] typeArray) throws IOException {
        int n = typeArray.length;
        this.writeInt(n);
        for (int i = 0; i < n; ++i) {
            this.writeType(typeArray[i]);
        }
    }

    public void writeObject(Object object) throws IOException {
        this.m_out.writeObject(object);
    }

    public void writeBindingNames(Binding[] bindingArray) throws IOException {
        int n = bindingArray.length;
        this.writeInt(n);
        for (int i = 0; i < n; ++i) {
            this.writeBindingName(bindingArray[i].getName());
        }
    }

    public void writeBindingNames(Object[] objectArray) throws IOException {
        int n = objectArray.length;
        this.writeInt(n);
        for (int i = 0; i < n; ++i) {
            this.writeBindingName(objectArray[i]);
        }
    }

    public void close() throws IOException {
        this.m_out.close();
        this.m_out = null;
    }

    public void writeTypeLambda(TypeLambda typeLambda) throws IOException {
        this.writeObject(typeLambda);
    }
}

