/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xylem;

import com.ibm.xylem.Binding;
import com.ibm.xylem.BindingEnvironment;
import com.ibm.xylem.ISpecialForm;
import com.ibm.xylem.ITypeStore;
import com.ibm.xylem.Instruction;
import com.ibm.xylem.ModuleSignatureStore;
import com.ibm.xylem.ObjectFactory;
import com.ibm.xylem.ReductionHelper;
import com.ibm.xylem.Type;
import com.ibm.xylem.types.BigIntegerType;
import com.ibm.xylem.types.ByteType;
import com.ibm.xylem.types.CharType;
import com.ibm.xylem.types.DecimalType;
import com.ibm.xylem.types.DoubleType;
import com.ibm.xylem.types.FloatType;
import com.ibm.xylem.types.IntType;
import com.ibm.xylem.types.JavaObjectType;
import com.ibm.xylem.types.LambdaType;
import com.ibm.xylem.types.LongType;
import com.ibm.xylem.types.NamedType;
import com.ibm.xylem.types.ShortType;
import com.ibm.xylem.types.SlotType;
import com.ibm.xylem.types.TupleType;
import com.ibm.xylem.types.TypeLambda;
import com.ibm.xylem.types.TypeVariable;
import com.ibm.xylem.types.UnitType;
import java.io.IOException;
import java.io.ObjectInput;
import java.util.HashMap;

public class ReadObjectFileHelper {
    protected ObjectInput m_in;
    protected ITypeStore m_typeStore;
    protected ModuleSignatureStore m_mss;
    private HashMap m_instructionClasses = new HashMap();

    public ReadObjectFileHelper(ITypeStore iTypeStore, ObjectInput objectInput, ModuleSignatureStore moduleSignatureStore) {
        this.m_in = objectInput;
        this.m_typeStore = iTypeStore;
        this.m_mss = moduleSignatureStore;
    }

    public String readString() throws IOException {
        return this.m_in.readUTF();
    }

    public Object readBindingName() throws Exception {
        switch (this.m_in.readByte()) {
            case 1: {
                return this.readString();
            }
            case 2: {
                return ReductionHelper.newIdentifier(this.m_in.readInt());
            }
        }
        return this.m_in.readObject();
    }

    public int readInt() throws IOException {
        return this.m_in.readInt();
    }

    public int readByte() throws IOException {
        return this.m_in.readByte();
    }

    public boolean readBoolean() throws IOException {
        return this.m_in.readBoolean();
    }

    public Instruction readInstruction(BindingEnvironment bindingEnvironment) throws Exception {
        String string = this.readString();
        Class clazz = (Class)this.m_instructionClasses.get(string);
        if (clazz == null) {
            clazz = ObjectFactory.findProviderClass(string, ObjectFactory.findClassLoader(), true);
            this.m_instructionClasses.put(string, clazz);
        }
        Instruction instruction = (Instruction)clazz.newInstance();
        instruction.read(this, bindingEnvironment);
        return instruction;
    }

    public Type readType() throws Exception {
        byte by = this.m_in.readByte();
        switch (by) {
            case 1: {
                return this.readType().getStreamType();
            }
            case 2: {
                return new SlotType(this.readType());
            }
            case 3: {
                int n = this.m_in.readInt();
                Type[] typeArray = new Type[n];
                for (int i = 0; i < n; ++i) {
                    typeArray[i] = this.readType();
                }
                return new TupleType(typeArray);
            }
            case 4: {
                boolean bl = this.readBoolean();
                Type type = this.readType();
                int n = this.m_in.readInt();
                Type[] typeArray = new Type[n];
                for (int i = 0; i < n; ++i) {
                    typeArray[i] = this.readType();
                }
                return new LambdaType(typeArray, type, bl);
            }
            case 5: {
                return IntType.s_intType;
            }
            case 6: {
                return ShortType.s_shortType;
            }
            case 7: {
                return LongType.s_longType;
            }
            case 8: {
                return FloatType.s_floatType;
            }
            case 9: {
                return DoubleType.s_doubleType;
            }
            case 10: {
                return CharType.s_charType;
            }
            case 11: {
                return ByteType.s_byteType;
            }
            case 12: {
                return BigIntegerType.s_bigIntegerType;
            }
            case 13: {
                return DecimalType.s_decimalType;
            }
            case 14: {
                return UnitType.s_unitType;
            }
            case 15: {
                return JavaObjectType.s_javaStringType;
            }
            case 16: {
                return (TypeVariable)this.m_in.readObject();
            }
            case 17: {
                String string = this.readString();
                String string2 = this.readBoolean() ? this.readString() : null;
                Type[] typeArray = this.readTypes();
                return new NamedType(string, string2, (Type[])(typeArray.length > 0 ? typeArray : null));
            }
            case 18: {
                String string = this.readString();
                return new JavaObjectType(string);
            }
            case 19: {
                return (Type)this.m_in.readObject();
            }
        }
        throw new UnsupportedOperationException("" + by);
    }

    public Binding[] readTypeSpecificBindingSet() throws Exception {
        return this.readTypeSpecificBindingSet(null);
    }

    public Binding[] readTypeSpecificBindingSet(ISpecialForm iSpecialForm) throws Exception {
        int n = this.readInt();
        Binding[] bindingArray = new Binding[n];
        for (int i = 0; i < n; ++i) {
            bindingArray[i] = new Binding(this.readBindingName(), this.readType(), iSpecialForm);
        }
        return bindingArray;
    }

    public Type[] readTypes() throws Exception {
        int n = this.readInt();
        Type[] typeArray = new Type[n];
        for (int i = 0; i < n; ++i) {
            typeArray[i] = this.readType();
        }
        return typeArray;
    }

    public Object readObject() throws Exception {
        return this.m_in.readObject();
    }

    public Object[] readBindingNames() throws Exception {
        int n = this.readInt();
        Object[] objectArray = new Object[n];
        for (int i = 0; i < n; ++i) {
            objectArray[i] = this.readBindingName();
        }
        return objectArray;
    }

    public void close() throws IOException {
        this.m_in.close();
        this.m_in = null;
    }

    public TypeLambda readTypeLambda() throws Exception {
        return (TypeLambda)this.m_in.readObject();
    }
}

