/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.jetty.bio;

import java.io.IOException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.HashSet;
import java.util.Set;
import org.mortbay.io.Buffer;
import org.mortbay.io.ByteArrayBuffer;
import org.mortbay.io.EndPoint;
import org.mortbay.io.bio.SocketEndPoint;
import org.mortbay.jetty.AbstractConnector;
import org.mortbay.jetty.EofException;
import org.mortbay.jetty.HttpConnection;
import org.mortbay.jetty.HttpException;
import org.mortbay.jetty.Request;
import org.mortbay.log.Log;

public class SocketConnector
extends AbstractConnector {
    protected ServerSocket _serverSocket;
    protected Set _connections;

    @Override
    public Object getConnection() {
        return this._serverSocket;
    }

    @Override
    public void open() throws IOException {
        if (this._serverSocket == null || this._serverSocket.isClosed()) {
            this._serverSocket = this.newServerSocket(this.getHost(), this.getPort(), this.getAcceptQueueSize());
        }
        this._serverSocket.setReuseAddress(this.getReuseAddress());
    }

    protected ServerSocket newServerSocket(String host, int port, int backlog) throws IOException {
        ServerSocket ss = host == null ? new ServerSocket(port, backlog) : new ServerSocket(port, backlog, InetAddress.getByName(host));
        return ss;
    }

    @Override
    public void close() throws IOException {
        if (this._serverSocket != null) {
            this._serverSocket.close();
        }
        this._serverSocket = null;
    }

    @Override
    public void accept(int acceptorID) throws IOException, InterruptedException {
        Socket socket = this._serverSocket.accept();
        this.configure(socket);
        Connection connection = new Connection(socket);
        connection.dispatch();
    }

    protected HttpConnection newHttpConnection(EndPoint endpoint) {
        return new HttpConnection(this, endpoint, this.getServer());
    }

    @Override
    protected Buffer newBuffer(int size) {
        return new ByteArrayBuffer(size);
    }

    @Override
    public void customize(EndPoint endpoint, Request request) throws IOException {
        Connection connection = (Connection)endpoint;
        if (connection._sotimeout != this._maxIdleTime) {
            connection._sotimeout = this._maxIdleTime;
            ((Socket)endpoint.getTransport()).setSoTimeout(this._maxIdleTime);
        }
        super.customize(endpoint, request);
    }

    @Override
    public int getLocalPort() {
        if (this._serverSocket == null || this._serverSocket.isClosed()) {
            return -1;
        }
        return this._serverSocket.getLocalPort();
    }

    @Override
    protected void doStart() throws Exception {
        this._connections = new HashSet();
        super.doStart();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void doStop() throws Exception {
        super.doStop();
        HashSet set = null;
        Set set2 = this._connections;
        synchronized (set2) {
            set = new HashSet(this._connections);
        }
        for (Connection connection : set) {
            connection.close();
        }
    }

    protected class Connection
    extends SocketEndPoint
    implements Runnable {
        boolean _dispatched;
        HttpConnection _connection;
        int _sotimeout;
        protected Socket _socket;

        public Connection(Socket socket) throws IOException {
            super(socket);
            this._dispatched = false;
            this._connection = SocketConnector.this.newHttpConnection(this);
            this._sotimeout = socket.getSoTimeout();
            this._socket = socket;
        }

        public void dispatch() throws InterruptedException, IOException {
            if (SocketConnector.this.getThreadPool() == null || !SocketConnector.this.getThreadPool().dispatch(this)) {
                Log.warn("dispatch failed for {}", this._connection);
                this.close();
            }
        }

        @Override
        public int fill(Buffer buffer) throws IOException {
            int l = super.fill(buffer);
            if (l < 0) {
                this.close();
            }
            return l;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                SocketConnector.this.connectionOpened(this._connection);
                Set set = SocketConnector.this._connections;
                synchronized (set) {
                    SocketConnector.this._connections.add(this);
                }
                while (SocketConnector.this.isStarted() && !this.isClosed()) {
                    int lrmit;
                    if (this._connection.isIdle() && SocketConnector.this.getServer().getThreadPool().isLowOnThreads() && (lrmit = SocketConnector.this.getLowResourceMaxIdleTime()) >= 0 && this._sotimeout != lrmit) {
                        this._sotimeout = lrmit;
                        this._socket.setSoTimeout(this._sotimeout);
                    }
                    this._connection.handle();
                }
            }
            catch (EofException e) {
                Log.debug("EOF", e);
                try {
                    this.close();
                }
                catch (IOException e2) {
                    Log.ignore(e2);
                }
            }
            catch (HttpException e) {
                Log.debug("BAD", e);
                try {
                    this.close();
                }
                catch (IOException e2) {
                    Log.ignore(e2);
                }
            }
            catch (Throwable e) {
                Log.warn("handle failed", e);
                try {
                    this.close();
                }
                catch (IOException e2) {
                    Log.ignore(e2);
                }
            }
            finally {
                SocketConnector.this.connectionClosed(this._connection);
                Set e = SocketConnector.this._connections;
                synchronized (e) {
                    SocketConnector.this._connections.remove(this);
                }
            }
        }
    }
}

