/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xalan.transformer;

import javax.xml.transform.TransformerException;
import org.apache.xalan.res.XSLMessages;
import org.apache.xalan.templates.ElemTemplate;
import org.apache.xalan.templates.ElemTemplateElement;
import org.apache.xalan.transformer.TransformerImpl;
import org.apache.xml.utils.ObjectStack;

public class StackGuard {
    private int m_recursionLimit = -1;
    TransformerImpl m_transformer;

    public int getRecursionLimit() {
        return this.m_recursionLimit;
    }

    public void setRecursionLimit(int n) {
        this.m_recursionLimit = n;
    }

    public StackGuard(TransformerImpl transformerImpl) {
        this.m_transformer = transformerImpl;
    }

    public int countLikeTemplates(ElemTemplate elemTemplate, int n) {
        ObjectStack objectStack = this.m_transformer.getCurrentTemplateElements();
        int n2 = 1;
        for (int i = n - 1; i >= 0; --i) {
            if ((ElemTemplateElement)objectStack.elementAt(i) != elemTemplate) continue;
            ++n2;
        }
        return n2;
    }

    private ElemTemplate getNextMatchOrNamedTemplate(int n) {
        ObjectStack objectStack = this.m_transformer.getCurrentTemplateElements();
        for (int i = n; i >= 0; --i) {
            ElemTemplateElement elemTemplateElement = (ElemTemplateElement)objectStack.elementAt(i);
            if (null == elemTemplateElement || elemTemplateElement.getXSLToken() != 19) continue;
            return (ElemTemplate)elemTemplateElement;
        }
        return null;
    }

    public void checkForInfinateLoop() throws TransformerException {
        ElemTemplate elemTemplate;
        int n = this.m_transformer.getCurrentTemplateElementsCount();
        if (n < this.m_recursionLimit) {
            return;
        }
        if (this.m_recursionLimit <= 0) {
            return;
        }
        for (int i = n - 1; i >= this.m_recursionLimit && null != (elemTemplate = this.getNextMatchOrNamedTemplate(i)); --i) {
            int n2 = this.countLikeTemplates(elemTemplate, i);
            if (n2 < this.m_recursionLimit) continue;
            String string = XSLMessages.createMessage(null != elemTemplate.getName() ? "nameIs" : "matchPatternIs", null);
            Object[] objectArray = new Object[]{new Integer(n2), string, null != elemTemplate.getName() ? elemTemplate.getName().toString() : elemTemplate.getMatch().getPatternString()};
            String string2 = XSLMessages.createMessage("recursionTooDeep", objectArray);
            throw new TransformerException(string2);
        }
    }
}

