/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xylem;

import com.ibm.xylem.BindingEnvironment;
import com.ibm.xylem.IBinding;
import com.ibm.xylem.Instruction;
import com.ibm.xylem.Logger;
import com.ibm.xylem.instructions.IdentifierInstruction;
import com.ibm.xylem.instructions.LetBaseInstruction;
import com.ibm.xylem.instructions.LetInstruction;
import com.ibm.xylem.instructions.LiteralInstruction;
import com.ibm.xylem.optimizers.OptimizerUtilities;
import com.ibm.xylem.utils.XylemError;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;

public class NavigationUtilities {
    protected static final Logger s_logger = Logger.getInstance(NavigationUtilities.class);

    public static Instruction skipLets(Instruction instruction) {
        while (instruction instanceof LetInstruction) {
            instruction = ((LetInstruction)instruction).getBody();
        }
        return instruction;
    }

    public static Instruction resolveReducedIdentifierAsMuchAsPossibleWithoutExceptions(Instruction instruction, BindingEnvironment bindingEnvironment) {
        while (instruction instanceof IdentifierInstruction) {
            IdentifierInstruction identifierInstruction = (IdentifierInstruction)instruction;
            IBinding iBinding = identifierInstruction.getBinding(bindingEnvironment);
            if (iBinding == null) {
                return identifierInstruction;
            }
            if (iBinding.getLet() != null) {
                Instruction instruction2;
                instruction = instruction2 = iBinding.getLet().getValue();
                if (instruction2 instanceof IdentifierInstruction) continue;
            }
            return instruction;
        }
        return instruction;
    }

    public static Instruction resolveIdentifierAliases(Instruction instruction, BindingEnvironment bindingEnvironment) {
        while (instruction instanceof IdentifierInstruction) {
            IdentifierInstruction identifierInstruction = (IdentifierInstruction)instruction;
            IBinding iBinding = identifierInstruction.getBinding(bindingEnvironment);
            if (iBinding == null) {
                System.err.println(">> " + bindingEnvironment);
                throw new XylemError("ERR_SYSTEM", "binding not found! " + identifierInstruction.getVariable());
            }
            if (iBinding.getLet() != null) {
                Instruction instruction2 = iBinding.getLet().getValue();
                if (instruction2 instanceof IdentifierInstruction) {
                    instruction = instruction2;
                    continue;
                }
                if (instruction2 instanceof LiteralInstruction) {
                    return instruction2;
                }
            }
            return identifierInstruction;
        }
        return instruction;
    }

    public static Instruction resolveReducedIdentifier(Instruction instruction, BindingEnvironment bindingEnvironment) {
        if (instruction instanceof IdentifierInstruction) {
            IdentifierInstruction identifierInstruction = (IdentifierInstruction)instruction;
            IBinding iBinding = identifierInstruction.getBinding(bindingEnvironment);
            if (iBinding == null) {
                System.err.println(">> " + bindingEnvironment);
                throw new XylemError("ERR_SYSTEM", "binding not found! " + identifierInstruction.getVariable());
            }
            if (iBinding.getLet() != null) {
                Instruction instruction2 = iBinding.getLet().getValue();
                return NavigationUtilities.resolveReducedIdentifier(instruction2, bindingEnvironment);
            }
            return null;
        }
        return instruction;
    }

    public static Set resolveFreeBindingsForReducedExpression(Instruction instruction, Instruction instruction2, BindingEnvironment bindingEnvironment) {
        return NavigationUtilities.resolveFreeBindingsForReducedExpression(instruction, instruction2, bindingEnvironment, null);
    }

    public static Set resolveFreeBindingsForReducedExpression(Instruction instruction, Instruction instruction2, BindingEnvironment bindingEnvironment, List list) {
        Object object2;
        HashSet<IBinding> hashSet = new HashSet<IBinding>();
        HashMap<IBinding, Instruction> hashMap = new HashMap<IBinding, Instruction>();
        HashSet hashSet2 = new HashSet();
        ArrayList arrayList = new ArrayList();
        OptimizerUtilities.skipLets(instruction2, arrayList);
        for (Object object2 : arrayList) {
            hashMap.put(((LetBaseInstruction)object2).getBinding(), ((LetBaseInstruction)object2).getValue());
        }
        object2 = new LinkedList();
        ((LinkedList)object2).add(instruction);
        do {
            instruction = (Instruction)((LinkedList)object2).removeLast();
            hashSet2.clear();
            instruction.accumulateNonLiteralFreeBindings(hashSet2, bindingEnvironment);
            for (IBinding iBinding : hashSet2) {
                Instruction instruction3 = (Instruction)hashMap.get(iBinding);
                if (instruction3 == null) {
                    hashSet.add(iBinding);
                    continue;
                }
                ((LinkedList)object2).add(instruction3);
                if (list == null) continue;
                list.add(iBinding);
            }
        } while (!((AbstractCollection)object2).isEmpty());
        return hashSet;
    }
}

