/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xtq.xml.dtm.ref;

import com.ibm.xtq.common.utils.IntVector;
import java.util.Vector;

public class DTMStringPool {
    Vector m_intToString;
    static final int HASHPRIME = 101;
    int[] m_hashStart = new int[101];
    IntVector m_hashChain;
    public static final int NULL = -1;

    public DTMStringPool(int n) {
        this.m_intToString = new Vector();
        this.m_hashChain = new IntVector(n);
        this.removeAllElements();
        this.stringToIndex("");
    }

    public DTMStringPool() {
        this(512);
    }

    public void removeAllElements() {
        this.m_intToString.removeAllElements();
        for (int i = 0; i < 101; ++i) {
            this.m_hashStart[i] = -1;
        }
        this.m_hashChain.removeAllElements();
    }

    public String indexToString(int n) throws ArrayIndexOutOfBoundsException {
        if (n == -1) {
            return null;
        }
        return (String)this.m_intToString.elementAt(n);
    }

    public int stringToIndex(String string) {
        int n;
        if (string == null) {
            return -1;
        }
        int n2 = string.hashCode() % 101;
        if (n2 < 0) {
            n2 = -n2;
        }
        int n3 = n = this.m_hashStart[n2];
        while (n3 != -1) {
            if (this.m_intToString.elementAt(n3).equals(string)) {
                return n3;
            }
            n = n3;
            n3 = this.m_hashChain.elementAt(n3);
        }
        int n4 = this.m_intToString.size();
        this.m_intToString.addElement(string);
        this.m_hashChain.addElement(-1);
        if (n == -1) {
            this.m_hashStart[n2] = n4;
        } else {
            this.m_hashChain.setElementAt(n4, n);
        }
        return n4;
    }

    public static void main(String[] stringArray) {
        String[] stringArray2 = new String[]{"Zero", "One", "Two", "Three", "Four", "Five", "Six", "Seven", "Eight", "Nine", "Ten", "Eleven", "Twelve", "Thirteen", "Fourteen", "Fifteen", "Sixteen", "Seventeen", "Eighteen", "Nineteen", "Twenty", "Twenty-One", "Twenty-Two", "Twenty-Three", "Twenty-Four", "Twenty-Five", "Twenty-Six", "Twenty-Seven", "Twenty-Eight", "Twenty-Nine", "Thirty", "Thirty-One", "Thirty-Two", "Thirty-Three", "Thirty-Four", "Thirty-Five", "Thirty-Six", "Thirty-Seven", "Thirty-Eight", "Thirty-Nine"};
        DTMStringPool dTMStringPool = new DTMStringPool();
        System.out.println("If no complaints are printed below, we passed initial test.");
        for (int i = 0; i <= 1; ++i) {
            int n;
            int n2;
            for (n2 = 0; n2 < stringArray2.length; ++n2) {
                n = dTMStringPool.stringToIndex(stringArray2[n2]);
                if (n == n2) continue;
                System.out.println("\tMismatch populating pool: assigned " + n + " for create " + n2);
            }
            for (n2 = 0; n2 < stringArray2.length; ++n2) {
                n = dTMStringPool.stringToIndex(stringArray2[n2]);
                if (n == n2) continue;
                System.out.println("\tMismatch in stringToIndex: returned " + n + " for lookup " + n2);
            }
            for (n2 = 0; n2 < stringArray2.length; ++n2) {
                String string = dTMStringPool.indexToString(n2);
                if (stringArray2[n2].equals(string)) continue;
                System.out.println("\tMismatch in indexToString: returned" + string + " for lookup " + n2);
            }
            dTMStringPool.removeAllElements();
            System.out.println("\nPass " + i + " complete\n");
        }
    }
}

