/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.sqm.tree.domain;

import org.hibernate.metamodel.mapping.CollectionPart;
import org.hibernate.metamodel.model.domain.EntityDomainType;
import org.hibernate.query.hql.spi.SqmCreationProcessingState;
import org.hibernate.query.sqm.NodeBuilder;
import org.hibernate.query.sqm.SqmPathSource;
import org.hibernate.query.sqm.tree.SqmCopyContext;
import org.hibernate.query.sqm.tree.domain.SqmMapJoin;
import org.hibernate.query.sqm.tree.domain.SqmTreatedPath;
import org.hibernate.spi.NavigablePath;

public class SqmTreatedMapJoin<O, K, V, S extends V>
extends SqmMapJoin<O, K, S>
implements SqmTreatedPath<V, S> {
    private final SqmMapJoin<O, K, V> wrappedPath;
    private final EntityDomainType<S> treatTarget;

    public SqmTreatedMapJoin(SqmMapJoin<O, K, V> wrappedPath, EntityDomainType<S> treatTarget, String alias) {
        this(wrappedPath, treatTarget, alias, false);
    }

    public SqmTreatedMapJoin(SqmMapJoin<O, K, V> wrappedPath, EntityDomainType<S> treatTarget, String alias, boolean fetched) {
        super(wrappedPath.getLhs(), wrappedPath.getNavigablePath().append(CollectionPart.Nature.ELEMENT.getName()).treatAs(treatTarget.getHibernateEntityName(), alias), wrappedPath.getModel(), alias, wrappedPath.getSqmJoinType(), fetched, (NodeBuilder)wrappedPath.nodeBuilder());
        this.treatTarget = treatTarget;
        this.wrappedPath = wrappedPath;
    }

    private SqmTreatedMapJoin(NavigablePath navigablePath, SqmMapJoin<O, K, V> wrappedPath, EntityDomainType<S> treatTarget, String alias, boolean fetched) {
        super(wrappedPath.getLhs(), navigablePath, wrappedPath.getModel(), alias, wrappedPath.getSqmJoinType(), fetched, (NodeBuilder)wrappedPath.nodeBuilder());
        this.treatTarget = treatTarget;
        this.wrappedPath = wrappedPath;
    }

    @Override
    public SqmTreatedMapJoin<O, K, V, S> copy(SqmCopyContext context) {
        SqmTreatedMapJoin existing = context.getCopy(this);
        if (existing != null) {
            return existing;
        }
        SqmTreatedMapJoin<O, K, V, S> path = context.registerCopy(this, new SqmTreatedMapJoin<O, K, V, S>(this.getNavigablePath(), this.wrappedPath.copy(context), this.treatTarget, this.getExplicitAlias(), this.isFetched()));
        this.copyTo(path, context);
        return path;
    }

    public SqmMapJoin<O, K, V> getWrappedPath() {
        return this.wrappedPath;
    }

    @Override
    public EntityDomainType<S> getTreatTarget() {
        return this.treatTarget;
    }

    @Override
    public SqmPathSource<S> getNodeType() {
        return this.treatTarget;
    }

    @Override
    public EntityDomainType<S> getReferencedPathSource() {
        return this.treatTarget;
    }

    @Override
    public SqmPathSource<?> getResolvedModel() {
        return this.treatTarget;
    }

    @Override
    public SqmMapJoin<O, K, S> makeCopy(SqmCreationProcessingState creationProcessingState) {
        return new SqmTreatedMapJoin<O, K, V, S>(this.wrappedPath, this.treatTarget, this.getAlias());
    }

    @Override
    public void appendHqlString(StringBuilder sb) {
        sb.append("treat(");
        this.wrappedPath.appendHqlString(sb);
        sb.append(" as ");
        sb.append(this.treatTarget.getName());
        sb.append(')');
    }
}

