/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ec2.model;

import com.amazonaws.internal.ListWithAutoConstructFlag;
import com.amazonaws.services.ec2.model.PrivateIpAddressSpecification;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class InstanceNetworkInterfaceSpecification
implements Serializable {
    private String networkInterfaceId;
    private Integer deviceIndex;
    private String subnetId;
    private String description;
    private String privateIpAddress;
    private ListWithAutoConstructFlag<String> groups;
    private Boolean deleteOnTermination;
    private ListWithAutoConstructFlag<PrivateIpAddressSpecification> privateIpAddresses;
    private Integer secondaryPrivateIpAddressCount;
    private Boolean associatePublicIpAddress;

    public String getNetworkInterfaceId() {
        return this.networkInterfaceId;
    }

    public void setNetworkInterfaceId(String networkInterfaceId) {
        this.networkInterfaceId = networkInterfaceId;
    }

    public InstanceNetworkInterfaceSpecification withNetworkInterfaceId(String networkInterfaceId) {
        this.networkInterfaceId = networkInterfaceId;
        return this;
    }

    public Integer getDeviceIndex() {
        return this.deviceIndex;
    }

    public void setDeviceIndex(Integer deviceIndex) {
        this.deviceIndex = deviceIndex;
    }

    public InstanceNetworkInterfaceSpecification withDeviceIndex(Integer deviceIndex) {
        this.deviceIndex = deviceIndex;
        return this;
    }

    public String getSubnetId() {
        return this.subnetId;
    }

    public void setSubnetId(String subnetId) {
        this.subnetId = subnetId;
    }

    public InstanceNetworkInterfaceSpecification withSubnetId(String subnetId) {
        this.subnetId = subnetId;
        return this;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public InstanceNetworkInterfaceSpecification withDescription(String description) {
        this.description = description;
        return this;
    }

    public String getPrivateIpAddress() {
        return this.privateIpAddress;
    }

    public void setPrivateIpAddress(String privateIpAddress) {
        this.privateIpAddress = privateIpAddress;
    }

    public InstanceNetworkInterfaceSpecification withPrivateIpAddress(String privateIpAddress) {
        this.privateIpAddress = privateIpAddress;
        return this;
    }

    public List<String> getGroups() {
        if (this.groups == null) {
            this.groups = new ListWithAutoConstructFlag();
            this.groups.setAutoConstruct(true);
        }
        return this.groups;
    }

    public void setGroups(Collection<String> groups) {
        if (groups == null) {
            this.groups = null;
            return;
        }
        ListWithAutoConstructFlag groupsCopy = new ListWithAutoConstructFlag(groups.size());
        groupsCopy.addAll(groups);
        this.groups = groupsCopy;
    }

    public InstanceNetworkInterfaceSpecification withGroups(String ... groups) {
        if (this.getGroups() == null) {
            this.setGroups(new ArrayList<String>(groups.length));
        }
        for (String value : groups) {
            this.getGroups().add(value);
        }
        return this;
    }

    public InstanceNetworkInterfaceSpecification withGroups(Collection<String> groups) {
        if (groups == null) {
            this.groups = null;
        } else {
            ListWithAutoConstructFlag groupsCopy = new ListWithAutoConstructFlag(groups.size());
            groupsCopy.addAll(groups);
            this.groups = groupsCopy;
        }
        return this;
    }

    public Boolean isDeleteOnTermination() {
        return this.deleteOnTermination;
    }

    public void setDeleteOnTermination(Boolean deleteOnTermination) {
        this.deleteOnTermination = deleteOnTermination;
    }

    public InstanceNetworkInterfaceSpecification withDeleteOnTermination(Boolean deleteOnTermination) {
        this.deleteOnTermination = deleteOnTermination;
        return this;
    }

    public Boolean getDeleteOnTermination() {
        return this.deleteOnTermination;
    }

    public List<PrivateIpAddressSpecification> getPrivateIpAddresses() {
        if (this.privateIpAddresses == null) {
            this.privateIpAddresses = new ListWithAutoConstructFlag();
            this.privateIpAddresses.setAutoConstruct(true);
        }
        return this.privateIpAddresses;
    }

    public void setPrivateIpAddresses(Collection<PrivateIpAddressSpecification> privateIpAddresses) {
        if (privateIpAddresses == null) {
            this.privateIpAddresses = null;
            return;
        }
        ListWithAutoConstructFlag privateIpAddressesCopy = new ListWithAutoConstructFlag(privateIpAddresses.size());
        privateIpAddressesCopy.addAll(privateIpAddresses);
        this.privateIpAddresses = privateIpAddressesCopy;
    }

    public InstanceNetworkInterfaceSpecification withPrivateIpAddresses(PrivateIpAddressSpecification ... privateIpAddresses) {
        if (this.getPrivateIpAddresses() == null) {
            this.setPrivateIpAddresses(new ArrayList<PrivateIpAddressSpecification>(privateIpAddresses.length));
        }
        for (PrivateIpAddressSpecification value : privateIpAddresses) {
            this.getPrivateIpAddresses().add(value);
        }
        return this;
    }

    public InstanceNetworkInterfaceSpecification withPrivateIpAddresses(Collection<PrivateIpAddressSpecification> privateIpAddresses) {
        if (privateIpAddresses == null) {
            this.privateIpAddresses = null;
        } else {
            ListWithAutoConstructFlag privateIpAddressesCopy = new ListWithAutoConstructFlag(privateIpAddresses.size());
            privateIpAddressesCopy.addAll(privateIpAddresses);
            this.privateIpAddresses = privateIpAddressesCopy;
        }
        return this;
    }

    public Integer getSecondaryPrivateIpAddressCount() {
        return this.secondaryPrivateIpAddressCount;
    }

    public void setSecondaryPrivateIpAddressCount(Integer secondaryPrivateIpAddressCount) {
        this.secondaryPrivateIpAddressCount = secondaryPrivateIpAddressCount;
    }

    public InstanceNetworkInterfaceSpecification withSecondaryPrivateIpAddressCount(Integer secondaryPrivateIpAddressCount) {
        this.secondaryPrivateIpAddressCount = secondaryPrivateIpAddressCount;
        return this;
    }

    public Boolean isAssociatePublicIpAddress() {
        return this.associatePublicIpAddress;
    }

    public void setAssociatePublicIpAddress(Boolean associatePublicIpAddress) {
        this.associatePublicIpAddress = associatePublicIpAddress;
    }

    public InstanceNetworkInterfaceSpecification withAssociatePublicIpAddress(Boolean associatePublicIpAddress) {
        this.associatePublicIpAddress = associatePublicIpAddress;
        return this;
    }

    public Boolean getAssociatePublicIpAddress() {
        return this.associatePublicIpAddress;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getNetworkInterfaceId() != null) {
            sb.append("NetworkInterfaceId: " + this.getNetworkInterfaceId() + ",");
        }
        if (this.getDeviceIndex() != null) {
            sb.append("DeviceIndex: " + this.getDeviceIndex() + ",");
        }
        if (this.getSubnetId() != null) {
            sb.append("SubnetId: " + this.getSubnetId() + ",");
        }
        if (this.getDescription() != null) {
            sb.append("Description: " + this.getDescription() + ",");
        }
        if (this.getPrivateIpAddress() != null) {
            sb.append("PrivateIpAddress: " + this.getPrivateIpAddress() + ",");
        }
        if (this.getGroups() != null) {
            sb.append("Groups: " + this.getGroups() + ",");
        }
        if (this.isDeleteOnTermination() != null) {
            sb.append("DeleteOnTermination: " + this.isDeleteOnTermination() + ",");
        }
        if (this.getPrivateIpAddresses() != null) {
            sb.append("PrivateIpAddresses: " + this.getPrivateIpAddresses() + ",");
        }
        if (this.getSecondaryPrivateIpAddressCount() != null) {
            sb.append("SecondaryPrivateIpAddressCount: " + this.getSecondaryPrivateIpAddressCount() + ",");
        }
        if (this.isAssociatePublicIpAddress() != null) {
            sb.append("AssociatePublicIpAddress: " + this.isAssociatePublicIpAddress());
        }
        sb.append("}");
        return sb.toString();
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getNetworkInterfaceId() == null ? 0 : this.getNetworkInterfaceId().hashCode());
        hashCode = 31 * hashCode + (this.getDeviceIndex() == null ? 0 : this.getDeviceIndex().hashCode());
        hashCode = 31 * hashCode + (this.getSubnetId() == null ? 0 : this.getSubnetId().hashCode());
        hashCode = 31 * hashCode + (this.getDescription() == null ? 0 : this.getDescription().hashCode());
        hashCode = 31 * hashCode + (this.getPrivateIpAddress() == null ? 0 : this.getPrivateIpAddress().hashCode());
        hashCode = 31 * hashCode + (this.getGroups() == null ? 0 : this.getGroups().hashCode());
        hashCode = 31 * hashCode + (this.isDeleteOnTermination() == null ? 0 : this.isDeleteOnTermination().hashCode());
        hashCode = 31 * hashCode + (this.getPrivateIpAddresses() == null ? 0 : this.getPrivateIpAddresses().hashCode());
        hashCode = 31 * hashCode + (this.getSecondaryPrivateIpAddressCount() == null ? 0 : this.getSecondaryPrivateIpAddressCount().hashCode());
        hashCode = 31 * hashCode + (this.isAssociatePublicIpAddress() == null ? 0 : this.isAssociatePublicIpAddress().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InstanceNetworkInterfaceSpecification)) {
            return false;
        }
        InstanceNetworkInterfaceSpecification other = (InstanceNetworkInterfaceSpecification)obj;
        if (other.getNetworkInterfaceId() == null ^ this.getNetworkInterfaceId() == null) {
            return false;
        }
        if (other.getNetworkInterfaceId() != null && !other.getNetworkInterfaceId().equals(this.getNetworkInterfaceId())) {
            return false;
        }
        if (other.getDeviceIndex() == null ^ this.getDeviceIndex() == null) {
            return false;
        }
        if (other.getDeviceIndex() != null && !other.getDeviceIndex().equals(this.getDeviceIndex())) {
            return false;
        }
        if (other.getSubnetId() == null ^ this.getSubnetId() == null) {
            return false;
        }
        if (other.getSubnetId() != null && !other.getSubnetId().equals(this.getSubnetId())) {
            return false;
        }
        if (other.getDescription() == null ^ this.getDescription() == null) {
            return false;
        }
        if (other.getDescription() != null && !other.getDescription().equals(this.getDescription())) {
            return false;
        }
        if (other.getPrivateIpAddress() == null ^ this.getPrivateIpAddress() == null) {
            return false;
        }
        if (other.getPrivateIpAddress() != null && !other.getPrivateIpAddress().equals(this.getPrivateIpAddress())) {
            return false;
        }
        if (other.getGroups() == null ^ this.getGroups() == null) {
            return false;
        }
        if (other.getGroups() != null && !other.getGroups().equals(this.getGroups())) {
            return false;
        }
        if (other.isDeleteOnTermination() == null ^ this.isDeleteOnTermination() == null) {
            return false;
        }
        if (other.isDeleteOnTermination() != null && !other.isDeleteOnTermination().equals(this.isDeleteOnTermination())) {
            return false;
        }
        if (other.getPrivateIpAddresses() == null ^ this.getPrivateIpAddresses() == null) {
            return false;
        }
        if (other.getPrivateIpAddresses() != null && !other.getPrivateIpAddresses().equals(this.getPrivateIpAddresses())) {
            return false;
        }
        if (other.getSecondaryPrivateIpAddressCount() == null ^ this.getSecondaryPrivateIpAddressCount() == null) {
            return false;
        }
        if (other.getSecondaryPrivateIpAddressCount() != null && !other.getSecondaryPrivateIpAddressCount().equals(this.getSecondaryPrivateIpAddressCount())) {
            return false;
        }
        if (other.isAssociatePublicIpAddress() == null ^ this.isAssociatePublicIpAddress() == null) {
            return false;
        }
        return other.isAssociatePublicIpAddress() == null || other.isAssociatePublicIpAddress().equals(this.isAssociatePublicIpAddress());
    }
}

