/*
 * Decompiled with CFR 0.152.
 */
package org.apache.airavata.service.profile.commons.utils;

import java.net.URI;
import org.apache.airavata.common.exception.ApplicationSettingsException;
import org.apache.airavata.common.utils.ServerSettings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Utils {
    private static final Logger logger = LoggerFactory.getLogger(Utils.class);

    public static String getJDBCURL() {
        try {
            return ServerSettings.getSetting((String)"profile.service.jdbc.url");
        }
        catch (ApplicationSettingsException e) {
            logger.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public static String getHost() {
        try {
            String jdbcURL = Utils.getJDBCURL();
            String cleanURI = jdbcURL.substring(5);
            URI uri = URI.create(cleanURI);
            return uri.getHost();
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public static int getPort() {
        try {
            String jdbcURL = Utils.getJDBCURL();
            String cleanURI = jdbcURL.substring(5);
            URI uri = URI.create(cleanURI);
            return uri.getPort();
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            return -1;
        }
    }

    public static int getJPACacheSize() {
        try {
            String cache = ServerSettings.getSetting((String)"profile.service.jpa.cache.size", (String)"5000");
            return Integer.parseInt(cache);
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            return -1;
        }
    }

    public static String isCachingEnabled() {
        try {
            return ServerSettings.getSetting((String)"profile.service.cache.enable", (String)"true");
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            return "true";
        }
    }

    public static String getDBType() {
        try {
            String jdbcURL = Utils.getJDBCURL();
            String cleanURI = jdbcURL.substring(5);
            URI uri = URI.create(cleanURI);
            return uri.getScheme();
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public static boolean isDerbyStartEnabled() {
        try {
            String s = ServerSettings.getSetting((String)"profile.service.start.derby.server.mode");
            if ("true".equals(s)) {
                return true;
            }
        }
        catch (ApplicationSettingsException e) {
            logger.error(e.getMessage(), (Throwable)e);
            return false;
        }
        return false;
    }

    public static String getJDBCUser() {
        try {
            return ServerSettings.getSetting((String)"profile.service.jdbc.user");
        }
        catch (ApplicationSettingsException e) {
            logger.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public static String getValidationQuery() {
        try {
            return ServerSettings.getSetting((String)"profile.service.validationQuery");
        }
        catch (ApplicationSettingsException e) {
            logger.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public static String getJDBCPassword() {
        try {
            return ServerSettings.getSetting((String)"profile.service.jdbc.password");
        }
        catch (ApplicationSettingsException e) {
            logger.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public static String getJDBCDriver() {
        try {
            return ServerSettings.getSetting((String)"profile.service.jdbc.driver");
        }
        catch (ApplicationSettingsException e) {
            logger.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }
}

