/*
 * Decompiled with CFR 0.152.
 */
package org.compass.core.converter.mapping.xsem;

import java.io.Reader;
import java.lang.reflect.Array;
import java.util.Iterator;
import org.compass.core.Property;
import org.compass.core.Resource;
import org.compass.core.ResourceFactory;
import org.compass.core.converter.ConversionException;
import org.compass.core.converter.mapping.ResourceMappingConverter;
import org.compass.core.converter.mapping.xsem.XmlContentMappingConverter;
import org.compass.core.converter.mapping.xsem.XmlConverterUtils;
import org.compass.core.mapping.Mapping;
import org.compass.core.mapping.ResourceMapping;
import org.compass.core.mapping.xsem.XmlContentMapping;
import org.compass.core.mapping.xsem.XmlObjectMapping;
import org.compass.core.marshall.MarshallingContext;
import org.compass.core.spi.InternalResource;
import org.compass.core.spi.MultiResource;
import org.compass.core.xml.RawXmlObject;
import org.compass.core.xml.XmlObject;

public class XmlObjectMappingConverter
implements ResourceMappingConverter {
    public boolean marshall(Resource resource, Object root, Mapping mapping, MarshallingContext context) throws ConversionException {
        if (root == null && !context.handleNulls()) {
            return false;
        }
        XmlObjectMapping xmlObjectMapping = (XmlObjectMapping)mapping;
        XmlObject rootXmlObject = (XmlObject)root;
        rootXmlObject = this.getActualXmlObject(rootXmlObject, xmlObjectMapping, context, resource);
        if (xmlObjectMapping.getXPath() != null) {
            XmlObject[] xmlObjects = XmlConverterUtils.select(rootXmlObject, xmlObjectMapping);
            if (xmlObjects == null || xmlObjects.length == 0) {
                throw new ConversionException("xpath [" + xmlObjectMapping.getXPath() + "] returned no value for alias [" + xmlObjectMapping.getAlias() + "]");
            }
            boolean store = false;
            MultiResource multiResource = (MultiResource)resource;
            multiResource.clear();
            for (XmlObject xmlObject : xmlObjects) {
                multiResource.addResource();
                Iterator it = xmlObjectMapping.mappingsIt();
                while (it.hasNext()) {
                    Mapping m = (Mapping)it.next();
                    InternalResource resource1 = (InternalResource)multiResource.currentResource();
                    store |= m.getConverter().marshall(resource1, xmlObject, m, context);
                    resource1.addUID();
                }
            }
            return store;
        }
        boolean store = false;
        Iterator it = xmlObjectMapping.mappingsIt();
        while (it.hasNext()) {
            Mapping m = (Mapping)it.next();
            store |= m.getConverter().marshall(resource, rootXmlObject, m, context);
        }
        ((InternalResource)resource).addUID();
        return store;
    }

    public Object unmarshall(Resource resource, Mapping mapping, MarshallingContext context) throws ConversionException {
        XmlObjectMapping xmlObjectMapping = (XmlObjectMapping)mapping;
        if (xmlObjectMapping.getXmlContentMapping() == null) {
            return null;
        }
        XmlContentMapping xmlContentMapping = xmlObjectMapping.getXmlContentMapping();
        return xmlContentMapping.getConverter().unmarshall(resource, xmlContentMapping, context);
    }

    public boolean marshallIds(Resource idResource, Object id, ResourceMapping resourceMapping, MarshallingContext context) throws ConversionException {
        ResourceFactory resourceFactory = context.getResourceFactory();
        XmlObjectMapping xmlObjectMapping = (XmlObjectMapping)resourceMapping;
        Mapping[] ids = resourceMapping.getIdMappings();
        if (id instanceof XmlObject) {
            XmlObject rootXmlObject = this.getActualXmlObject((XmlObject)id, xmlObjectMapping, context, idResource);
            if (xmlObjectMapping.getXPath() != null) {
                XmlObject[] xmlObjects = XmlConverterUtils.select(rootXmlObject, xmlObjectMapping);
                if (xmlObjects == null || xmlObjects.length == 0) {
                    throw new ConversionException("xpath [" + xmlObjectMapping.getXPath() + "] returned no value for alias [" + xmlObjectMapping.getAlias() + "]");
                }
                MultiResource multiResource = (MultiResource)idResource;
                multiResource.clear();
                for (XmlObject xmlObject : xmlObjects) {
                    multiResource.addResource();
                    for (Mapping id1 : ids) {
                        id1.getConverter().marshall(multiResource.currentResource(), xmlObject, id1, context);
                    }
                }
            } else {
                for (Mapping id1 : ids) {
                    id1.getConverter().marshall(idResource, rootXmlObject, id1, context);
                }
            }
        } else if (id instanceof Resource) {
            for (Mapping id1 : ids) {
                Resource rId = (Resource)id;
                idResource.addProperty(rId.getProperty(id1.getPath().getPath()));
            }
        } else if (id instanceof Object[]) {
            if (Array.getLength(id) != ids.length) {
                throw new ConversionException("Trying to load resource with [" + Array.getLength(id) + "] while has ids mappings of [" + ids.length + "]");
            }
            if (Property.class.isAssignableFrom(id.getClass().getComponentType())) {
                for (int i = 0; i < ids.length; ++i) {
                    idResource.addProperty((Property)Array.get(id, i));
                }
            } else {
                for (int i = 0; i < ids.length; ++i) {
                    idResource.addProperty(resourceFactory.createProperty(ids[i].getPath().getPath(), Array.get(id, i).toString(), Property.Store.YES, Property.Index.UN_TOKENIZED));
                }
            }
        } else {
            if (ids.length != 1) {
                throw new ConversionException("Trying to load resource which has more than one id mappings with only one id value");
            }
            if (id instanceof Property) {
                idResource.addProperty((Property)id);
            } else {
                idResource.addProperty(resourceFactory.createProperty(ids[0].getPath().getPath(), id.toString(), Property.Store.YES, Property.Index.UN_TOKENIZED));
            }
        }
        ((InternalResource)idResource).addUID();
        return true;
    }

    public Object[] unmarshallIds(Object id, ResourceMapping resourceMapping, MarshallingContext context) throws ConversionException {
        throw new ConversionException("Not supported, please use xml-content mapping");
    }

    private XmlObject getActualXmlObject(XmlObject rootXmlObject, XmlObjectMapping xmlObjectMapping, MarshallingContext context, Resource resource) {
        if (rootXmlObject instanceof RawXmlObject) {
            Reader xml = ((RawXmlObject)rootXmlObject).getXml();
            XmlContentMapping xmlContentMapping = xmlObjectMapping.getXmlContentMapping();
            XmlContentMappingConverter xmlContentMappingConverter = xmlContentMapping != null ? (XmlContentMappingConverter)xmlContentMapping.getConverter() : (XmlContentMappingConverter)context.getConverterLookup().lookupConverter("xmlContentMapping");
            rootXmlObject = xmlContentMappingConverter.getXmlContentConverter().fromXml(resource.getAlias(), xml);
        }
        return rootXmlObject;
    }
}

