/*
 * Decompiled with CFR 0.152.
 */
package org.compass.core.converter.mapping.osem;

import java.lang.reflect.Array;
import org.compass.core.Resource;
import org.compass.core.accessor.Getter;
import org.compass.core.converter.mapping.osem.AbstractCollectionMappingConverter;
import org.compass.core.mapping.Mapping;
import org.compass.core.mapping.osem.AbstractCollectionMapping;
import org.compass.core.marshall.MarshallingContext;

public class ArrayMappingConverter
extends AbstractCollectionMappingConverter {
    protected int marshallIterateData(Object root, AbstractCollectionMapping colMapping, Resource resource, MarshallingContext context) {
        Object current = context.getAttribute("current");
        int count = 0;
        int size = Array.getLength(root);
        Mapping elementMapping = colMapping.getElementMapping();
        for (int i = 0; i < size; ++i) {
            Object value = Array.get(root, i);
            if (value == null) continue;
            context.setAttribute("current", current);
            boolean stored = elementMapping.getConverter().marshall(resource, value, elementMapping, context);
            if (!stored) continue;
            ++count;
        }
        return count;
    }

    protected AbstractCollectionMapping.CollectionType getRuntimeCollectionType(Object root) {
        throw new IllegalStateException("Should not be called, internal compass error");
    }

    protected Object createColObject(Getter getter, AbstractCollectionMapping.CollectionType collectionType, int size) {
        return Array.newInstance(getter.getReturnType().getComponentType(), size);
    }

    protected void addValue(Object col, int index, Object value) {
        Array.set(col, index, value);
    }
}

