/*
 * Decompiled with CFR 0.152.
 */
package org.compass.core.converter.mapping;

import java.io.Reader;
import java.util.HashMap;
import org.compass.core.Property;
import org.compass.core.Resource;
import org.compass.core.converter.ConversionException;
import org.compass.core.engine.SearchEngineException;

public class CollectionResourceWrapper
implements Resource {
    private Resource resource;
    private HashMap propertiesMap = new HashMap();

    public CollectionResourceWrapper(Resource resource) {
        this.resource = resource;
    }

    public String getValue(String name) {
        return this.computeProperty(name).getStringValue();
    }

    public Object getObject(String name) {
        return this.computeProperty(name).getObjectValue();
    }

    public String[] getValues(String name) {
        return this.resource.getValues(name);
    }

    public String getAlias() {
        return this.resource.getAlias();
    }

    public String getId() {
        throw new ConversionException("should not be called");
    }

    public String getUID() {
        throw new ConversionException("should not be called");
    }

    public String[] getIds() {
        throw new ConversionException("should not be called");
    }

    public Property getIdProperty() {
        throw new ConversionException("should not be called");
    }

    public Property[] getIdProperties() {
        throw new ConversionException("should not be called");
    }

    public Resource addProperty(String name, Object value) throws SearchEngineException {
        throw new ConversionException("should not be called");
    }

    public Resource addProperty(String name, Reader value) throws SearchEngineException {
        throw new ConversionException("should not be called");
    }

    public Resource addProperty(Property property) {
        throw new ConversionException("should not be called");
    }

    public Resource removeProperty(String name) {
        throw new ConversionException("should not be called");
    }

    public Resource removeProperties(String name) {
        throw new ConversionException("should not be called");
    }

    public Resource setProperty(String name, Object value) throws SearchEngineException {
        throw new ConversionException("should not be called");
    }

    public Resource setProperty(String name, Reader value) throws SearchEngineException {
        throw new ConversionException("should not be called");
    }

    public Resource setProperty(Property property) {
        throw new ConversionException("should not be called");
    }

    public Property getProperty(String name) {
        return this.computeProperty(name);
    }

    private Property computeProperty(String name) {
        PropertiesWrapper wrapper = (PropertiesWrapper)this.propertiesMap.get(name);
        if (wrapper == null) {
            wrapper = new PropertiesWrapper();
            wrapper.name = name;
            wrapper.properties = this.getProperties(name);
            this.propertiesMap.put(name, wrapper);
        }
        if (wrapper.properties.length == 0) {
            return null;
        }
        if (wrapper.counter >= wrapper.properties.length) {
            return null;
        }
        return wrapper.properties[wrapper.counter++];
    }

    public void rollbackGetProperty(String name) {
        PropertiesWrapper wrapper = (PropertiesWrapper)this.propertiesMap.get(name);
        if (wrapper == null) {
            return;
        }
        if (wrapper.properties.length == 0) {
            return;
        }
        --wrapper.counter;
    }

    public Property[] getProperties(String name) {
        return this.resource.getProperties(name);
    }

    public Object[] getObjects(String name) {
        return this.resource.getObjects(name);
    }

    public Property[] getProperties() {
        return null;
    }

    public float getBoost() {
        return this.resource.getBoost();
    }

    public Resource setBoost(float boost) {
        this.resource.setBoost(boost);
        return this;
    }

    public void copy(Resource resource) {
        this.resource.copy(resource);
    }

    public class PropertiesWrapper {
        public String name;
        public Property[] properties;
        public int counter;

        public int hashCode() {
            return this.name.hashCode();
        }

        public boolean equals(Object object) {
            PropertiesWrapper copy = (PropertiesWrapper)object;
            return this.name.equals(copy.name);
        }
    }
}

