/*
 * Decompiled with CFR 0.152.
 */
package org.compass.core.config.process;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.compass.core.config.CompassSettings;
import org.compass.core.config.process.MappingProcessor;
import org.compass.core.config.process.MappingProcessorUtils;
import org.compass.core.converter.ConverterLookup;
import org.compass.core.engine.naming.PropertyNamingStrategy;
import org.compass.core.engine.naming.StaticPropertyPath;
import org.compass.core.mapping.CompassMapping;
import org.compass.core.mapping.Mapping;
import org.compass.core.mapping.MappingException;
import org.compass.core.mapping.ResourcePropertyMapping;
import org.compass.core.mapping.osem.AbstractCollectionMapping;
import org.compass.core.mapping.osem.ClassIdPropertyMapping;
import org.compass.core.mapping.osem.ClassMapping;
import org.compass.core.mapping.osem.ClassPropertyMapping;
import org.compass.core.mapping.osem.ClassPropertyMetaDataMapping;
import org.compass.core.mapping.osem.ComponentMapping;
import org.compass.core.mapping.osem.ConstantMetaDataMapping;
import org.compass.core.mapping.osem.DynamicMetaDataMapping;
import org.compass.core.mapping.osem.IdComponentMapping;
import org.compass.core.mapping.osem.OsemMappingIterator;
import org.compass.core.mapping.osem.ParentMapping;
import org.compass.core.mapping.osem.PlainCascadeMapping;
import org.compass.core.mapping.osem.ReferenceMapping;

public class LateBindingOsemMappingProcessor
implements MappingProcessor {
    private CompassMapping compassMapping;
    private PropertyNamingStrategy namingStrategy;
    private ConverterLookup converterLookup;
    private CompassSettings settings;
    private List<ComponentMapping> chainedComponents = new ArrayList<ComponentMapping>();
    private ClassPropertyMapping.ManagedId managedId = null;

    public CompassMapping process(CompassMapping compassMapping, PropertyNamingStrategy namingStrategy, ConverterLookup converterLookup, CompassSettings settings) throws MappingException {
        this.compassMapping = compassMapping;
        this.namingStrategy = namingStrategy;
        this.converterLookup = converterLookup;
        this.settings = settings;
        compassMapping.setPath(namingStrategy.getRootPath());
        Iterator it = compassMapping.mappingsIt();
        while (it.hasNext()) {
            Mapping m = (Mapping)it.next();
            if (!(m instanceof ClassMapping)) continue;
            this.clearRootClassMappingState();
            ClassMapping classMapping = (ClassMapping)m;
            if (classMapping.isSupportUnmarshall()) {
                this.secondPass(classMapping, compassMapping);
                continue;
            }
            this.secondPassNoUnmarshalling(classMapping);
        }
        return compassMapping;
    }

    private void secondPassNoUnmarshalling(ClassMapping classMapping) {
        classMapping.setPath(this.namingStrategy.buildPath(this.compassMapping.getPath(), classMapping.getAlias()));
        classMapping.setClassPath(this.namingStrategy.buildPath(classMapping.getPath(), "class").hintStatic());
        OsemMappingIterator.iterateMappings(new NoUnmarshallingCallback(), classMapping, false);
    }

    private void secondPass(ClassMapping classMapping, CompassMapping fatherMapping) {
        classMapping.setPath(this.namingStrategy.buildPath(fatherMapping.getPath(), classMapping.getAlias()));
        this.secondPass(classMapping, false);
    }

    private void secondPass(ClassMapping classMapping, boolean onlyProperties) {
        classMapping.setClassPath(this.namingStrategy.buildPath(classMapping.getPath(), "class").hintStatic());
        ArrayList<Mapping> innerMappingsCopy = new ArrayList<Mapping>();
        Iterator it = classMapping.mappingsIt();
        while (it.hasNext()) {
            Mapping m = (Mapping)it.next();
            Mapping copyMapping = m.copy();
            boolean removeMapping = false;
            if (m instanceof ClassPropertyMapping) {
                removeMapping = this.secondPass((ClassPropertyMapping)copyMapping, (Mapping)classMapping);
            } else if (m instanceof IdComponentMapping) {
                removeMapping = this.secondPass((IdComponentMapping)copyMapping, (Mapping)classMapping);
            } else if (!onlyProperties) {
                if (copyMapping instanceof ComponentMapping) {
                    removeMapping = this.secondPass((ComponentMapping)copyMapping, (Mapping)classMapping);
                } else if (copyMapping instanceof ReferenceMapping) {
                    removeMapping = this.secondPass((ReferenceMapping)copyMapping, (Mapping)classMapping);
                } else if (copyMapping instanceof ConstantMetaDataMapping) {
                    removeMapping = this.secondPass((ConstantMetaDataMapping)copyMapping);
                } else if (!(copyMapping instanceof ParentMapping)) {
                    if (copyMapping instanceof AbstractCollectionMapping) {
                        removeMapping = this.secondPass((AbstractCollectionMapping)copyMapping, (Mapping)classMapping);
                    } else if (copyMapping instanceof DynamicMetaDataMapping) {
                        // empty if block
                    }
                }
            }
            if (removeMapping) continue;
            innerMappingsCopy.add(copyMapping);
        }
        classMapping.clearMappings();
        it = innerMappingsCopy.iterator();
        while (it.hasNext()) {
            classMapping.addMapping((Mapping)it.next());
        }
    }

    private boolean secondPass(AbstractCollectionMapping collectionMapping, Mapping fatherMapping) {
        Mapping elementMapping = collectionMapping.getElementMapping();
        Mapping elementMappingCopy = elementMapping.copy();
        boolean removeMapping = false;
        if (elementMappingCopy instanceof ClassPropertyMapping) {
            removeMapping = this.secondPass((ClassPropertyMapping)elementMappingCopy, fatherMapping);
        } else if (elementMappingCopy instanceof ComponentMapping) {
            removeMapping = this.secondPass((ComponentMapping)elementMappingCopy, fatherMapping);
        } else if (elementMappingCopy instanceof ReferenceMapping) {
            removeMapping = this.secondPass((ReferenceMapping)elementMappingCopy, fatherMapping);
        }
        collectionMapping.setElementMapping(elementMappingCopy);
        collectionMapping.setPath(this.namingStrategy.buildPath(fatherMapping.getPath(), collectionMapping.getName()));
        collectionMapping.setCollectionTypePath(this.namingStrategy.buildPath(collectionMapping.getPath(), "colType").hintStatic());
        collectionMapping.setColSizePath(this.namingStrategy.buildPath(collectionMapping.getPath(), "colSize").hintStatic());
        return removeMapping;
    }

    private boolean secondPass(ReferenceMapping referenceMapping, Mapping fatherMapping) {
        this.secondPassJustReference(referenceMapping, fatherMapping);
        if (referenceMapping.getRefCompAlias() != null) {
            ClassMapping pointerClass = (ClassMapping)this.compassMapping.getMappingByAlias(referenceMapping.getRefCompAlias());
            if (pointerClass == null) {
                throw new MappingException("Failed to locate mapping for reference ref-comp-alias [" + referenceMapping.getRefCompAlias() + "]");
            }
            ClassMapping refClass = (ClassMapping)pointerClass.copy();
            refClass.setPath(this.namingStrategy.buildPath(referenceMapping.getPath(), referenceMapping.getRefCompAlias()));
            this.managedId = ClassPropertyMapping.ManagedId.FALSE;
            this.secondPass(refClass, false);
            this.managedId = null;
            refClass.setRoot(false);
            referenceMapping.setRefCompMapping(refClass);
        }
        return false;
    }

    private void secondPassJustReference(ReferenceMapping referenceMapping, Mapping fatherMapping) {
        referenceMapping.setPath(this.namingStrategy.buildPath(fatherMapping.getPath(), referenceMapping.getName()));
        ClassMapping[] refMappings = referenceMapping.getRefClassMappings();
        ClassMapping[] copyRefClassMappings = new ClassMapping[refMappings.length];
        for (int i = 0; i < refMappings.length; ++i) {
            List<Mapping> ids = refMappings[i].findIdMappings();
            ClassMapping refClass = (ClassMapping)refMappings[i].shallowCopy();
            for (Mapping id : ids) {
                refClass.addMapping(id.copy());
            }
            refClass.setPath(referenceMapping.getPath());
            this.secondPass(refClass, true);
            for (ClassIdPropertyMapping mapping : refClass.findClassPropertyIdMappings()) {
                mapping.clearMappings();
                MappingProcessorUtils.addInternalId(this.settings, this.converterLookup, mapping, true);
            }
            refClass.postProcess();
            copyRefClassMappings[i] = refClass;
        }
        referenceMapping.setRefClassMappings(copyRefClassMappings);
    }

    private boolean secondPass(ComponentMapping compMapping, Mapping fatherMapping) {
        int numberOfComponentsWithTheSameAlias = 0;
        for (ComponentMapping tempComponentMapping : this.chainedComponents) {
            if (!compMapping.hasAtLeastOneRefAlias(tempComponentMapping.getRefAliases())) continue;
            ++numberOfComponentsWithTheSameAlias;
        }
        if (numberOfComponentsWithTheSameAlias >= compMapping.getMaxDepth()) {
            return true;
        }
        this.chainedComponents.add(compMapping);
        compMapping.setPath(this.namingStrategy.buildPath(fatherMapping.getPath(), compMapping.getName()));
        ClassMapping[] refClassMappings = compMapping.getRefClassMappings();
        ClassMapping[] copyRefClassMappings = new ClassMapping[refClassMappings.length];
        for (int i = 0; i < refClassMappings.length; ++i) {
            ClassMapping refClassMapping = (ClassMapping)refClassMappings[i].copy();
            refClassMapping.setPath(compMapping.getPath());
            this.secondPass(refClassMapping, false);
            refClassMapping.setRoot(false);
            copyRefClassMappings[i] = refClassMapping;
        }
        compMapping.setRefClassMappings(copyRefClassMappings);
        this.chainedComponents.remove(compMapping);
        return false;
    }

    private boolean secondPass(ClassPropertyMapping classPropertyMapping, Mapping fatherMapping) {
        classPropertyMapping.setPath(this.namingStrategy.buildPath(fatherMapping.getPath(), classPropertyMapping.getName()));
        if (this.managedId != null) {
            classPropertyMapping.setManagedId(this.managedId);
        }
        ArrayList<ClassPropertyMetaDataMapping> innerMappingsCopy = new ArrayList<ClassPropertyMetaDataMapping>();
        Iterator it = classPropertyMapping.mappingsIt();
        while (it.hasNext()) {
            Mapping m = (Mapping)it.next();
            ClassPropertyMetaDataMapping metaDataMappingCopy = (ClassPropertyMetaDataMapping)m.copy();
            MappingProcessorUtils.process(metaDataMappingCopy, classPropertyMapping, this.converterLookup);
            innerMappingsCopy.add(metaDataMappingCopy);
        }
        classPropertyMapping.clearMappings();
        it = innerMappingsCopy.iterator();
        while (it.hasNext()) {
            classPropertyMapping.addMapping((Mapping)it.next());
        }
        return false;
    }

    private boolean secondPass(ConstantMetaDataMapping constantMapping) {
        constantMapping.setPath(new StaticPropertyPath(constantMapping.getName()));
        return false;
    }

    private void clearRootClassMappingState() {
        this.chainedComponents.clear();
    }

    private class NoUnmarshallingCallback
    implements OsemMappingIterator.ClassMappingCallback {
        private ClassPropertyMapping classPropertyMapping;

        public boolean onBeginClassMapping(ClassMapping classMapping) {
            return true;
        }

        public void onEndClassMapping(ClassMapping classMapping) {
        }

        public boolean onBeginMultipleMapping(ClassMapping classMapping, Mapping mapping) {
            return true;
        }

        public void onEndMultiplMapping(ClassMapping classMapping, Mapping mapping) {
        }

        public void onBeginCollectionMapping(AbstractCollectionMapping collectionMapping) {
        }

        public void onEndCollectionMapping(AbstractCollectionMapping collectionMapping) {
        }

        public void onClassPropertyMapping(ClassMapping classMapping, ClassPropertyMapping classPropertyMapping) {
            this.classPropertyMapping = classPropertyMapping;
            classPropertyMapping.setPath(LateBindingOsemMappingProcessor.this.namingStrategy.buildPath(classMapping.getPath(), classPropertyMapping.getName()));
        }

        public void onParentMapping(ClassMapping classMapping, ParentMapping parentMapping) {
        }

        public void onCascadeMapping(ClassMapping classMapping, PlainCascadeMapping cascadeMapping) {
        }

        public void onComponentMapping(ClassMapping classMapping, ComponentMapping componentMapping) {
            ClassMapping[] refClassMappings = componentMapping.getRefClassMappings();
            ClassMapping[] copyRefClassMappings = new ClassMapping[refClassMappings.length];
            for (int i = 0; i < refClassMappings.length; ++i) {
                ClassMapping refClassMapping = (ClassMapping)refClassMappings[i].shallowCopy();
                refClassMapping.replaceMappings(refClassMappings[i]);
                refClassMapping.setPath(componentMapping.getPath());
                refClassMapping.setRoot(false);
                refClassMapping.setSupportUnmarshall(classMapping.isSupportUnmarshall());
                copyRefClassMappings[i] = refClassMapping;
            }
            componentMapping.setRefClassMappings(copyRefClassMappings);
        }

        public void onReferenceMapping(ClassMapping classMapping, ReferenceMapping referenceMapping) {
            LateBindingOsemMappingProcessor.this.secondPassJustReference(referenceMapping, classMapping);
        }

        public void onConstantMetaDataMappaing(ClassMapping classMapping, ConstantMetaDataMapping constantMetaDataMapping) {
            constantMetaDataMapping.setPath(new StaticPropertyPath(constantMetaDataMapping.getName()));
        }

        public void onDynamicMetaDataMapping(ClassMapping classMapping, DynamicMetaDataMapping dynamicMetaDataMapping) {
        }

        public void onClassPropertyMetaDataMapping(ClassPropertyMetaDataMapping classPropertyMetaDataMapping) {
            MappingProcessorUtils.process(classPropertyMetaDataMapping, this.classPropertyMapping, LateBindingOsemMappingProcessor.this.converterLookup);
        }

        public void onResourcePropertyMapping(ResourcePropertyMapping resourcePropertyMapping) {
        }
    }
}

