/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.store.jdbc.lock;

import java.io.IOException;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import org.apache.lucene.store.Lock;
import org.apache.lucene.store.jdbc.JdbcDirectory;
import org.apache.lucene.store.jdbc.JdbcStoreException;
import org.apache.lucene.store.jdbc.lock.JdbcLock;
import org.apache.lucene.store.jdbc.support.JdbcTemplate;

public class SelectForUpdateLock
extends Lock
implements JdbcLock {
    private JdbcDirectory jdbcDirectory;
    private String name;

    public void configure(JdbcDirectory jdbcDirectory, String name) throws IOException {
        if (!jdbcDirectory.getDialect().supportsForUpdate()) {
            throw new JdbcStoreException("Database dialect [" + jdbcDirectory.getDialect() + "] does not support select for update");
        }
        this.jdbcDirectory = jdbcDirectory;
        this.name = name;
    }

    public void initializeDatabase(JdbcDirectory jdbcDirectory) throws IOException {
        jdbcDirectory.getJdbcTemplate().executeUpdate(jdbcDirectory.getTable().sqlInsert(), new JdbcTemplate.PrepateStatementAwareCallback(){

            public void fillPrepareStatement(PreparedStatement ps) throws Exception {
                ps.setFetchSize(1);
                ps.setString(1, "write.lock");
                ps.setNull(2, 2004);
                ps.setLong(3, 0L);
                ps.setBoolean(4, false);
            }
        });
    }

    public boolean obtain() {
        try {
            return (Boolean)this.jdbcDirectory.getJdbcTemplate().executeSelect(this.jdbcDirectory.getTable().sqlSelectNameForUpdateNoWait(), new JdbcTemplate.ExecuteSelectCallback(){

                public void fillPrepareStatement(PreparedStatement ps) throws Exception {
                    ps.setFetchSize(1);
                    ps.setString(1, SelectForUpdateLock.this.name);
                }

                public Object execute(ResultSet rs) throws Exception {
                    if (!rs.next()) {
                        System.err.println("Should not happen, the lock [" + SelectForUpdateLock.this.name + "] should already exists");
                        return Boolean.FALSE;
                    }
                    return Boolean.TRUE;
                }
            });
        }
        catch (Exception e) {
            return false;
        }
    }

    public void release() {
    }

    public boolean isLocked() {
        throw new IllegalStateException("SelectForUpdate lock does not support is locked");
    }

    public String toString() {
        return "SelectForUpdateLock[" + this.name + "/" + this.jdbcDirectory.getTable() + "]";
    }
}

