/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.jaxp;

import java.io.IOException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.sax.SAXSource;
import net.sf.saxon.Configuration;
import net.sf.saxon.event.ContentHandlerProxy;
import net.sf.saxon.jaxp.TransformerImpl;
import org.xml.sax.ContentHandler;
import org.xml.sax.DTDHandler;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.XMLFilter;
import org.xml.sax.XMLReader;
import org.xml.sax.ext.LexicalHandler;

public class FilterImpl
implements XMLFilter {
    private TransformerImpl transformer;
    private XMLReader parser;
    private ContentHandler contentHandler;
    private LexicalHandler lexicalHandler;

    protected FilterImpl(TransformerImpl transformer) {
        this.transformer = transformer;
    }

    public void setParent(XMLReader parent) {
        this.parser = parent;
    }

    public XMLReader getParent() {
        return this.parser;
    }

    public boolean getFeature(String name) throws SAXNotRecognizedException, SAXNotSupportedException {
        return this.parser.getFeature(name);
    }

    public void setFeature(String name, boolean value) throws SAXNotRecognizedException, SAXNotSupportedException {
        this.parser.setFeature(name, value);
    }

    public Object getProperty(String name) throws SAXNotRecognizedException, SAXNotSupportedException {
        if (name.equals("http://xml.org/sax/properties/lexical-handler")) {
            return this.lexicalHandler;
        }
        throw new SAXNotRecognizedException(name);
    }

    public void setProperty(String name, Object value) throws SAXNotRecognizedException, SAXNotSupportedException {
        if (name.equals("http://xml.org/sax/properties/lexical-handler")) {
            if (!(value instanceof LexicalHandler)) {
                throw new SAXNotSupportedException("Lexical Handler must be instance of org.xml.sax.ext.LexicalHandler");
            }
        } else {
            throw new SAXNotRecognizedException(name);
        }
        this.lexicalHandler = (LexicalHandler)value;
    }

    public void setContentHandler(ContentHandler handler) {
        this.contentHandler = handler;
        if (handler instanceof LexicalHandler && this.lexicalHandler == null) {
            this.lexicalHandler = (LexicalHandler)((Object)handler);
        }
    }

    public ContentHandler getContentHandler() {
        return this.contentHandler;
    }

    public void setEntityResolver(EntityResolver resolver) {
    }

    public EntityResolver getEntityResolver() {
        return null;
    }

    public void setDTDHandler(DTDHandler handler) {
    }

    public DTDHandler getDTDHandler() {
        return null;
    }

    public void setErrorHandler(ErrorHandler handler) {
    }

    public ErrorHandler getErrorHandler() {
        return null;
    }

    public void parse(InputSource input) throws IOException, SAXException {
        if (this.parser == null) {
            try {
                this.parser = Configuration.getPlatform().loadParser();
            }
            catch (Exception err) {
                throw new SAXException(err);
            }
        }
        SAXSource source = new SAXSource();
        source.setInputSource(input);
        source.setXMLReader(this.parser);
        ContentHandlerProxy result = new ContentHandlerProxy();
        result.setPipelineConfiguration(this.transformer.getConfiguration().makePipelineConfiguration());
        result.setUnderlyingContentHandler(this.contentHandler);
        if (this.lexicalHandler != null) {
            result.setLexicalHandler(this.lexicalHandler);
        }
        try {
            result.setOutputProperties(this.transformer.getOutputProperties());
            this.transformer.transform(source, result);
        }
        catch (TransformerException err) {
            Throwable cause = err.getException();
            if (cause != null && cause instanceof SAXException) {
                throw (SAXException)cause;
            }
            if (cause != null && cause instanceof IOException) {
                throw (IOException)cause;
            }
            throw new SAXException(err);
        }
    }

    public void parse(String systemId) throws IOException, SAXException {
        InputSource input = new InputSource(systemId);
        this.parse(input);
    }

    public Transformer getTransformer() {
        return this.transformer;
    }
}

