/*
 * Decompiled with CFR 0.152.
 */
package org.apache.airavata.sharing.registry.server;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.LinkedList;
import java.util.List;
import org.apache.airavata.common.exception.ApplicationSettingsException;
import org.apache.airavata.sharing.registry.db.entities.EntityPK;
import org.apache.airavata.sharing.registry.db.entities.EntityTypePK;
import org.apache.airavata.sharing.registry.db.entities.GroupMembershipPK;
import org.apache.airavata.sharing.registry.db.entities.PermissionTypePK;
import org.apache.airavata.sharing.registry.db.entities.SharingPK;
import org.apache.airavata.sharing.registry.db.entities.UserGroupPK;
import org.apache.airavata.sharing.registry.db.entities.UserPK;
import org.apache.airavata.sharing.registry.db.repositories.DomainRepository;
import org.apache.airavata.sharing.registry.db.repositories.EntityRepository;
import org.apache.airavata.sharing.registry.db.repositories.EntityTypeRepository;
import org.apache.airavata.sharing.registry.db.repositories.GroupMembershipRepository;
import org.apache.airavata.sharing.registry.db.repositories.PermissionTypeRepository;
import org.apache.airavata.sharing.registry.db.repositories.SharingRepository;
import org.apache.airavata.sharing.registry.db.repositories.UserGroupRepository;
import org.apache.airavata.sharing.registry.db.repositories.UserRepository;
import org.apache.airavata.sharing.registry.db.utils.JPAUtils;
import org.apache.airavata.sharing.registry.models.Domain;
import org.apache.airavata.sharing.registry.models.DuplicateEntryException;
import org.apache.airavata.sharing.registry.models.Entity;
import org.apache.airavata.sharing.registry.models.EntityType;
import org.apache.airavata.sharing.registry.models.GroupCardinality;
import org.apache.airavata.sharing.registry.models.GroupChildType;
import org.apache.airavata.sharing.registry.models.GroupMembership;
import org.apache.airavata.sharing.registry.models.GroupType;
import org.apache.airavata.sharing.registry.models.PermissionType;
import org.apache.airavata.sharing.registry.models.SearchCriteria;
import org.apache.airavata.sharing.registry.models.Sharing;
import org.apache.airavata.sharing.registry.models.SharingRegistryException;
import org.apache.airavata.sharing.registry.models.SharingType;
import org.apache.airavata.sharing.registry.models.User;
import org.apache.airavata.sharing.registry.models.UserGroup;
import org.apache.airavata.sharing.registry.service.cpi.SharingRegistryService;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.apache.thrift.TException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SharingRegistryServerHandler
implements SharingRegistryService.Iface {
    private static final Logger logger = LoggerFactory.getLogger(SharingRegistryServerHandler.class);
    public static String OWNER_PERMISSION_NAME = "OWNER";

    public SharingRegistryServerHandler() throws ApplicationSettingsException, TException {
        JPAUtils.initializeDB();
    }

    public String createDomain(Domain domain) throws SharingRegistryException, DuplicateEntryException, TException {
        try {
            if (new DomainRepository().get(domain.domainId) != null) {
                throw new DuplicateEntryException("There exist domain with given domain id");
            }
            domain.setCreatedTime(System.currentTimeMillis());
            domain.setUpdatedTime(System.currentTimeMillis());
            new DomainRepository().create(domain);
            PermissionType permissionType = new PermissionType();
            permissionType.setPermissionTypeId(domain.domainId + ":" + OWNER_PERMISSION_NAME);
            permissionType.setDomainId(domain.domainId);
            permissionType.setName(OWNER_PERMISSION_NAME);
            permissionType.setDescription("GLOBAL permission to " + domain.domainId);
            permissionType.setCreatedTime(System.currentTimeMillis());
            permissionType.setUpdatedTime(System.currentTimeMillis());
            new PermissionTypeRepository().create(permissionType);
            return domain.domainId;
        }
        catch (Throwable ex) {
            logger.error(ex.getMessage(), ex);
            throw new SharingRegistryException().setMessage(ex.getMessage() + " Stack trace:" + ExceptionUtils.getStackTrace((Throwable)ex));
        }
    }

    public boolean updateDomain(Domain domain) throws SharingRegistryException, TException {
        try {
            Domain oldDomain = (Domain)new DomainRepository().get(domain.domainId);
            domain.setCreatedTime(oldDomain.createdTime);
            domain.setUpdatedTime(System.currentTimeMillis());
            domain = this.getUpdatedObject(oldDomain, domain);
            new DomainRepository().update(domain);
            return true;
        }
        catch (Throwable ex) {
            logger.error(ex.getMessage(), ex);
            throw new SharingRegistryException().setMessage(ex.getMessage() + " Stack trace:" + ExceptionUtils.getStackTrace((Throwable)ex));
        }
    }

    public boolean isDomainExists(String domainId) throws SharingRegistryException, TException {
        try {
            return new DomainRepository().isExists(domainId);
        }
        catch (Throwable ex) {
            logger.error(ex.getMessage(), ex);
            throw new SharingRegistryException().setMessage(ex.getMessage() + " Stack trace:" + ExceptionUtils.getStackTrace((Throwable)ex));
        }
    }

    public boolean deleteDomain(String domainId) throws SharingRegistryException, TException {
        try {
            new DomainRepository().delete(domainId);
            return true;
        }
        catch (Throwable ex) {
            logger.error(ex.getMessage(), ex);
            throw new SharingRegistryException().setMessage(ex.getMessage() + " Stack trace:" + ExceptionUtils.getStackTrace((Throwable)ex));
        }
    }

    public Domain getDomain(String domainId) throws SharingRegistryException, TException {
        try {
            return (Domain)new DomainRepository().get(domainId);
        }
        catch (Throwable ex) {
            logger.error(ex.getMessage(), ex);
            throw new SharingRegistryException().setMessage(ex.getMessage() + " Stack trace:" + ExceptionUtils.getStackTrace((Throwable)ex));
        }
    }

    public List<Domain> getDomains(int offset, int limit) throws TException {
        try {
            return new DomainRepository().select(new HashMap<String, String>(), offset, limit);
        }
        catch (Throwable ex) {
            logger.error(ex.getMessage(), ex);
            throw new SharingRegistryException().setMessage(ex.getMessage() + " Stack trace:" + ExceptionUtils.getStackTrace((Throwable)ex));
        }
    }

    public String createUser(User user) throws SharingRegistryException, DuplicateEntryException, TException {
        try {
            UserPK userPK = new UserPK();
            userPK.setUserId(user.getUserId());
            userPK.setDomainId(user.domainId);
            if (new UserRepository().get(userPK) != null) {
                throw new DuplicateEntryException("There exist user with given user id");
            }
            user.setCreatedTime(System.currentTimeMillis());
            user.setUpdatedTime(System.currentTimeMillis());
            new UserRepository().create(user);
            UserGroup userGroup = new UserGroup();
            userGroup.setGroupId(user.userId);
            userGroup.setDomainId(user.domainId);
            userGroup.setName(user.userName);
            userGroup.setDescription("user " + user.userName + " group");
            userGroup.setOwnerId(user.userId);
            userGroup.setGroupType(GroupType.USER_LEVEL_GROUP);
            userGroup.setGroupCardinality(GroupCardinality.SINGLE_USER);
            new UserGroupRepository().create(userGroup);
            return user.userId;
        }
        catch (Throwable ex) {
            logger.error(ex.getMessage(), ex);
            throw new SharingRegistryException().setMessage(ex.getMessage() + " Stack trace:" + ExceptionUtils.getStackTrace((Throwable)ex));
        }
    }

    public boolean updatedUser(User user) throws SharingRegistryException, TException {
        try {
            UserPK userPK = new UserPK();
            userPK.setUserId(user.userId);
            userPK.setDomainId(user.domainId);
            User oldUser = (User)new UserRepository().get(userPK);
            user.setCreatedTime(oldUser.createdTime);
            user.setUpdatedTime(System.currentTimeMillis());
            user = this.getUpdatedObject(oldUser, user);
            new UserRepository().update(user);
            UserGroupPK userGroupPK = new UserGroupPK();
            userGroupPK.setGroupId(user.getUserId());
            userGroupPK.setDomainId(user.domainId);
            UserGroup userGroup = (UserGroup)new UserGroupRepository().get(userGroupPK);
            userGroup.setName(user.userName);
            userGroup.setDescription("user " + user.userName + " group");
            this.updateGroup(userGroup);
            return true;
        }
        catch (Throwable ex) {
            logger.error(ex.getMessage(), ex);
            throw new SharingRegistryException().setMessage(ex.getMessage() + " Stack trace:" + ExceptionUtils.getStackTrace((Throwable)ex));
        }
    }

    public boolean isUserExists(String domainId, String userId) throws SharingRegistryException, TException {
        try {
            UserPK userPK = new UserPK();
            userPK.setDomainId(domainId);
            userPK.setUserId(userId);
            return new UserRepository().isExists(userPK);
        }
        catch (Throwable ex) {
            logger.error(ex.getMessage(), ex);
            throw new SharingRegistryException().setMessage(ex.getMessage() + " Stack trace:" + ExceptionUtils.getStackTrace((Throwable)ex));
        }
    }

    public boolean deleteUser(String domainId, String userId) throws SharingRegistryException, TException {
        try {
            UserPK userPK = new UserPK();
            userPK.setUserId(userId);
            userPK.setDomainId(domainId);
            new UserRepository().delete(userPK);
            UserGroupPK userGroupPK = new UserGroupPK();
            userGroupPK.setGroupId(userId);
            userGroupPK.setDomainId(domainId);
            new UserGroupRepository().delete(userGroupPK);
            return true;
        }
        catch (Throwable ex) {
            logger.error(ex.getMessage(), ex);
            throw new SharingRegistryException().setMessage(ex.getMessage() + " Stack trace:" + ExceptionUtils.getStackTrace((Throwable)ex));
        }
    }

    public User getUser(String domainId, String userId) throws SharingRegistryException, TException {
        try {
            UserPK userPK = new UserPK();
            userPK.setUserId(userId);
            userPK.setDomainId(domainId);
            return (User)new UserRepository().get(userPK);
        }
        catch (Throwable ex) {
            logger.error(ex.getMessage(), ex);
            throw new SharingRegistryException().setMessage(ex.getMessage() + " Stack trace:" + ExceptionUtils.getStackTrace((Throwable)ex));
        }
    }

    public List<User> getUsers(String domain, int offset, int limit) throws SharingRegistryException, TException {
        try {
            HashMap<String, String> filters = new HashMap<String, String>();
            filters.put("domainId", domain);
            return new UserRepository().select(filters, offset, limit);
        }
        catch (Throwable ex) {
            logger.error(ex.getMessage(), ex);
            throw new SharingRegistryException().setMessage(ex.getMessage() + " Stack trace:" + ExceptionUtils.getStackTrace((Throwable)ex));
        }
    }

    public String createGroup(UserGroup group) throws SharingRegistryException, TException {
        try {
            UserGroupPK userGroupPK = new UserGroupPK();
            userGroupPK.setGroupId(group.groupId);
            userGroupPK.setDomainId(group.domainId);
            if (new UserGroupRepository().get(userGroupPK) != null) {
                throw new SharingRegistryException("There exist group with given group id");
            }
            group.setGroupCardinality(GroupCardinality.MULTI_USER);
            group.setCreatedTime(System.currentTimeMillis());
            group.setUpdatedTime(System.currentTimeMillis());
            new UserGroupRepository().create(group);
            this.addUsersToGroup(group.domainId, Arrays.asList(group.ownerId), group.groupId);
            return group.groupId;
        }
        catch (Throwable ex) {
            logger.error(ex.getMessage(), ex);
            throw new SharingRegistryException().setMessage(ex.getMessage() + " Stack trace:" + ExceptionUtils.getStackTrace((Throwable)ex));
        }
    }

    public boolean updateGroup(UserGroup group) throws SharingRegistryException, TException {
        try {
            group.setUpdatedTime(System.currentTimeMillis());
            UserGroupPK userGroupPK = new UserGroupPK();
            userGroupPK.setGroupId(group.groupId);
            userGroupPK.setDomainId(group.domainId);
            UserGroup oldGroup = (UserGroup)new UserGroupRepository().get(userGroupPK);
            group.setGroupCardinality(GroupCardinality.MULTI_USER);
            group.setCreatedTime(oldGroup.createdTime);
            group = this.getUpdatedObject(oldGroup, group);
            if (!group.ownerId.equals(oldGroup.ownerId)) {
                throw new SharingRegistryException("Group owner cannot be changed");
            }
            new UserGroupRepository().update(group);
            return true;
        }
        catch (Throwable ex) {
            logger.error(ex.getMessage(), ex);
            throw new SharingRegistryException().setMessage(ex.getMessage() + " Stack trace:" + ExceptionUtils.getStackTrace((Throwable)ex));
        }
    }

    public boolean isGroupExists(String domainId, String groupId) throws SharingRegistryException, TException {
        try {
            UserGroupPK userGroupPK = new UserGroupPK();
            userGroupPK.setDomainId(domainId);
            userGroupPK.setGroupId(groupId);
            return new UserGroupRepository().isExists(userGroupPK);
        }
        catch (Throwable ex) {
            logger.error(ex.getMessage(), ex);
            throw new SharingRegistryException().setMessage(ex.getMessage() + " Stack trace:" + ExceptionUtils.getStackTrace((Throwable)ex));
        }
    }

    public boolean deleteGroup(String domainId, String groupId) throws SharingRegistryException, TException {
        try {
            UserGroupPK userGroupPK = new UserGroupPK();
            userGroupPK.setGroupId(groupId);
            userGroupPK.setDomainId(domainId);
            new UserGroupRepository().delete(userGroupPK);
            return true;
        }
        catch (Throwable ex) {
            logger.error(ex.getMessage(), ex);
            throw new SharingRegistryException().setMessage(ex.getMessage() + " Stack trace:" + ExceptionUtils.getStackTrace((Throwable)ex));
        }
    }

    public UserGroup getGroup(String domainId, String groupId) throws SharingRegistryException, TException {
        try {
            UserGroupPK userGroupPK = new UserGroupPK();
            userGroupPK.setGroupId(groupId);
            userGroupPK.setDomainId(domainId);
            return (UserGroup)new UserGroupRepository().get(userGroupPK);
        }
        catch (Throwable ex) {
            logger.error(ex.getMessage(), ex);
            throw new SharingRegistryException().setMessage(ex.getMessage() + " Stack trace:" + ExceptionUtils.getStackTrace((Throwable)ex));
        }
    }

    public List<UserGroup> getGroups(String domain, int offset, int limit) throws TException {
        try {
            HashMap<String, String> filters = new HashMap<String, String>();
            filters.put("domainId", domain);
            return new UserGroupRepository().select(filters, offset, limit);
        }
        catch (Throwable ex) {
            logger.error(ex.getMessage(), ex);
            throw new SharingRegistryException().setMessage(ex.getMessage() + " Stack trace:" + ExceptionUtils.getStackTrace((Throwable)ex));
        }
    }

    public boolean addUsersToGroup(String domainId, List<String> userIds, String groupId) throws SharingRegistryException, TException {
        try {
            for (int i = 0; i < userIds.size(); ++i) {
                GroupMembership groupMembership = new GroupMembership();
                groupMembership.setParentId(groupId);
                groupMembership.setChildId(userIds.get(i));
                groupMembership.setChildType(GroupChildType.USER);
                groupMembership.setDomainId(domainId);
                groupMembership.setCreatedTime(System.currentTimeMillis());
                groupMembership.setUpdatedTime(System.currentTimeMillis());
                new GroupMembershipRepository().create(groupMembership);
            }
            return true;
        }
        catch (Throwable ex) {
            logger.error(ex.getMessage(), ex);
            throw new SharingRegistryException().setMessage(ex.getMessage() + " Stack trace:" + ExceptionUtils.getStackTrace((Throwable)ex));
        }
    }

    public boolean removeUsersFromGroup(String domainId, List<String> userIds, String groupId) throws SharingRegistryException, TException {
        try {
            for (int i = 0; i < userIds.size(); ++i) {
                GroupMembershipPK groupMembershipPK = new GroupMembershipPK();
                groupMembershipPK.setParentId(groupId);
                groupMembershipPK.setChildId(userIds.get(i));
                groupMembershipPK.setDomainId(domainId);
                new GroupMembershipRepository().delete(groupMembershipPK);
            }
            return true;
        }
        catch (Throwable ex) {
            logger.error(ex.getMessage(), ex);
            throw new SharingRegistryException().setMessage(ex.getMessage() + " Stack trace:" + ExceptionUtils.getStackTrace((Throwable)ex));
        }
    }

    public List<User> getGroupMembersOfTypeUser(String domainId, String groupId, int offset, int limit) throws SharingRegistryException, TException {
        try {
            List<User> groupMemberUsers = new GroupMembershipRepository().getAllChildUsers(domainId, groupId);
            return groupMemberUsers;
        }
        catch (Throwable ex) {
            logger.error(ex.getMessage(), ex);
            throw new SharingRegistryException().setMessage(ex.getMessage() + " Stack trace:" + ExceptionUtils.getStackTrace((Throwable)ex));
        }
    }

    public List<UserGroup> getGroupMembersOfTypeGroup(String domainId, String groupId, int offset, int limit) throws SharingRegistryException, TException {
        try {
            List<UserGroup> groupMemberGroups = new GroupMembershipRepository().getAllChildGroups(domainId, groupId);
            return groupMemberGroups;
        }
        catch (Throwable ex) {
            logger.error(ex.getMessage(), ex);
            throw new SharingRegistryException().setMessage(ex.getMessage() + " Stack trace:" + ExceptionUtils.getStackTrace((Throwable)ex));
        }
    }

    public boolean addChildGroupsToParentGroup(String domainId, List<String> childIds, String groupId) throws SharingRegistryException, TException {
        try {
            for (String childId : childIds) {
                GroupMembership groupMembership = new GroupMembership();
                groupMembership.setParentId(groupId);
                groupMembership.setChildId(childId);
                groupMembership.setChildType(GroupChildType.GROUP);
                groupMembership.setDomainId(domainId);
                groupMembership.setCreatedTime(System.currentTimeMillis());
                groupMembership.setUpdatedTime(System.currentTimeMillis());
                new GroupMembershipRepository().create(groupMembership);
            }
            return true;
        }
        catch (Throwable ex) {
            logger.error(ex.getMessage(), ex);
            throw new SharingRegistryException().setMessage(ex.getMessage() + " Stack trace:" + ExceptionUtils.getStackTrace((Throwable)ex));
        }
    }

    public boolean removeChildGroupFromParentGroup(String domainId, String childId, String groupId) throws SharingRegistryException, TException {
        try {
            GroupMembershipPK groupMembershipPK = new GroupMembershipPK();
            groupMembershipPK.setParentId(groupId);
            groupMembershipPK.setChildId(childId);
            groupMembershipPK.setDomainId(domainId);
            new GroupMembershipRepository().delete(groupMembershipPK);
            return true;
        }
        catch (Throwable ex) {
            logger.error(ex.getMessage(), ex);
            throw new SharingRegistryException().setMessage(ex.getMessage() + " Stack trace:" + ExceptionUtils.getStackTrace((Throwable)ex));
        }
    }

    public List<UserGroup> getAllMemberGroupsForUser(String domainId, String userId) throws SharingRegistryException, TException {
        try {
            GroupMembershipRepository groupMembershipRepository = new GroupMembershipRepository();
            return groupMembershipRepository.getAllMemberGroupsForUser(domainId, userId);
        }
        catch (Throwable ex) {
            logger.error(ex.getMessage(), ex);
            throw new SharingRegistryException().setMessage(ex.getMessage() + " Stack trace:" + ExceptionUtils.getStackTrace((Throwable)ex));
        }
    }

    public String createEntityType(EntityType entityType) throws SharingRegistryException, DuplicateEntryException, TException {
        try {
            EntityTypePK entityTypePK = new EntityTypePK();
            entityTypePK.setDomainId(entityType.domainId);
            entityTypePK.setEntityTypeId(entityType.entityTypeId);
            if (new EntityTypeRepository().get(entityTypePK) != null) {
                throw new DuplicateEntryException("There exist EntityType with given EntityType id");
            }
            entityType.setCreatedTime(System.currentTimeMillis());
            entityType.setUpdatedTime(System.currentTimeMillis());
            new EntityTypeRepository().create(entityType);
            return entityType.entityTypeId;
        }
        catch (Throwable ex) {
            logger.error(ex.getMessage(), ex);
            throw new SharingRegistryException().setMessage(ex.getMessage() + " Stack trace:" + ExceptionUtils.getStackTrace((Throwable)ex));
        }
    }

    public boolean updateEntityType(EntityType entityType) throws SharingRegistryException, TException {
        try {
            entityType.setUpdatedTime(System.currentTimeMillis());
            EntityTypePK entityTypePK = new EntityTypePK();
            entityTypePK.setDomainId(entityType.domainId);
            entityTypePK.setEntityTypeId(entityType.entityTypeId);
            EntityType oldEntityType = (EntityType)new EntityTypeRepository().get(entityTypePK);
            entityType.setCreatedTime(oldEntityType.createdTime);
            entityType = this.getUpdatedObject(oldEntityType, entityType);
            new EntityTypeRepository().update(entityType);
            return true;
        }
        catch (Throwable ex) {
            logger.error(ex.getMessage(), ex);
            throw new SharingRegistryException().setMessage(ex.getMessage() + " Stack trace:" + ExceptionUtils.getStackTrace((Throwable)ex));
        }
    }

    public boolean isEntityTypeExists(String domainId, String entityTypeId) throws SharingRegistryException, TException {
        try {
            EntityTypePK entityTypePK = new EntityTypePK();
            entityTypePK.setDomainId(domainId);
            entityTypePK.setEntityTypeId(entityTypeId);
            return new EntityTypeRepository().isExists(entityTypePK);
        }
        catch (Throwable ex) {
            logger.error(ex.getMessage(), ex);
            throw new SharingRegistryException().setMessage(ex.getMessage() + " Stack trace:" + ExceptionUtils.getStackTrace((Throwable)ex));
        }
    }

    public boolean deleteEntityType(String domainId, String entityTypeId) throws SharingRegistryException, TException {
        try {
            EntityTypePK entityTypePK = new EntityTypePK();
            entityTypePK.setDomainId(domainId);
            entityTypePK.setEntityTypeId(entityTypeId);
            new EntityTypeRepository().delete(entityTypePK);
            return true;
        }
        catch (Throwable ex) {
            logger.error(ex.getMessage(), ex);
            throw new SharingRegistryException().setMessage(ex.getMessage() + " Stack trace:" + ExceptionUtils.getStackTrace((Throwable)ex));
        }
    }

    public EntityType getEntityType(String domainId, String entityTypeId) throws SharingRegistryException, TException {
        try {
            EntityTypePK entityTypePK = new EntityTypePK();
            entityTypePK.setDomainId(domainId);
            entityTypePK.setEntityTypeId(entityTypeId);
            return (EntityType)new EntityTypeRepository().get(entityTypePK);
        }
        catch (Throwable ex) {
            logger.error(ex.getMessage(), ex);
            throw new SharingRegistryException().setMessage(ex.getMessage() + " Stack trace:" + ExceptionUtils.getStackTrace((Throwable)ex));
        }
    }

    public List<EntityType> getEntityTypes(String domain, int offset, int limit) throws TException {
        try {
            HashMap<String, String> filters = new HashMap<String, String>();
            filters.put("domainId", domain);
            return new EntityTypeRepository().select(filters, offset, limit);
        }
        catch (Throwable ex) {
            logger.error(ex.getMessage(), ex);
            throw new SharingRegistryException().setMessage(ex.getMessage() + " Stack trace:" + ExceptionUtils.getStackTrace((Throwable)ex));
        }
    }

    public String createPermissionType(PermissionType permissionType) throws SharingRegistryException, DuplicateEntryException, TException {
        try {
            PermissionTypePK permissionTypePK = new PermissionTypePK();
            permissionTypePK.setDomainId(permissionType.domainId);
            permissionTypePK.setPermissionTypeId(permissionType.permissionTypeId);
            if (new PermissionTypeRepository().get(permissionTypePK) != null) {
                throw new DuplicateEntryException("There exist PermissionType with given PermissionType id");
            }
            permissionType.setCreatedTime(System.currentTimeMillis());
            permissionType.setUpdatedTime(System.currentTimeMillis());
            new PermissionTypeRepository().create(permissionType);
            return permissionType.permissionTypeId;
        }
        catch (Throwable ex) {
            logger.error(ex.getMessage(), ex);
            throw new SharingRegistryException().setMessage(ex.getMessage() + " Stack trace:" + ExceptionUtils.getStackTrace((Throwable)ex));
        }
    }

    public boolean updatePermissionType(PermissionType permissionType) throws SharingRegistryException, TException {
        try {
            permissionType.setUpdatedTime(System.currentTimeMillis());
            PermissionTypePK permissionTypePK = new PermissionTypePK();
            permissionTypePK.setDomainId(permissionType.domainId);
            permissionTypePK.setPermissionTypeId(permissionType.permissionTypeId);
            PermissionType oldPermissionType = (PermissionType)new PermissionTypeRepository().get(permissionTypePK);
            permissionType = this.getUpdatedObject(oldPermissionType, permissionType);
            new PermissionTypeRepository().update(permissionType);
            return true;
        }
        catch (Throwable ex) {
            logger.error(ex.getMessage(), ex);
            throw new SharingRegistryException().setMessage(ex.getMessage() + " Stack trace:" + ExceptionUtils.getStackTrace((Throwable)ex));
        }
    }

    public boolean isPermissionExists(String domainId, String permissionId) throws SharingRegistryException, TException {
        try {
            PermissionTypePK permissionTypePK = new PermissionTypePK();
            permissionTypePK.setDomainId(domainId);
            permissionTypePK.setPermissionTypeId(permissionId);
            return new PermissionTypeRepository().isExists(permissionTypePK);
        }
        catch (Throwable ex) {
            logger.error(ex.getMessage(), ex);
            throw new SharingRegistryException().setMessage(ex.getMessage() + " Stack trace:" + ExceptionUtils.getStackTrace((Throwable)ex));
        }
    }

    public boolean deletePermissionType(String domainId, String permissionTypeId) throws SharingRegistryException, TException {
        try {
            PermissionTypePK permissionTypePK = new PermissionTypePK();
            permissionTypePK.setDomainId(domainId);
            permissionTypePK.setPermissionTypeId(permissionTypeId);
            new PermissionTypeRepository().delete(permissionTypePK);
            return true;
        }
        catch (Throwable ex) {
            logger.error(ex.getMessage(), ex);
            throw new SharingRegistryException().setMessage(ex.getMessage() + " Stack trace:" + ExceptionUtils.getStackTrace((Throwable)ex));
        }
    }

    public PermissionType getPermissionType(String domainId, String permissionTypeId) throws SharingRegistryException, TException {
        try {
            PermissionTypePK permissionTypePK = new PermissionTypePK();
            permissionTypePK.setDomainId(domainId);
            permissionTypePK.setPermissionTypeId(permissionTypeId);
            return (PermissionType)new PermissionTypeRepository().get(permissionTypePK);
        }
        catch (Throwable ex) {
            logger.error(ex.getMessage(), ex);
            throw new SharingRegistryException().setMessage(ex.getMessage() + " Stack trace:" + ExceptionUtils.getStackTrace((Throwable)ex));
        }
    }

    public List<PermissionType> getPermissionTypes(String domain, int offset, int limit) throws SharingRegistryException, TException {
        try {
            HashMap<String, String> filters = new HashMap<String, String>();
            filters.put("domainId", domain);
            return new PermissionTypeRepository().select(filters, offset, limit);
        }
        catch (Throwable ex) {
            logger.error(ex.getMessage(), ex);
            throw new SharingRegistryException().setMessage(ex.getMessage() + " Stack trace:" + ExceptionUtils.getStackTrace((Throwable)ex));
        }
    }

    public String createEntity(Entity entity) throws SharingRegistryException, DuplicateEntryException, TException {
        try {
            EntityPK entityPK = new EntityPK();
            entityPK.setDomainId(entity.domainId);
            entityPK.setEntityId(entity.entityId);
            if (new EntityRepository().get(entityPK) != null) {
                throw new DuplicateEntryException("There exist Entity with given Entity id");
            }
            UserPK userPK = new UserPK();
            userPK.setDomainId(entity.domainId);
            userPK.setUserId(entity.ownerId);
            if (!new UserRepository().isExists(userPK)) {
                User user = new User();
                user.setUserId(entity.getOwnerId());
                user.setDomainId(entity.domainId);
                user.setUserName(user.userId.split("@")[0]);
                this.createUser(user);
            }
            entity.setCreatedTime(System.currentTimeMillis());
            entity.setUpdatedTime(System.currentTimeMillis());
            if (entity.originalEntityCreationTime == 0L) {
                entity.originalEntityCreationTime = entity.createdTime;
            }
            new EntityRepository().create(entity);
            Sharing newSharing = new Sharing();
            newSharing.setPermissionTypeId(new PermissionTypeRepository().getOwnerPermissionTypeIdForDomain(entity.domainId));
            newSharing.setEntityId(entity.entityId);
            newSharing.setGroupId(entity.ownerId);
            newSharing.setSharingType(SharingType.DIRECT_CASCADING);
            newSharing.setInheritedParentId(entity.entityId);
            newSharing.setDomainId(entity.domainId);
            newSharing.setCreatedTime(System.currentTimeMillis());
            newSharing.setUpdatedTime(System.currentTimeMillis());
            new SharingRepository().create(newSharing);
            if (entity.getParentEntityId() != null && entity.getParentEntityId() != "") {
                List<Sharing> sharings = new SharingRepository().getCascadingPermissionsForEntity(entity.domainId, entity.parentEntityId);
                for (Sharing sharing : sharings) {
                    newSharing = new Sharing();
                    newSharing.setPermissionTypeId(sharing.permissionTypeId);
                    newSharing.setEntityId(entity.entityId);
                    newSharing.setGroupId(sharing.groupId);
                    newSharing.setInheritedParentId(sharing.inheritedParentId);
                    newSharing.setSharingType(SharingType.INDIRECT_CASCADING);
                    newSharing.setDomainId(entity.domainId);
                    newSharing.setCreatedTime(System.currentTimeMillis());
                    newSharing.setUpdatedTime(System.currentTimeMillis());
                    new SharingRepository().create(newSharing);
                }
            }
            return entity.entityId;
        }
        catch (Throwable ex) {
            logger.error(ex.getMessage(), ex);
            throw new SharingRegistryException().setMessage(ex.getMessage() + " Stack trace:" + ExceptionUtils.getStackTrace((Throwable)ex));
        }
    }

    public boolean updateEntity(Entity entity) throws SharingRegistryException, TException {
        try {
            entity.setUpdatedTime(System.currentTimeMillis());
            EntityPK entityPK = new EntityPK();
            entityPK.setDomainId(entity.domainId);
            entityPK.setEntityId(entity.entityId);
            Entity oldEntity = (Entity)new EntityRepository().get(entityPK);
            entity.setCreatedTime(oldEntity.createdTime);
            entity = this.getUpdatedObject(oldEntity, entity);
            entity.setSharedCount((long)new SharingRepository().getSharedCount(entity.domainId, entity.entityId));
            new EntityRepository().update(entity);
            return true;
        }
        catch (Throwable ex) {
            logger.error(ex.getMessage(), ex);
            throw new SharingRegistryException().setMessage(ex.getMessage() + " Stack trace:" + ExceptionUtils.getStackTrace((Throwable)ex));
        }
    }

    public boolean isEntityExists(String domainId, String entityId) throws SharingRegistryException, TException {
        try {
            EntityPK entityPK = new EntityPK();
            entityPK.setDomainId(domainId);
            entityPK.setEntityId(entityId);
            return new EntityRepository().isExists(entityPK);
        }
        catch (Throwable ex) {
            logger.error(ex.getMessage(), ex);
            throw new SharingRegistryException().setMessage(ex.getMessage() + " Stack trace:" + ExceptionUtils.getStackTrace((Throwable)ex));
        }
    }

    public boolean deleteEntity(String domainId, String entityId) throws SharingRegistryException, TException {
        try {
            EntityPK entityPK = new EntityPK();
            entityPK.setDomainId(domainId);
            entityPK.setEntityId(entityId);
            new EntityRepository().delete(entityPK);
            return true;
        }
        catch (Throwable ex) {
            logger.error(ex.getMessage(), ex);
            throw new SharingRegistryException().setMessage(ex.getMessage() + " Stack trace:" + ExceptionUtils.getStackTrace((Throwable)ex));
        }
    }

    public Entity getEntity(String domainId, String entityId) throws SharingRegistryException, TException {
        try {
            EntityPK entityPK = new EntityPK();
            entityPK.setDomainId(domainId);
            entityPK.setEntityId(entityId);
            return (Entity)new EntityRepository().get(entityPK);
        }
        catch (Throwable ex) {
            logger.error(ex.getMessage(), ex);
            throw new SharingRegistryException().setMessage(ex.getMessage() + " Stack trace:" + ExceptionUtils.getStackTrace((Throwable)ex));
        }
    }

    public List<Entity> searchEntities(String domainId, String userId, List<SearchCriteria> filters, int offset, int limit) throws SharingRegistryException, TException {
        try {
            ArrayList<String> groupIds = new ArrayList<String>();
            groupIds.add(userId);
            new GroupMembershipRepository().getAllParentMembershipsForChild(domainId, userId).stream().forEach(gm -> groupIds.add(gm.parentId));
            return new EntityRepository().searchEntities(domainId, groupIds, filters, offset, limit);
        }
        catch (Throwable ex) {
            logger.error(ex.getMessage(), ex);
            throw new SharingRegistryException().setMessage(ex.getMessage() + " Stack trace:" + ExceptionUtils.getStackTrace((Throwable)ex));
        }
    }

    public List<User> getListOfSharedUsers(String domainId, String entityId, String permissionTypeId) throws SharingRegistryException, TException {
        try {
            return new UserRepository().getAccessibleUsers(domainId, entityId, permissionTypeId);
        }
        catch (Throwable ex) {
            logger.error(ex.getMessage(), ex);
            throw new SharingRegistryException().setMessage(ex.getMessage() + " Stack trace:" + ExceptionUtils.getStackTrace((Throwable)ex));
        }
    }

    public List<UserGroup> getListOfSharedGroups(String domainId, String entityId, String permissionTypeId) throws SharingRegistryException, TException {
        try {
            return new UserGroupRepository().getAccessibleGroups(domainId, entityId, permissionTypeId);
        }
        catch (Throwable ex) {
            logger.error(ex.getMessage(), ex);
            throw new SharingRegistryException().setMessage(ex.getMessage() + " Stack trace:" + ExceptionUtils.getStackTrace((Throwable)ex));
        }
    }

    public boolean shareEntityWithUsers(String domainId, String entityId, List<String> userList, String permissionTypeId, boolean cascadePermission) throws SharingRegistryException, TException {
        try {
            return this.shareEntity(domainId, entityId, userList, permissionTypeId, cascadePermission);
        }
        catch (Throwable ex) {
            logger.error(ex.getMessage(), ex);
            throw new SharingRegistryException().setMessage(ex.getMessage() + " Stack trace:" + ExceptionUtils.getStackTrace((Throwable)ex));
        }
    }

    public boolean shareEntityWithGroups(String domainId, String entityId, List<String> groupList, String permissionTypeId, boolean cascadePermission) throws SharingRegistryException, TException {
        try {
            return this.shareEntity(domainId, entityId, groupList, permissionTypeId, cascadePermission);
        }
        catch (Throwable ex) {
            logger.error(ex.getMessage(), ex);
            throw new SharingRegistryException().setMessage(ex.getMessage() + " Stack trace:" + ExceptionUtils.getStackTrace((Throwable)ex));
        }
    }

    private boolean shareEntity(String domainId, String entityId, List<String> groupOrUserList, String permissionTypeId, boolean cascadePermission) throws SharingRegistryException, TException {
        try {
            if (permissionTypeId.equals(new PermissionTypeRepository().getOwnerPermissionTypeIdForDomain(domainId))) {
                throw new SharingRegistryException(OWNER_PERMISSION_NAME + " permission cannot be assigned or removed");
            }
            ArrayList<Sharing> sharings = new ArrayList<Sharing>();
            LinkedList temp = new LinkedList();
            for (String userId : groupOrUserList) {
                Sharing sharing = new Sharing();
                sharing.setPermissionTypeId(permissionTypeId);
                sharing.setEntityId(entityId);
                sharing.setGroupId(userId);
                sharing.setInheritedParentId(entityId);
                sharing.setDomainId(domainId);
                if (cascadePermission) {
                    sharing.setSharingType(SharingType.DIRECT_CASCADING);
                } else {
                    sharing.setSharingType(SharingType.DIRECT_NON_CASCADING);
                }
                sharing.setCreatedTime(System.currentTimeMillis());
                sharing.setUpdatedTime(System.currentTimeMillis());
                sharings.add(sharing);
            }
            if (cascadePermission) {
                new EntityRepository().getChildEntities(domainId, entityId).stream().forEach(e -> temp.addLast(e));
                while (temp.size() > 0) {
                    Entity entity = (Entity)temp.pop();
                    String childEntityId = entity.entityId;
                    for (String userId : groupOrUserList) {
                        Sharing sharing = new Sharing();
                        sharing.setPermissionTypeId(permissionTypeId);
                        sharing.setEntityId(childEntityId);
                        sharing.setGroupId(userId);
                        sharing.setInheritedParentId(entityId);
                        sharing.setSharingType(SharingType.INDIRECT_CASCADING);
                        sharing.setInheritedParentId(entityId);
                        sharing.setDomainId(domainId);
                        sharing.setCreatedTime(System.currentTimeMillis());
                        sharing.setUpdatedTime(System.currentTimeMillis());
                        sharings.add(sharing);
                        new EntityRepository().getChildEntities(domainId, childEntityId).stream().forEach(e -> temp.addLast(e));
                    }
                }
            }
            new SharingRepository().create(sharings);
            EntityPK entityPK = new EntityPK();
            entityPK.setDomainId(domainId);
            entityPK.setEntityId(entityId);
            Entity entity = (Entity)new EntityRepository().get(entityPK);
            entity.setSharedCount((long)new SharingRepository().getSharedCount(domainId, entityId));
            new EntityRepository().update(entity);
            return true;
        }
        catch (Throwable ex) {
            logger.error(ex.getMessage(), ex);
            throw new SharingRegistryException().setMessage(ex.getMessage() + " Stack trace:" + ExceptionUtils.getStackTrace((Throwable)ex));
        }
    }

    public boolean revokeEntitySharingFromUsers(String domainId, String entityId, List<String> userList, String permissionTypeId) throws SharingRegistryException, TException {
        try {
            if (permissionTypeId.equals(new PermissionTypeRepository().getOwnerPermissionTypeIdForDomain(domainId))) {
                throw new SharingRegistryException(OWNER_PERMISSION_NAME + " permission cannot be assigned or removed");
            }
            return this.revokeEntitySharing(domainId, entityId, userList, permissionTypeId);
        }
        catch (Throwable ex) {
            logger.error(ex.getMessage(), ex);
            throw new SharingRegistryException().setMessage(ex.getMessage() + " Stack trace:" + ExceptionUtils.getStackTrace((Throwable)ex));
        }
    }

    public boolean revokeEntitySharingFromGroups(String domainId, String entityId, List<String> groupList, String permissionTypeId) throws SharingRegistryException, TException {
        try {
            if (permissionTypeId.equals(new PermissionTypeRepository().getOwnerPermissionTypeIdForDomain(domainId))) {
                throw new SharingRegistryException(OWNER_PERMISSION_NAME + " permission cannot be assigned or removed");
            }
            return this.revokeEntitySharing(domainId, entityId, groupList, permissionTypeId);
        }
        catch (Throwable ex) {
            logger.error(ex.getMessage(), ex);
            throw new SharingRegistryException().setMessage(ex.getMessage() + " Stack trace:" + ExceptionUtils.getStackTrace((Throwable)ex));
        }
    }

    public boolean userHasAccess(String domainId, String userId, String entityId, String permissionTypeId) throws SharingRegistryException, TException {
        try {
            List<GroupMembership> parentMemberships = new GroupMembershipRepository().getAllParentMembershipsForChild(domainId, userId);
            ArrayList<String> groupIds = new ArrayList<String>();
            parentMemberships.stream().forEach(pm -> groupIds.add(pm.parentId));
            groupIds.add(userId);
            return new SharingRepository().hasAccess(domainId, entityId, groupIds, Arrays.asList(permissionTypeId, new PermissionTypeRepository().getOwnerPermissionTypeIdForDomain(domainId)));
        }
        catch (Throwable ex) {
            logger.error(ex.getMessage(), ex);
            throw new SharingRegistryException().setMessage(ex.getMessage() + " Stack trace:" + ExceptionUtils.getStackTrace((Throwable)ex));
        }
    }

    public boolean revokeEntitySharing(String domainId, String entityId, List<String> groupOrUserList, String permissionTypeId) throws SharingRegistryException {
        try {
            if (permissionTypeId.equals(new PermissionTypeRepository().getOwnerPermissionTypeIdForDomain(domainId))) {
                throw new SharingRegistryException(OWNER_PERMISSION_NAME + " permission cannot be removed");
            }
            for (String string : groupOrUserList) {
                SharingPK sharingPK = new SharingPK();
                sharingPK.setEntityId(entityId);
                sharingPK.setGroupId(string);
                sharingPK.setPermissionTypeId(permissionTypeId);
                sharingPK.setInheritedParentId(entityId);
                sharingPK.setDomainId(domainId);
                new SharingRepository().delete(sharingPK);
            }
            ArrayList temp = new ArrayList();
            new SharingRepository().getIndirectSharedChildren(domainId, entityId, permissionTypeId).stream().forEach(s -> temp.add(s));
            for (Sharing sharing : temp) {
                String childEntityId = sharing.entityId;
                for (String groupId : groupOrUserList) {
                    SharingPK sharingPK = new SharingPK();
                    sharingPK.setEntityId(childEntityId);
                    sharingPK.setGroupId(groupId);
                    sharingPK.setPermissionTypeId(permissionTypeId);
                    sharingPK.setInheritedParentId(entityId);
                    sharingPK.setDomainId(domainId);
                    new SharingRepository().delete(sharingPK);
                }
            }
            EntityPK entityPK = new EntityPK();
            entityPK.setDomainId(domainId);
            entityPK.setEntityId(entityId);
            Entity entity = (Entity)new EntityRepository().get(entityPK);
            entity.setSharedCount((long)new SharingRepository().getSharedCount(domainId, entityId));
            new EntityRepository().update(entity);
            return true;
        }
        catch (Throwable ex) {
            logger.error(ex.getMessage(), ex);
            throw new SharingRegistryException().setMessage(ex.getMessage() + " Stack trace:" + ExceptionUtils.getStackTrace((Throwable)ex));
        }
    }

    private <T> T getUpdatedObject(T oldEntity, T newEntity) throws SharingRegistryException {
        Field[] oldEntityFields;
        Field[] newEntityFields = newEntity.getClass().getDeclaredFields();
        Hashtable<String, Object> newHT = SharingRegistryServerHandler.fieldsToHT(newEntityFields, newEntity);
        Class<?> oldEntityClass = oldEntity.getClass();
        for (Field field : oldEntityFields = oldEntityClass.getDeclaredFields()) {
            if (Modifier.isFinal(field.getModifiers())) continue;
            field.setAccessible(true);
            Object o = newHT.get(field.getName());
            if (o == null) continue;
            Field f = null;
            try {
                f = oldEntityClass.getDeclaredField(field.getName());
                f.setAccessible(true);
                logger.debug("setting " + f.getName());
                f.set(oldEntity, o);
            }
            catch (Exception e) {
                throw new SharingRegistryException(e.getMessage());
            }
        }
        return oldEntity;
    }

    private static Hashtable<String, Object> fieldsToHT(Field[] fields, Object obj) {
        Hashtable<String, Object> hashtable = new Hashtable<String, Object>();
        for (Field field : fields) {
            field.setAccessible(true);
            try {
                Object retrievedObject = field.get(obj);
                if (retrievedObject == null) continue;
                logger.debug("scanning " + field.getName());
                hashtable.put(field.getName(), field.get(obj));
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
        }
        return hashtable;
    }
}

